/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.cleanrooms;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoom;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomsService;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomOutputCatalogRequest;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomOutputCatalogResponse;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomRequest;
import com.databricks.internal.sdk.service.cleanrooms.DeleteCleanRoomRequest;
import com.databricks.internal.sdk.service.cleanrooms.DeleteResponse;
import com.databricks.internal.sdk.service.cleanrooms.GetCleanRoomRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomsRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomsResponse;
import com.databricks.internal.sdk.service.cleanrooms.UpdateCleanRoomRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class CleanRoomsImpl
implements CleanRoomsService {
    private final ApiClient apiClient;

    public CleanRoomsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CleanRoom create(CreateCleanRoomRequest request) {
        String path = "/api/2.0/clean-rooms";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getCleanRoom()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CleanRoom.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateCleanRoomOutputCatalogResponse createOutputCatalog(CreateCleanRoomOutputCatalogRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/output-catalogs", request.getCleanRoomName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getOutputCatalog()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateCleanRoomOutputCatalogResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteCleanRoomRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CleanRoom get(GetCleanRoomRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CleanRoom.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListCleanRoomsResponse list(ListCleanRoomsRequest request) {
        String path = "/api/2.0/clean-rooms";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListCleanRoomsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CleanRoom update(UpdateCleanRoomRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CleanRoom.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

