/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.files;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Encoding;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.files.CreateDirectoryRequest;
import com.databricks.internal.sdk.service.files.CreateDirectoryResponse;
import com.databricks.internal.sdk.service.files.DeleteDirectoryRequest;
import com.databricks.internal.sdk.service.files.DeleteDirectoryResponse;
import com.databricks.internal.sdk.service.files.DeleteFileRequest;
import com.databricks.internal.sdk.service.files.DeleteResponse;
import com.databricks.internal.sdk.service.files.DownloadRequest;
import com.databricks.internal.sdk.service.files.DownloadResponse;
import com.databricks.internal.sdk.service.files.FilesService;
import com.databricks.internal.sdk.service.files.GetDirectoryMetadataRequest;
import com.databricks.internal.sdk.service.files.GetDirectoryMetadataResponse;
import com.databricks.internal.sdk.service.files.GetMetadataRequest;
import com.databricks.internal.sdk.service.files.GetMetadataResponse;
import com.databricks.internal.sdk.service.files.ListDirectoryContentsRequest;
import com.databricks.internal.sdk.service.files.ListDirectoryResponse;
import com.databricks.internal.sdk.service.files.UploadRequest;
import com.databricks.internal.sdk.service.files.UploadResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class FilesImpl
implements FilesService {
    private final ApiClient apiClient;

    public FilesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void createDirectory(CreateDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        try {
            Request req = new Request("PUT", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, CreateDirectoryResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteFileRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteDirectory(DeleteDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, DeleteDirectoryResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DownloadResponse download(DownloadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/octet-stream");
            return this.apiClient.execute(req, DownloadResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void getDirectoryMetadata(GetDirectoryMetadataRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        try {
            Request req = new Request("HEAD", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, GetDirectoryMetadataResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetMetadataResponse getMetadata(GetMetadataRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        try {
            Request req = new Request("HEAD", path);
            ApiClient.setQuery(req, request);
            return this.apiClient.execute(req, GetMetadataResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListDirectoryResponse listDirectoryContents(ListDirectoryContentsRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", Encoding.encodeMultiSegmentPathParameter(request.getDirectoryPath()));
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListDirectoryResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void upload(UploadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", Encoding.encodeMultiSegmentPathParameter(request.getFilePath()));
        try {
            Request req = new Request("PUT", path, request.getContents());
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/octet-stream");
            this.apiClient.execute(req, UploadResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

