/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.iam.DeleteWorkspaceAssignmentRequest;
import com.databricks.internal.sdk.service.iam.DeleteWorkspacePermissionAssignmentResponse;
import com.databricks.internal.sdk.service.iam.GetWorkspaceAssignmentRequest;
import com.databricks.internal.sdk.service.iam.ListWorkspaceAssignmentRequest;
import com.databricks.internal.sdk.service.iam.PermissionAssignment;
import com.databricks.internal.sdk.service.iam.PermissionAssignments;
import com.databricks.internal.sdk.service.iam.UpdateWorkspaceAssignments;
import com.databricks.internal.sdk.service.iam.WorkspaceAssignmentService;
import com.databricks.internal.sdk.service.iam.WorkspacePermissions;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceAssignmentImpl
implements WorkspaceAssignmentService {
    private final ApiClient apiClient;

    public WorkspaceAssignmentImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(DeleteWorkspaceAssignmentRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/permissionassignments/principals/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId(), request.getPrincipalId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteWorkspacePermissionAssignmentResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WorkspacePermissions get(GetWorkspaceAssignmentRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/permissionassignments/permissions", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WorkspacePermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PermissionAssignments list(ListWorkspaceAssignmentRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/permissionassignments", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, PermissionAssignments.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PermissionAssignment update(UpdateWorkspaceAssignments request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/permissionassignments/principals/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId(), request.getPrincipalId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PermissionAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

