/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.CreateFileRequest;
import com.databricks.internal.sdk.service.marketplace.CreateFileResponse;
import com.databricks.internal.sdk.service.marketplace.DeleteFileRequest;
import com.databricks.internal.sdk.service.marketplace.FileInfo;
import com.databricks.internal.sdk.service.marketplace.FileParent;
import com.databricks.internal.sdk.service.marketplace.GetFileRequest;
import com.databricks.internal.sdk.service.marketplace.GetFileResponse;
import com.databricks.internal.sdk.service.marketplace.ListFilesRequest;
import com.databricks.internal.sdk.service.marketplace.ListFilesResponse;
import com.databricks.internal.sdk.service.marketplace.MarketplaceFileType;
import com.databricks.internal.sdk.service.marketplace.ProviderFilesImpl;
import com.databricks.internal.sdk.service.marketplace.ProviderFilesService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProviderFilesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderFilesAPI.class);
    private final ProviderFilesService impl;

    public ProviderFilesAPI(ApiClient apiClient) {
        this.impl = new ProviderFilesImpl(apiClient);
    }

    public ProviderFilesAPI(ProviderFilesService mock) {
        this.impl = mock;
    }

    public CreateFileResponse create(FileParent fileParent, MarketplaceFileType marketplaceFileType, String mimeType) {
        return this.create(new CreateFileRequest().setFileParent(fileParent).setMarketplaceFileType(marketplaceFileType).setMimeType(mimeType));
    }

    public CreateFileResponse create(CreateFileRequest request) {
        return this.impl.create(request);
    }

    public void delete(String fileId) {
        this.delete(new DeleteFileRequest().setFileId(fileId));
    }

    public void delete(DeleteFileRequest request) {
        this.impl.delete(request);
    }

    public GetFileResponse get(String fileId) {
        return this.get(new GetFileRequest().setFileId(fileId));
    }

    public GetFileResponse get(GetFileRequest request) {
        return this.impl.get(request);
    }

    public Iterable<FileInfo> list(FileParent fileParent) {
        return this.list(new ListFilesRequest().setFileParent(fileParent));
    }

    public Iterable<FileInfo> list(ListFilesRequest request) {
        return new Paginator(request, this.impl::list, ListFilesResponse::getFileInfos, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ProviderFilesService impl() {
        return this.impl;
    }
}

