/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.ml;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.ml.CreateExperiment;
import com.databricks.internal.sdk.service.ml.CreateExperimentResponse;
import com.databricks.internal.sdk.service.ml.CreateLoggedModelRequest;
import com.databricks.internal.sdk.service.ml.CreateLoggedModelResponse;
import com.databricks.internal.sdk.service.ml.CreateRun;
import com.databricks.internal.sdk.service.ml.CreateRunResponse;
import com.databricks.internal.sdk.service.ml.DeleteExperiment;
import com.databricks.internal.sdk.service.ml.DeleteLoggedModelRequest;
import com.databricks.internal.sdk.service.ml.DeleteLoggedModelTagRequest;
import com.databricks.internal.sdk.service.ml.DeleteRun;
import com.databricks.internal.sdk.service.ml.DeleteRuns;
import com.databricks.internal.sdk.service.ml.DeleteRunsResponse;
import com.databricks.internal.sdk.service.ml.DeleteTag;
import com.databricks.internal.sdk.service.ml.Experiment;
import com.databricks.internal.sdk.service.ml.ExperimentPermissions;
import com.databricks.internal.sdk.service.ml.ExperimentPermissionsRequest;
import com.databricks.internal.sdk.service.ml.ExperimentsImpl;
import com.databricks.internal.sdk.service.ml.ExperimentsService;
import com.databricks.internal.sdk.service.ml.FileInfo;
import com.databricks.internal.sdk.service.ml.FinalizeLoggedModelRequest;
import com.databricks.internal.sdk.service.ml.FinalizeLoggedModelResponse;
import com.databricks.internal.sdk.service.ml.GetByNameRequest;
import com.databricks.internal.sdk.service.ml.GetCredentialsForTraceDataDownloadRequest;
import com.databricks.internal.sdk.service.ml.GetCredentialsForTraceDataDownloadResponse;
import com.databricks.internal.sdk.service.ml.GetCredentialsForTraceDataUploadRequest;
import com.databricks.internal.sdk.service.ml.GetCredentialsForTraceDataUploadResponse;
import com.databricks.internal.sdk.service.ml.GetExperimentByNameResponse;
import com.databricks.internal.sdk.service.ml.GetExperimentPermissionLevelsRequest;
import com.databricks.internal.sdk.service.ml.GetExperimentPermissionLevelsResponse;
import com.databricks.internal.sdk.service.ml.GetExperimentPermissionsRequest;
import com.databricks.internal.sdk.service.ml.GetExperimentRequest;
import com.databricks.internal.sdk.service.ml.GetExperimentResponse;
import com.databricks.internal.sdk.service.ml.GetHistoryRequest;
import com.databricks.internal.sdk.service.ml.GetLoggedModelRequest;
import com.databricks.internal.sdk.service.ml.GetLoggedModelResponse;
import com.databricks.internal.sdk.service.ml.GetMetricHistoryResponse;
import com.databricks.internal.sdk.service.ml.GetRunRequest;
import com.databricks.internal.sdk.service.ml.GetRunResponse;
import com.databricks.internal.sdk.service.ml.ListArtifactsRequest;
import com.databricks.internal.sdk.service.ml.ListArtifactsResponse;
import com.databricks.internal.sdk.service.ml.ListExperimentsRequest;
import com.databricks.internal.sdk.service.ml.ListExperimentsResponse;
import com.databricks.internal.sdk.service.ml.ListLoggedModelArtifactsRequest;
import com.databricks.internal.sdk.service.ml.ListLoggedModelArtifactsResponse;
import com.databricks.internal.sdk.service.ml.LogBatch;
import com.databricks.internal.sdk.service.ml.LogInputs;
import com.databricks.internal.sdk.service.ml.LogLoggedModelParamsRequest;
import com.databricks.internal.sdk.service.ml.LogMetric;
import com.databricks.internal.sdk.service.ml.LogModel;
import com.databricks.internal.sdk.service.ml.LogOutputsRequest;
import com.databricks.internal.sdk.service.ml.LogParam;
import com.databricks.internal.sdk.service.ml.LoggedModelStatus;
import com.databricks.internal.sdk.service.ml.Metric;
import com.databricks.internal.sdk.service.ml.RestoreExperiment;
import com.databricks.internal.sdk.service.ml.RestoreRun;
import com.databricks.internal.sdk.service.ml.RestoreRuns;
import com.databricks.internal.sdk.service.ml.RestoreRunsResponse;
import com.databricks.internal.sdk.service.ml.Run;
import com.databricks.internal.sdk.service.ml.SearchExperiments;
import com.databricks.internal.sdk.service.ml.SearchExperimentsResponse;
import com.databricks.internal.sdk.service.ml.SearchLoggedModelsRequest;
import com.databricks.internal.sdk.service.ml.SearchLoggedModelsResponse;
import com.databricks.internal.sdk.service.ml.SearchRuns;
import com.databricks.internal.sdk.service.ml.SearchRunsResponse;
import com.databricks.internal.sdk.service.ml.SetExperimentTag;
import com.databricks.internal.sdk.service.ml.SetLoggedModelTagsRequest;
import com.databricks.internal.sdk.service.ml.SetTag;
import com.databricks.internal.sdk.service.ml.UpdateExperiment;
import com.databricks.internal.sdk.service.ml.UpdateRun;
import com.databricks.internal.sdk.service.ml.UpdateRunResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ExperimentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentsAPI.class);
    private final ExperimentsService impl;

    public ExperimentsAPI(ApiClient apiClient) {
        this.impl = new ExperimentsImpl(apiClient);
    }

    public ExperimentsAPI(ExperimentsService mock) {
        this.impl = mock;
    }

    public CreateExperimentResponse createExperiment(String name) {
        return this.createExperiment(new CreateExperiment().setName(name));
    }

    public CreateExperimentResponse createExperiment(CreateExperiment request) {
        return this.impl.createExperiment(request);
    }

    public CreateLoggedModelResponse createLoggedModel(String experimentId) {
        return this.createLoggedModel(new CreateLoggedModelRequest().setExperimentId(experimentId));
    }

    public CreateLoggedModelResponse createLoggedModel(CreateLoggedModelRequest request) {
        return this.impl.createLoggedModel(request);
    }

    public CreateRunResponse createRun(CreateRun request) {
        return this.impl.createRun(request);
    }

    public void deleteExperiment(String experimentId) {
        this.deleteExperiment(new DeleteExperiment().setExperimentId(experimentId));
    }

    public void deleteExperiment(DeleteExperiment request) {
        this.impl.deleteExperiment(request);
    }

    public void deleteLoggedModel(String modelId) {
        this.deleteLoggedModel(new DeleteLoggedModelRequest().setModelId(modelId));
    }

    public void deleteLoggedModel(DeleteLoggedModelRequest request) {
        this.impl.deleteLoggedModel(request);
    }

    public void deleteLoggedModelTag(String modelId, String tagKey) {
        this.deleteLoggedModelTag(new DeleteLoggedModelTagRequest().setModelId(modelId).setTagKey(tagKey));
    }

    public void deleteLoggedModelTag(DeleteLoggedModelTagRequest request) {
        this.impl.deleteLoggedModelTag(request);
    }

    public void deleteRun(String runId) {
        this.deleteRun(new DeleteRun().setRunId(runId));
    }

    public void deleteRun(DeleteRun request) {
        this.impl.deleteRun(request);
    }

    public DeleteRunsResponse deleteRuns(String experimentId, long maxTimestampMillis) {
        return this.deleteRuns(new DeleteRuns().setExperimentId(experimentId).setMaxTimestampMillis(maxTimestampMillis));
    }

    public DeleteRunsResponse deleteRuns(DeleteRuns request) {
        return this.impl.deleteRuns(request);
    }

    public void deleteTag(String runId, String key) {
        this.deleteTag(new DeleteTag().setRunId(runId).setKey(key));
    }

    public void deleteTag(DeleteTag request) {
        this.impl.deleteTag(request);
    }

    public FinalizeLoggedModelResponse finalizeLoggedModel(String modelId, LoggedModelStatus status) {
        return this.finalizeLoggedModel(new FinalizeLoggedModelRequest().setModelId(modelId).setStatus(status));
    }

    public FinalizeLoggedModelResponse finalizeLoggedModel(FinalizeLoggedModelRequest request) {
        return this.impl.finalizeLoggedModel(request);
    }

    public GetExperimentByNameResponse getByName(String experimentName) {
        return this.getByName(new GetByNameRequest().setExperimentName(experimentName));
    }

    public GetExperimentByNameResponse getByName(GetByNameRequest request) {
        return this.impl.getByName(request);
    }

    public GetCredentialsForTraceDataDownloadResponse getCredentialsForTraceDataDownload(String requestId) {
        return this.getCredentialsForTraceDataDownload(new GetCredentialsForTraceDataDownloadRequest().setRequestId(requestId));
    }

    public GetCredentialsForTraceDataDownloadResponse getCredentialsForTraceDataDownload(GetCredentialsForTraceDataDownloadRequest request) {
        return this.impl.getCredentialsForTraceDataDownload(request);
    }

    public GetCredentialsForTraceDataUploadResponse getCredentialsForTraceDataUpload(String requestId) {
        return this.getCredentialsForTraceDataUpload(new GetCredentialsForTraceDataUploadRequest().setRequestId(requestId));
    }

    public GetCredentialsForTraceDataUploadResponse getCredentialsForTraceDataUpload(GetCredentialsForTraceDataUploadRequest request) {
        return this.impl.getCredentialsForTraceDataUpload(request);
    }

    public GetExperimentResponse getExperiment(String experimentId) {
        return this.getExperiment(new GetExperimentRequest().setExperimentId(experimentId));
    }

    public GetExperimentResponse getExperiment(GetExperimentRequest request) {
        return this.impl.getExperiment(request);
    }

    public Iterable<Metric> getHistory(String metricKey) {
        return this.getHistory(new GetHistoryRequest().setMetricKey(metricKey));
    }

    public Iterable<Metric> getHistory(GetHistoryRequest request) {
        return new Paginator(request, this.impl::getHistory, GetMetricHistoryResponse::getMetrics, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public GetLoggedModelResponse getLoggedModel(String modelId) {
        return this.getLoggedModel(new GetLoggedModelRequest().setModelId(modelId));
    }

    public GetLoggedModelResponse getLoggedModel(GetLoggedModelRequest request) {
        return this.impl.getLoggedModel(request);
    }

    public GetExperimentPermissionLevelsResponse getPermissionLevels(String experimentId) {
        return this.getPermissionLevels(new GetExperimentPermissionLevelsRequest().setExperimentId(experimentId));
    }

    public GetExperimentPermissionLevelsResponse getPermissionLevels(GetExperimentPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public ExperimentPermissions getPermissions(String experimentId) {
        return this.getPermissions(new GetExperimentPermissionsRequest().setExperimentId(experimentId));
    }

    public ExperimentPermissions getPermissions(GetExperimentPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public GetRunResponse getRun(String runId) {
        return this.getRun(new GetRunRequest().setRunId(runId));
    }

    public GetRunResponse getRun(GetRunRequest request) {
        return this.impl.getRun(request);
    }

    public Iterable<FileInfo> listArtifacts(ListArtifactsRequest request) {
        return new Paginator(request, this.impl::listArtifacts, ListArtifactsResponse::getFiles, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Experiment> listExperiments(ListExperimentsRequest request) {
        return new Paginator(request, this.impl::listExperiments, ListExperimentsResponse::getExperiments, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ListLoggedModelArtifactsResponse listLoggedModelArtifacts(String modelId) {
        return this.listLoggedModelArtifacts(new ListLoggedModelArtifactsRequest().setModelId(modelId));
    }

    public ListLoggedModelArtifactsResponse listLoggedModelArtifacts(ListLoggedModelArtifactsRequest request) {
        return this.impl.listLoggedModelArtifacts(request);
    }

    public void logBatch(LogBatch request) {
        this.impl.logBatch(request);
    }

    public void logInputs(String runId) {
        this.logInputs(new LogInputs().setRunId(runId));
    }

    public void logInputs(LogInputs request) {
        this.impl.logInputs(request);
    }

    public void logLoggedModelParams(String modelId) {
        this.logLoggedModelParams(new LogLoggedModelParamsRequest().setModelId(modelId));
    }

    public void logLoggedModelParams(LogLoggedModelParamsRequest request) {
        this.impl.logLoggedModelParams(request);
    }

    public void logMetric(String key, double value, long timestamp) {
        this.logMetric(new LogMetric().setKey(key).setValue(value).setTimestamp(timestamp));
    }

    public void logMetric(LogMetric request) {
        this.impl.logMetric(request);
    }

    public void logModel(LogModel request) {
        this.impl.logModel(request);
    }

    public void logOutputs(String runId) {
        this.logOutputs(new LogOutputsRequest().setRunId(runId));
    }

    public void logOutputs(LogOutputsRequest request) {
        this.impl.logOutputs(request);
    }

    public void logParam(String key, String value) {
        this.logParam(new LogParam().setKey(key).setValue(value));
    }

    public void logParam(LogParam request) {
        this.impl.logParam(request);
    }

    public void restoreExperiment(String experimentId) {
        this.restoreExperiment(new RestoreExperiment().setExperimentId(experimentId));
    }

    public void restoreExperiment(RestoreExperiment request) {
        this.impl.restoreExperiment(request);
    }

    public void restoreRun(String runId) {
        this.restoreRun(new RestoreRun().setRunId(runId));
    }

    public void restoreRun(RestoreRun request) {
        this.impl.restoreRun(request);
    }

    public RestoreRunsResponse restoreRuns(String experimentId, long minTimestampMillis) {
        return this.restoreRuns(new RestoreRuns().setExperimentId(experimentId).setMinTimestampMillis(minTimestampMillis));
    }

    public RestoreRunsResponse restoreRuns(RestoreRuns request) {
        return this.impl.restoreRuns(request);
    }

    public Iterable<Experiment> searchExperiments(SearchExperiments request) {
        return new Paginator(request, this.impl::searchExperiments, SearchExperimentsResponse::getExperiments, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public SearchLoggedModelsResponse searchLoggedModels(SearchLoggedModelsRequest request) {
        return this.impl.searchLoggedModels(request);
    }

    public Iterable<Run> searchRuns(SearchRuns request) {
        return new Paginator(request, this.impl::searchRuns, SearchRunsResponse::getRuns, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void setExperimentTag(String experimentId, String key, String value) {
        this.setExperimentTag(new SetExperimentTag().setExperimentId(experimentId).setKey(key).setValue(value));
    }

    public void setExperimentTag(SetExperimentTag request) {
        this.impl.setExperimentTag(request);
    }

    public void setLoggedModelTags(String modelId) {
        this.setLoggedModelTags(new SetLoggedModelTagsRequest().setModelId(modelId));
    }

    public void setLoggedModelTags(SetLoggedModelTagsRequest request) {
        this.impl.setLoggedModelTags(request);
    }

    public ExperimentPermissions setPermissions(String experimentId) {
        return this.setPermissions(new ExperimentPermissionsRequest().setExperimentId(experimentId));
    }

    public ExperimentPermissions setPermissions(ExperimentPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public void setTag(String key, String value) {
        this.setTag(new SetTag().setKey(key).setValue(value));
    }

    public void setTag(SetTag request) {
        this.impl.setTag(request);
    }

    public void updateExperiment(String experimentId) {
        this.updateExperiment(new UpdateExperiment().setExperimentId(experimentId));
    }

    public void updateExperiment(UpdateExperiment request) {
        this.impl.updateExperiment(request);
    }

    public ExperimentPermissions updatePermissions(String experimentId) {
        return this.updatePermissions(new ExperimentPermissionsRequest().setExperimentId(experimentId));
    }

    public ExperimentPermissions updatePermissions(ExperimentPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public UpdateRunResponse updateRun(UpdateRun request) {
        return this.impl.updateRun(request);
    }

    public ExperimentsService impl() {
        return this.impl;
    }
}

