/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.ml;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.ml.ApproveTransitionRequest;
import com.databricks.internal.sdk.service.ml.ApproveTransitionRequestResponse;
import com.databricks.internal.sdk.service.ml.CreateComment;
import com.databricks.internal.sdk.service.ml.CreateCommentResponse;
import com.databricks.internal.sdk.service.ml.CreateModelRequest;
import com.databricks.internal.sdk.service.ml.CreateModelResponse;
import com.databricks.internal.sdk.service.ml.CreateModelVersionRequest;
import com.databricks.internal.sdk.service.ml.CreateModelVersionResponse;
import com.databricks.internal.sdk.service.ml.CreateRegistryWebhook;
import com.databricks.internal.sdk.service.ml.CreateTransitionRequest;
import com.databricks.internal.sdk.service.ml.CreateTransitionRequestResponse;
import com.databricks.internal.sdk.service.ml.CreateWebhookResponse;
import com.databricks.internal.sdk.service.ml.DeleteCommentRequest;
import com.databricks.internal.sdk.service.ml.DeleteCommentResponse;
import com.databricks.internal.sdk.service.ml.DeleteModelRequest;
import com.databricks.internal.sdk.service.ml.DeleteModelResponse;
import com.databricks.internal.sdk.service.ml.DeleteModelTagRequest;
import com.databricks.internal.sdk.service.ml.DeleteModelTagResponse;
import com.databricks.internal.sdk.service.ml.DeleteModelVersionRequest;
import com.databricks.internal.sdk.service.ml.DeleteModelVersionResponse;
import com.databricks.internal.sdk.service.ml.DeleteModelVersionTagRequest;
import com.databricks.internal.sdk.service.ml.DeleteModelVersionTagResponse;
import com.databricks.internal.sdk.service.ml.DeleteTransitionRequestRequest;
import com.databricks.internal.sdk.service.ml.DeleteTransitionRequestResponse;
import com.databricks.internal.sdk.service.ml.DeleteWebhookRequest;
import com.databricks.internal.sdk.service.ml.DeleteWebhookResponse;
import com.databricks.internal.sdk.service.ml.GetLatestVersionsRequest;
import com.databricks.internal.sdk.service.ml.GetLatestVersionsResponse;
import com.databricks.internal.sdk.service.ml.GetModelRequest;
import com.databricks.internal.sdk.service.ml.GetModelResponse;
import com.databricks.internal.sdk.service.ml.GetModelVersionDownloadUriRequest;
import com.databricks.internal.sdk.service.ml.GetModelVersionDownloadUriResponse;
import com.databricks.internal.sdk.service.ml.GetModelVersionRequest;
import com.databricks.internal.sdk.service.ml.GetModelVersionResponse;
import com.databricks.internal.sdk.service.ml.GetRegisteredModelPermissionLevelsRequest;
import com.databricks.internal.sdk.service.ml.GetRegisteredModelPermissionLevelsResponse;
import com.databricks.internal.sdk.service.ml.GetRegisteredModelPermissionsRequest;
import com.databricks.internal.sdk.service.ml.ListModelsRequest;
import com.databricks.internal.sdk.service.ml.ListModelsResponse;
import com.databricks.internal.sdk.service.ml.ListRegistryWebhooks;
import com.databricks.internal.sdk.service.ml.ListTransitionRequestsRequest;
import com.databricks.internal.sdk.service.ml.ListTransitionRequestsResponse;
import com.databricks.internal.sdk.service.ml.ListWebhooksRequest;
import com.databricks.internal.sdk.service.ml.ModelRegistryService;
import com.databricks.internal.sdk.service.ml.RegisteredModelPermissions;
import com.databricks.internal.sdk.service.ml.RegisteredModelPermissionsRequest;
import com.databricks.internal.sdk.service.ml.RejectTransitionRequest;
import com.databricks.internal.sdk.service.ml.RejectTransitionRequestResponse;
import com.databricks.internal.sdk.service.ml.RenameModelRequest;
import com.databricks.internal.sdk.service.ml.RenameModelResponse;
import com.databricks.internal.sdk.service.ml.SearchModelVersionsRequest;
import com.databricks.internal.sdk.service.ml.SearchModelVersionsResponse;
import com.databricks.internal.sdk.service.ml.SearchModelsRequest;
import com.databricks.internal.sdk.service.ml.SearchModelsResponse;
import com.databricks.internal.sdk.service.ml.SetModelTagRequest;
import com.databricks.internal.sdk.service.ml.SetModelTagResponse;
import com.databricks.internal.sdk.service.ml.SetModelVersionTagRequest;
import com.databricks.internal.sdk.service.ml.SetModelVersionTagResponse;
import com.databricks.internal.sdk.service.ml.TestRegistryWebhookRequest;
import com.databricks.internal.sdk.service.ml.TestRegistryWebhookResponse;
import com.databricks.internal.sdk.service.ml.TransitionModelVersionStageDatabricks;
import com.databricks.internal.sdk.service.ml.TransitionStageResponse;
import com.databricks.internal.sdk.service.ml.UpdateComment;
import com.databricks.internal.sdk.service.ml.UpdateCommentResponse;
import com.databricks.internal.sdk.service.ml.UpdateModelRequest;
import com.databricks.internal.sdk.service.ml.UpdateModelResponse;
import com.databricks.internal.sdk.service.ml.UpdateModelVersionRequest;
import com.databricks.internal.sdk.service.ml.UpdateModelVersionResponse;
import com.databricks.internal.sdk.service.ml.UpdateRegistryWebhook;
import com.databricks.internal.sdk.service.ml.UpdateWebhookResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class ModelRegistryImpl
implements ModelRegistryService {
    private final ApiClient apiClient;

    public ModelRegistryImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ApproveTransitionRequestResponse approveTransitionRequest(ApproveTransitionRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/approve";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ApproveTransitionRequestResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateCommentResponse createComment(CreateComment request) {
        String path = "/api/2.0/mlflow/comments/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateCommentResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateModelResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateModelVersionResponse createModelVersion(CreateModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateModelVersionResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateTransitionRequestResponse createTransitionRequest(CreateTransitionRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateTransitionRequestResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateWebhookResponse createWebhook(CreateRegistryWebhook request) {
        String path = "/api/2.0/mlflow/registry-webhooks/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateWebhookResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteComment(DeleteCommentRequest request) {
        String path = "/api/2.0/mlflow/comments/delete";
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteCommentResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteModel(DeleteModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/delete";
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteModelResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteModelTag(DeleteModelTagRequest request) {
        String path = "/api/2.0/mlflow/registered-models/delete-tag";
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteModelTagResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteModelVersion(DeleteModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/delete";
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteModelVersionResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteModelVersionTag(DeleteModelVersionTagRequest request) {
        String path = "/api/2.0/mlflow/model-versions/delete-tag";
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteModelVersionTagResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTransitionRequest(DeleteTransitionRequestRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/delete";
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteTransitionRequestResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteWebhook(DeleteWebhookRequest request) {
        String path = "/api/2.0/mlflow/registry-webhooks/delete";
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteWebhookResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetLatestVersionsResponse getLatestVersions(GetLatestVersionsRequest request) {
        String path = "/api/2.0/mlflow/registered-models/get-latest-versions";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, GetLatestVersionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        String path = "/api/2.0/mlflow/databricks/registered-models/get";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetModelResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetModelVersionResponse getModelVersion(GetModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/get";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetModelVersionResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetModelVersionDownloadUriResponse getModelVersionDownloadUri(GetModelVersionDownloadUriRequest request) {
        String path = "/api/2.0/mlflow/model-versions/get-download-uri";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetModelVersionDownloadUriResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetRegisteredModelPermissionLevelsResponse getPermissionLevels(GetRegisteredModelPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s/permissionLevels", request.getRegisteredModelId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetRegisteredModelPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RegisteredModelPermissions getPermissions(GetRegisteredModelPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s", request.getRegisteredModelId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, RegisteredModelPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        String path = "/api/2.0/mlflow/registered-models/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListModelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListTransitionRequestsResponse listTransitionRequests(ListTransitionRequestsRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListTransitionRequestsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListRegistryWebhooks listWebhooks(ListWebhooksRequest request) {
        String path = "/api/2.0/mlflow/registry-webhooks/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListRegistryWebhooks.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RejectTransitionRequestResponse rejectTransitionRequest(RejectTransitionRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/reject";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RejectTransitionRequestResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RenameModelResponse renameModel(RenameModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/rename";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RenameModelResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public SearchModelVersionsResponse searchModelVersions(SearchModelVersionsRequest request) {
        String path = "/api/2.0/mlflow/model-versions/search";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, SearchModelVersionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public SearchModelsResponse searchModels(SearchModelsRequest request) {
        String path = "/api/2.0/mlflow/registered-models/search";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, SearchModelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void setModelTag(SetModelTagRequest request) {
        String path = "/api/2.0/mlflow/registered-models/set-tag";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, SetModelTagResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void setModelVersionTag(SetModelVersionTagRequest request) {
        String path = "/api/2.0/mlflow/model-versions/set-tag";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, SetModelVersionTagResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RegisteredModelPermissions setPermissions(RegisteredModelPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s", request.getRegisteredModelId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RegisteredModelPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TestRegistryWebhookResponse testRegistryWebhook(TestRegistryWebhookRequest request) {
        String path = "/api/2.0/mlflow/registry-webhooks/test";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TestRegistryWebhookResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TransitionStageResponse transitionStage(TransitionModelVersionStageDatabricks request) {
        String path = "/api/2.0/mlflow/databricks/model-versions/transition-stage";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TransitionStageResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateCommentResponse updateComment(UpdateComment request) {
        String path = "/api/2.0/mlflow/comments/update";
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateCommentResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateModel(UpdateModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/update";
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateModelResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateModelVersion(UpdateModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/update";
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateModelVersionResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RegisteredModelPermissions updatePermissions(RegisteredModelPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s", request.getRegisteredModelId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RegisteredModelPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateWebhook(UpdateRegistryWebhook request) {
        String path = "/api/2.0/mlflow/registry-webhooks/update";
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateWebhookResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

