/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.oauth2;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.oauth2.CreatePublishedAppIntegration;
import com.databricks.internal.sdk.service.oauth2.CreatePublishedAppIntegrationOutput;
import com.databricks.internal.sdk.service.oauth2.DeletePublishedAppIntegrationOutput;
import com.databricks.internal.sdk.service.oauth2.DeletePublishedAppIntegrationRequest;
import com.databricks.internal.sdk.service.oauth2.GetPublishedAppIntegrationOutput;
import com.databricks.internal.sdk.service.oauth2.GetPublishedAppIntegrationRequest;
import com.databricks.internal.sdk.service.oauth2.GetPublishedAppIntegrationsOutput;
import com.databricks.internal.sdk.service.oauth2.ListPublishedAppIntegrationsRequest;
import com.databricks.internal.sdk.service.oauth2.PublishedAppIntegrationService;
import com.databricks.internal.sdk.service.oauth2.UpdatePublishedAppIntegration;
import com.databricks.internal.sdk.service.oauth2.UpdatePublishedAppIntegrationOutput;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class PublishedAppIntegrationImpl
implements PublishedAppIntegrationService {
    private final ApiClient apiClient;

    public PublishedAppIntegrationImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreatePublishedAppIntegrationOutput create(CreatePublishedAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreatePublishedAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeletePublishedAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeletePublishedAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetPublishedAppIntegrationOutput get(GetPublishedAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetPublishedAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetPublishedAppIntegrationsOutput list(ListPublishedAppIntegrationsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetPublishedAppIntegrationsOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdatePublishedAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdatePublishedAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

