/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.pipelines;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.pipelines.CreatePipeline;
import com.databricks.internal.sdk.service.pipelines.CreatePipelineResponse;
import com.databricks.internal.sdk.service.pipelines.DeletePipelineRequest;
import com.databricks.internal.sdk.service.pipelines.DeletePipelineResponse;
import com.databricks.internal.sdk.service.pipelines.EditPipeline;
import com.databricks.internal.sdk.service.pipelines.EditPipelineResponse;
import com.databricks.internal.sdk.service.pipelines.GetPipelinePermissionLevelsRequest;
import com.databricks.internal.sdk.service.pipelines.GetPipelinePermissionLevelsResponse;
import com.databricks.internal.sdk.service.pipelines.GetPipelinePermissionsRequest;
import com.databricks.internal.sdk.service.pipelines.GetPipelineRequest;
import com.databricks.internal.sdk.service.pipelines.GetPipelineResponse;
import com.databricks.internal.sdk.service.pipelines.GetUpdateRequest;
import com.databricks.internal.sdk.service.pipelines.GetUpdateResponse;
import com.databricks.internal.sdk.service.pipelines.ListPipelineEventsRequest;
import com.databricks.internal.sdk.service.pipelines.ListPipelineEventsResponse;
import com.databricks.internal.sdk.service.pipelines.ListPipelinesRequest;
import com.databricks.internal.sdk.service.pipelines.ListPipelinesResponse;
import com.databricks.internal.sdk.service.pipelines.ListUpdatesRequest;
import com.databricks.internal.sdk.service.pipelines.ListUpdatesResponse;
import com.databricks.internal.sdk.service.pipelines.PipelinePermissions;
import com.databricks.internal.sdk.service.pipelines.PipelinePermissionsRequest;
import com.databricks.internal.sdk.service.pipelines.PipelinesService;
import com.databricks.internal.sdk.service.pipelines.StartUpdate;
import com.databricks.internal.sdk.service.pipelines.StartUpdateResponse;
import com.databricks.internal.sdk.service.pipelines.StopPipelineResponse;
import com.databricks.internal.sdk.service.pipelines.StopRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class PipelinesImpl
implements PipelinesService {
    private final ApiClient apiClient;

    public PipelinesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreatePipelineResponse create(CreatePipeline request) {
        String path = "/api/2.0/pipelines";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreatePipelineResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeletePipelineRequest request) {
        String path = String.format("/api/2.0/pipelines/%s", request.getPipelineId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeletePipelineResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetPipelineResponse get(GetPipelineRequest request) {
        String path = String.format("/api/2.0/pipelines/%s", request.getPipelineId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetPipelineResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetPipelinePermissionLevelsResponse getPermissionLevels(GetPipelinePermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s/permissionLevels", request.getPipelineId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetPipelinePermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PipelinePermissions getPermissions(GetPipelinePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s", request.getPipelineId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, PipelinePermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetUpdateResponse getUpdate(GetUpdateRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/updates/%s", request.getPipelineId(), request.getUpdateId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetUpdateResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListPipelineEventsResponse listPipelineEvents(ListPipelineEventsRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/events", request.getPipelineId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListPipelineEventsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest request) {
        String path = "/api/2.0/pipelines";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListPipelinesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListUpdatesResponse listUpdates(ListUpdatesRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/updates", request.getPipelineId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListUpdatesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PipelinePermissions setPermissions(PipelinePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s", request.getPipelineId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PipelinePermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public StartUpdateResponse startUpdate(StartUpdate request) {
        String path = String.format("/api/2.0/pipelines/%s/updates", request.getPipelineId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, StartUpdateResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void stop(StopRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/stop", request.getPipelineId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, StopPipelineResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(EditPipeline request) {
        String path = String.format("/api/2.0/pipelines/%s", request.getPipelineId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, EditPipelineResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PipelinePermissions updatePermissions(PipelinePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s", request.getPipelineId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PipelinePermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

