/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sql;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sql.Alert;
import com.databricks.internal.sdk.service.sql.AlertsService;
import com.databricks.internal.sdk.service.sql.CreateAlertRequest;
import com.databricks.internal.sdk.service.sql.Empty;
import com.databricks.internal.sdk.service.sql.GetAlertRequest;
import com.databricks.internal.sdk.service.sql.ListAlertsRequest;
import com.databricks.internal.sdk.service.sql.ListAlertsResponse;
import com.databricks.internal.sdk.service.sql.TrashAlertRequest;
import com.databricks.internal.sdk.service.sql.UpdateAlertRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AlertsImpl
implements AlertsService {
    private final ApiClient apiClient;

    public AlertsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Alert create(CreateAlertRequest request) {
        String path = "/api/2.0/sql/alerts";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Alert.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(TrashAlertRequest request) {
        String path = String.format("/api/2.0/sql/alerts/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Empty.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Alert get(GetAlertRequest request) {
        String path = String.format("/api/2.0/sql/alerts/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Alert.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAlertsResponse list(ListAlertsRequest request) {
        String path = "/api/2.0/sql/alerts";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAlertsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Alert update(UpdateAlertRequest request) {
        String path = String.format("/api/2.0/sql/alerts/%s", request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Alert.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

