/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.apache.http.client.utils.URIBuilder;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.google.common.base.Strings;
import com.databricks.internal.google.common.collect.ImmutableMap;
import com.databricks.internal.sdk.core.DatabricksEnvironment;
import com.databricks.internal.sdk.core.ProxyConfig;
import com.databricks.internal.sdk.core.utils.Cloud;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.AllPurposeCluster;
import com.databricks.jdbc.common.AuthFlow;
import com.databricks.jdbc.common.AuthMech;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.DatabricksClientType;
import com.databricks.jdbc.common.DatabricksJdbcConstants;
import com.databricks.jdbc.common.DatabricksJdbcUrlParams;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.common.LogLevel;
import com.databricks.jdbc.common.Warehouse;
import com.databricks.jdbc.common.util.ValidationUtil;
import com.databricks.jdbc.common.util.WildcardUtil;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class DatabricksConnectionContext
implements IDatabricksConnectionContext {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksConnectionContext.class);
    private final String host;
    @VisibleForTesting
    final int port;
    private final String schema;
    private final String connectionURL;
    private final IDatabricksComputeResource computeResource;
    private final Map<String, String> customHeaders;
    private DatabricksClientType clientType;
    @VisibleForTesting
    final ImmutableMap<String, String> parameters;
    @VisibleForTesting
    final String connectionUuid;

    private DatabricksConnectionContext(String connectionURL, String host, int port, String schema, ImmutableMap<String, String> parameters) throws DatabricksSQLException {
        this.connectionURL = connectionURL;
        this.host = host;
        this.port = port;
        this.schema = schema;
        this.parameters = parameters;
        this.customHeaders = this.parseCustomHeaders(parameters);
        this.computeResource = this.buildCompute();
        this.connectionUuid = UUID.randomUUID().toString();
        this.clientType = this.getClientTypeFromContext();
    }

    private DatabricksConnectionContext(String connectionURL, String host, ImmutableMap<String, String> parameters) {
        this.connectionURL = connectionURL;
        this.host = host;
        this.port = 443;
        this.schema = "default";
        this.parameters = parameters;
        this.customHeaders = this.parseCustomHeaders(parameters);
        this.computeResource = null;
        this.connectionUuid = UUID.randomUUID().toString();
    }

    public static ImmutableMap<String, String> buildPropertiesMap(String connectionParamString, Properties properties) {
        ImmutableMap.Builder<String, String> parametersBuilder = ImmutableMap.builder();
        if (!WildcardUtil.isNullOrEmpty(connectionParamString)) {
            String[] urlParts;
            for (String urlPart : urlParts = connectionParamString.split(";")) {
                String[] pair = urlPart.split("=");
                if (pair.length == 1) {
                    pair = new String[]{pair[0], ""};
                }
                if (pair[0].startsWith(DatabricksJdbcUrlParams.HTTP_HEADERS.getParamName())) {
                    parametersBuilder.put(pair[0], pair[1]);
                    continue;
                }
                parametersBuilder.put(pair[0].toLowerCase(), pair[1]);
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            parametersBuilder.put(entry.getKey().toString().toLowerCase(), entry.getValue().toString());
        }
        return parametersBuilder.build();
    }

    static IDatabricksConnectionContext parseWithoutError(String url, Properties properties) {
        Matcher urlMatcher = DatabricksJdbcConstants.JDBC_URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            String host = urlMatcher.group(1).split(":")[0];
            String connectionParamString = urlMatcher.group(3) != null ? urlMatcher.group(3) : "";
            ImmutableMap<String, String> connectionPropertiesMap = DatabricksConnectionContext.buildPropertiesMap(connectionParamString, properties);
            return new DatabricksConnectionContext(url, host, connectionPropertiesMap);
        }
        return null;
    }

    public static IDatabricksConnectionContext parse(String url, Properties properties) throws DatabricksSQLException {
        if (!ValidationUtil.isValidJdbcUrl(url)) {
            throw new DatabricksParsingException("Invalid url " + url, DatabricksDriverErrorCode.CONNECTION_ERROR);
        }
        Matcher urlMatcher = DatabricksJdbcConstants.JDBC_URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            String hostUrlVal = urlMatcher.group(1);
            String schema = Objects.equals(urlMatcher.group(2), "") ? null : urlMatcher.group(2);
            String urlMinusHost = urlMatcher.group(3);
            String[] hostAndPort = hostUrlVal.split(":");
            String hostValue = hostAndPort[0];
            int portValue = hostAndPort.length == 2 ? Integer.parseInt(hostAndPort[1]) : 443;
            ImmutableMap<String, String> propertiesMap = DatabricksConnectionContext.buildPropertiesMap(urlMinusHost, properties);
            ValidationUtil.validateInputProperties(propertiesMap);
            if (propertiesMap.containsKey("port")) {
                try {
                    portValue = Integer.parseInt(propertiesMap.get("port"));
                }
                catch (NumberFormatException e) {
                    throw new DatabricksParsingException("Invalid port number " + propertiesMap.get("port"), DatabricksDriverErrorCode.CONNECTION_ERROR);
                }
            }
            return new DatabricksConnectionContext(url, hostValue, portValue, schema, propertiesMap);
        }
        throw new DatabricksValidationException("Connection Context invalid state error");
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.schema, this.parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatabricksConnectionContext that = (DatabricksConnectionContext)obj;
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.schema, that.schema) && Objects.equals(this.parameters, that.parameters);
    }

    @Override
    public boolean isPropertyPresent(DatabricksJdbcUrlParams urlParam) {
        return this.parameters.containsKey(urlParam.getParamName().toLowerCase());
    }

    @Override
    public String getHostUrl() throws DatabricksParsingException {
        LOGGER.debug("public String getHostUrl()");
        String schema = this.getSSLMode() != null && this.getSSLMode().equals("0") ? "http://" : "https://";
        schema = schema.replace("://", "");
        try {
            URIBuilder uriBuilder = new URIBuilder().setScheme(schema).setHost(this.host);
            if (this.port != 0) {
                uriBuilder.setPort(this.port);
            }
            return uriBuilder.build().toString();
        }
        catch (Exception e) {
            LOGGER.debug("URI Building failed with exception: " + e.getMessage());
            throw new DatabricksParsingException("URI Building failed with exception: " + e.getMessage(), DatabricksDriverErrorCode.CONNECTION_ERROR);
        }
    }

    @Override
    public IDatabricksComputeResource getComputeResource() {
        return this.computeResource;
    }

    @Override
    public String getHttpPath() {
        LOGGER.debug("String getHttpPath()");
        return this.getParameter(DatabricksJdbcUrlParams.HTTP_PATH);
    }

    @Override
    public String getHostForOAuth() {
        return this.host;
    }

    @Override
    public String getToken() {
        return this.getParameter(DatabricksJdbcUrlParams.PWD, this.getParameter(DatabricksJdbcUrlParams.PASSWORD));
    }

    @Override
    public String getPassThroughAccessToken() {
        return this.getParameter(DatabricksJdbcUrlParams.AUTH_ACCESS_TOKEN);
    }

    @Override
    public int getAsyncExecPollInterval() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.POLL_INTERVAL));
    }

    @Override
    public Boolean getDirectResultMode() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.DIRECT_RESULT), "1");
    }

    @Override
    public Cloud getCloud() throws DatabricksParsingException {
        String hostURL = this.getHostUrl();
        String hostName = URI.create(hostURL).getHost();
        return DatabricksEnvironment.getEnvironmentFromHostname(hostName).getCloud();
    }

    @Override
    public String getGcpAuthType() throws DatabricksParsingException {
        if (this.parameters.containsKey(DatabricksJdbcUrlParams.GOOGLE_SERVICE_ACCOUNT.getParamName().toLowerCase())) {
            return "google-id";
        }
        if (this.parameters.containsKey(DatabricksJdbcUrlParams.GOOGLE_CREDENTIALS_FILE.getParamName().toLowerCase())) {
            return "google-credentials";
        }
        return "oauth-m2m";
    }

    @Override
    public String getClientId() throws DatabricksParsingException {
        String clientId = this.getNullableClientId();
        if (DatabricksConnectionContext.nullOrEmptyString(clientId)) {
            Cloud cloud = this.getCloud();
            if (cloud == Cloud.AWS) {
                return "databricks-sql-jdbc";
            }
            if (cloud == Cloud.GCP) {
                return "databricks-sql-jdbc";
            }
            if (cloud == Cloud.AZURE) {
                return "databricks-sql-jdbc";
            }
        }
        return clientId;
    }

    @Override
    public String getNullableClientId() {
        return this.getParameter(DatabricksJdbcUrlParams.CLIENT_ID);
    }

    @Override
    public List<String> getOAuthScopesForU2M() throws DatabricksParsingException {
        if (this.getCloud() == Cloud.AWS || this.getCloud() == Cloud.GCP) {
            return Arrays.asList("sql", "offline_access");
        }
        return null;
    }

    @Override
    public String getClientSecret() {
        return this.getParameter(DatabricksJdbcUrlParams.CLIENT_SECRET);
    }

    @Override
    public String getGoogleServiceAccount() {
        return this.getParameter(DatabricksJdbcUrlParams.GOOGLE_SERVICE_ACCOUNT);
    }

    @Override
    public String getGoogleCredentials() {
        return this.getParameter(DatabricksJdbcUrlParams.GOOGLE_CREDENTIALS_FILE);
    }

    @Override
    public AuthFlow getAuthFlow() {
        String authFlow = this.getParameter(DatabricksJdbcUrlParams.AUTH_FLOW);
        if (DatabricksConnectionContext.nullOrEmptyString(authFlow)) {
            return AuthFlow.TOKEN_PASSTHROUGH;
        }
        return AuthFlow.values()[Integer.parseInt(authFlow)];
    }

    @Override
    public AuthMech getAuthMech() {
        String authMech = this.getParameter(DatabricksJdbcUrlParams.AUTH_MECH);
        return AuthMech.parseAuthMech(authMech);
    }

    @Override
    public LogLevel getLogLevel() {
        String logLevel = this.getParameter(DatabricksJdbcUrlParams.LOG_LEVEL);
        if (DatabricksConnectionContext.nullOrEmptyString(logLevel)) {
            LOGGER.debug("Using default log level " + String.valueOf((Object)DatabricksJdbcConstants.DEFAULT_LOG_LEVEL) + " as none was provided.");
            return DatabricksJdbcConstants.DEFAULT_LOG_LEVEL;
        }
        try {
            return DatabricksConnectionContext.getLogLevel(Integer.parseInt(logLevel));
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Input log level is not an integer, parsing string.");
            logLevel = logLevel.toUpperCase();
            try {
                return LogLevel.valueOf(logLevel);
            }
            catch (Exception e2) {
                LOGGER.debug("Using default log level " + String.valueOf((Object)DatabricksJdbcConstants.DEFAULT_LOG_LEVEL) + " as invalid level was provided.");
                return DatabricksJdbcConstants.DEFAULT_LOG_LEVEL;
            }
        }
    }

    @Override
    public String getLogPathString() {
        String parameter = this.getParameter(DatabricksJdbcUrlParams.LOG_PATH);
        if (parameter != null) {
            return parameter;
        }
        String userDir = System.getProperty("user.dir");
        if (userDir != null && !userDir.isEmpty()) {
            return userDir;
        }
        return System.getProperty("java.io.tmpdir", ".");
    }

    @Override
    public int getLogFileSize() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.LOG_FILE_SIZE));
    }

    @Override
    public int getLogFileCount() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.LOG_FILE_COUNT));
    }

    @Override
    public String getClientUserAgent() {
        return this.getClientType().equals((Object)DatabricksClientType.SEA) ? "SQLExecHttpClient" : "THttpClient";
    }

    @Override
    public String getCustomerUserAgent() {
        return this.getParameter(DatabricksJdbcUrlParams.USER_AGENT_ENTRY);
    }

    @Override
    public CompressionCodec getCompressionCodec() {
        String compressionType = this.getParameter(DatabricksJdbcUrlParams.LZ4_COMPRESSION_FLAG, this.getParameter(DatabricksJdbcUrlParams.COMPRESSION_FLAG));
        return CompressionCodec.parseCompressionType(compressionType);
    }

    public DatabricksClientType getClientTypeFromContext() {
        if (this.computeResource instanceof AllPurposeCluster) {
            return DatabricksClientType.THRIFT;
        }
        String useThriftClient = this.getParameter(DatabricksJdbcUrlParams.USE_THRIFT_CLIENT);
        if (useThriftClient != null && useThriftClient.equals("1")) {
            return DatabricksClientType.THRIFT;
        }
        return DatabricksClientType.SEA;
    }

    @Override
    public DatabricksClientType getClientType() {
        return this.clientType;
    }

    @Override
    public void setClientType(DatabricksClientType clientType) {
        this.clientType = clientType;
    }

    @Override
    public int getCloudFetchThreadPoolSize() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.CLOUD_FETCH_THREAD_POOL_SIZE));
    }

    @Override
    public double getCloudFetchSpeedThreshold() {
        return Double.parseDouble(this.getParameter(DatabricksJdbcUrlParams.CLOUD_FETCH_SPEED_THRESHOLD));
    }

    @Override
    public String getCatalog() {
        return this.getParameter(DatabricksJdbcUrlParams.CONN_CATALOG);
    }

    @Override
    public String getSchema() {
        return this.getParameter(DatabricksJdbcUrlParams.CONN_SCHEMA, this.schema);
    }

    @Override
    public Map<String, String> getSessionConfigs() {
        return this.parameters.entrySet().stream().filter(e -> DatabricksJdbcConstants.ALLOWED_SESSION_CONF_TO_DEFAULT_VALUES_MAP.keySet().stream().anyMatch(allowedConf -> allowedConf.toLowerCase().equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, String> getClientInfoProperties() {
        return DatabricksJdbcConstants.ALLOWED_CLIENT_INFO_PROPERTIES.stream().map(String::toLowerCase).filter(this.parameters::containsKey).collect(Collectors.toMap(key -> key, key -> this.isAccessToken((String)key) ? "****" : this.parameters.get(key)));
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    private boolean isAccessToken(String key) {
        return key.equalsIgnoreCase(DatabricksJdbcUrlParams.AUTH_ACCESS_TOKEN.getParamName());
    }

    @Override
    public boolean isAllPurposeCluster() {
        return this.computeResource instanceof AllPurposeCluster;
    }

    @Override
    public String getProxyHost() {
        return this.getParameter(DatabricksJdbcUrlParams.PROXY_HOST);
    }

    @Override
    public int getProxyPort() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.PROXY_PORT));
    }

    @Override
    public String getProxyUser() {
        return this.getParameter(DatabricksJdbcUrlParams.PROXY_USER);
    }

    @Override
    public String getProxyPassword() {
        return this.getParameter(DatabricksJdbcUrlParams.PROXY_PWD);
    }

    @Override
    public Boolean getUseProxy() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.USE_PROXY), "1");
    }

    @Override
    public ProxyConfig.ProxyAuthType getProxyAuthType() {
        int proxyAuthTypeOrdinal = Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.PROXY_AUTH, "0"));
        return ProxyConfig.ProxyAuthType.values()[proxyAuthTypeOrdinal];
    }

    @Override
    public Boolean getUseSystemProxy() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.USE_SYSTEM_PROXY), "1");
    }

    @Override
    public Boolean getUseCloudFetchProxy() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.USE_CF_PROXY), "1");
    }

    @Override
    public String getCloudFetchProxyHost() {
        return this.getParameter(DatabricksJdbcUrlParams.CF_PROXY_HOST);
    }

    @Override
    public int getCloudFetchProxyPort() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.CF_PROXY_PORT));
    }

    @Override
    public String getCloudFetchProxyUser() {
        return this.getParameter(DatabricksJdbcUrlParams.CF_PROXY_USER);
    }

    @Override
    public String getCloudFetchProxyPassword() {
        return this.getParameter(DatabricksJdbcUrlParams.CF_PROXY_PWD);
    }

    @Override
    public ProxyConfig.ProxyAuthType getCloudFetchProxyAuthType() {
        int proxyAuthTypeOrdinal = Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.CF_PROXY_AUTH));
        return ProxyConfig.ProxyAuthType.values()[proxyAuthTypeOrdinal];
    }

    @Override
    public Boolean shouldEnableArrow() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.ENABLE_ARROW), "1");
    }

    @Override
    public String getEndpointURL() throws DatabricksParsingException {
        return String.format("%s/%s", this.getHostUrl(), this.getHttpPath());
    }

    @VisibleForTesting
    static LogLevel getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LogLevel.OFF;
            }
            case 1: {
                return LogLevel.FATAL;
            }
            case 2: {
                return LogLevel.ERROR;
            }
            case 3: {
                return LogLevel.WARN;
            }
            case 4: {
                return LogLevel.INFO;
            }
            case 5: {
                return LogLevel.DEBUG;
            }
            case 6: {
                return LogLevel.TRACE;
            }
        }
        LOGGER.info("Using default log level " + String.valueOf((Object)DatabricksJdbcConstants.DEFAULT_LOG_LEVEL) + " as invalid level was provided.");
        return DatabricksJdbcConstants.DEFAULT_LOG_LEVEL;
    }

    @Override
    public Boolean shouldRetryTemporarilyUnavailableError() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.TEMPORARILY_UNAVAILABLE_RETRY), "1");
    }

    @Override
    public Boolean shouldRetryRateLimitError() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.RATE_LIMIT_RETRY), "1");
    }

    @Override
    public int getTemporarilyUnavailableRetryTimeout() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.TEMPORARILY_UNAVAILABLE_RETRY_TIMEOUT));
    }

    @Override
    public int getRateLimitRetryTimeout() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.RATE_LIMIT_RETRY_TIMEOUT));
    }

    @Override
    public int getIdleHttpConnectionExpiry() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.IDLE_HTTP_CONNECTION_EXPIRY));
    }

    @Override
    public boolean supportManyParameters() {
        return this.getParameter(DatabricksJdbcUrlParams.SUPPORT_MANY_PARAMETERS).equals("1");
    }

    @Override
    public String getConnectionURL() {
        return this.connectionURL;
    }

    @Override
    public boolean checkCertificateRevocation() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.CHECK_CERTIFICATE_REVOCATION), "1");
    }

    @Override
    public boolean acceptUndeterminedCertificateRevocation() {
        return Objects.equals(this.getParameter(DatabricksJdbcUrlParams.ACCEPT_UNDETERMINED_CERTIFICATE_REVOCATION), "1");
    }

    @Override
    public String getJWTKeyFile() {
        return this.getParameter(DatabricksJdbcUrlParams.JWT_KEY_FILE);
    }

    @Override
    public String getKID() {
        return this.getParameter(DatabricksJdbcUrlParams.JWT_KID);
    }

    @Override
    public String getJWTPassphrase() {
        return this.getParameter(DatabricksJdbcUrlParams.JWT_PASS_PHRASE);
    }

    @Override
    public String getJWTAlgorithm() {
        return this.getParameter(DatabricksJdbcUrlParams.JWT_ALGORITHM);
    }

    @Override
    public boolean useJWTAssertion() {
        return this.getParameter(DatabricksJdbcUrlParams.USE_JWT_ASSERTION).equals("1");
    }

    @Override
    public String getTokenEndpoint() {
        return this.getParameter(DatabricksJdbcUrlParams.OAUTH_TOKEN_ENDPOINT, this.getParameter(DatabricksJdbcUrlParams.TOKEN_ENDPOINT));
    }

    @Override
    public String getAuthEndpoint() {
        return this.getParameter(DatabricksJdbcUrlParams.OAUTH_ENDPOINT, this.getParameter(DatabricksJdbcUrlParams.AUTH_ENDPOINT));
    }

    @Override
    public boolean isOAuthDiscoveryModeEnabled() {
        return this.getParameter(DatabricksJdbcUrlParams.OIDC_DISCOVERY_MODE, this.getParameter(DatabricksJdbcUrlParams.DISCOVERY_MODE)).equals("1");
    }

    @Override
    public String getIdentityFederationClientId() {
        return this.getParameter(DatabricksJdbcUrlParams.IDENTITY_FEDERATION_CLIENT_ID);
    }

    @Override
    public String getOAuthDiscoveryURL() {
        return this.getParameter(DatabricksJdbcUrlParams.OIDC_DISCOVERY_ENDPOINT, this.getParameter(DatabricksJdbcUrlParams.DISCOVERY_URL));
    }

    @Override
    public String getAuthScope() {
        return this.getParameter(DatabricksJdbcUrlParams.AUTH_SCOPE);
    }

    @Override
    public String getOAuthRefreshToken() {
        return this.getParameter(DatabricksJdbcUrlParams.OAUTH_REFRESH_TOKEN, this.getParameter(DatabricksJdbcUrlParams.OAUTH_REFRESH_TOKEN_2));
    }

    @Override
    public List<Integer> getOAuth2RedirectUrlPorts() {
        String portsStr = this.getParameter(DatabricksJdbcUrlParams.OAUTH_REDIRECT_URL_PORT);
        try {
            return Arrays.stream(portsStr.split(",")).map(String::trim).filter(s2 -> !s2.isEmpty()).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Invalid port format in OAuth2RedirectUrlPort: %s.", portsStr);
            LOGGER.error(e, errorMessage);
            throw new DatabricksDriverException(errorMessage, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
    }

    @Override
    public Boolean getUseEmptyMetadata() {
        String param = this.getParameter(DatabricksJdbcUrlParams.USE_EMPTY_METADATA);
        return param != null && param.equals("1");
    }

    @Override
    public String getNonProxyHosts() {
        return this.getParameter(DatabricksJdbcUrlParams.NON_PROXY_HOSTS);
    }

    @Override
    public String getSSLTrustStore() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_TRUST_STORE);
    }

    @Override
    public String getSSLTrustStorePassword() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_TRUST_STORE_PASSWORD);
    }

    @Override
    public String getSSLTrustStoreType() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_TRUST_STORE_TYPE);
    }

    @Override
    public String getSSLTrustStoreProvider() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_TRUST_STORE_PROVIDER);
    }

    @Override
    public String getSSLKeyStore() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_KEY_STORE);
    }

    @Override
    public String getSSLKeyStorePassword() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_KEY_STORE_PASSWORD);
    }

    @Override
    public String getSSLKeyStoreType() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_KEY_STORE_TYPE);
    }

    @Override
    public String getSSLKeyStoreProvider() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL_KEY_STORE_PROVIDER);
    }

    @Override
    public int getMaxBatchSize() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.MAX_BATCH_SIZE));
    }

    @Override
    public String getConnectionUuid() {
        return this.connectionUuid;
    }

    @Override
    public int getTelemetryBatchSize() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.TELEMETRY_BATCH_SIZE));
    }

    @Override
    public boolean isTelemetryEnabled() {
        return this.getParameter(DatabricksJdbcUrlParams.ENABLE_TELEMETRY, "0").equals("1");
    }

    @Override
    public String getVolumeOperationAllowedPaths() {
        return this.getParameter(DatabricksJdbcUrlParams.ALLOWED_VOLUME_INGESTION_PATHS, this.getParameter(DatabricksJdbcUrlParams.ALLOWED_STAGING_INGESTION_PATHS, ""));
    }

    @Override
    public boolean isSqlExecHybridResultsEnabled() {
        return this.getParameter(DatabricksJdbcUrlParams.ENABLE_SQL_EXEC_HYBRID_RESULTS).equals("1");
    }

    @Override
    public String getAzureTenantId() {
        return this.getParameter(DatabricksJdbcUrlParams.AZURE_TENANT_ID);
    }

    @Override
    public int getDefaultStringColumnLength() {
        try {
            int defaultStringColumnLength = Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.DEFAULT_STRING_COLUMN_LENGTH));
            if (defaultStringColumnLength < 0 || defaultStringColumnLength > Short.MAX_VALUE) {
                LOGGER.warn("DefaultStringColumnLength value {} is out of bounds (0 to 32767). Falling back to default value 255.", defaultStringColumnLength);
                return 255;
            }
            return defaultStringColumnLength;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid number format for DefaultStringColumnLength. Falling back to default value 255.");
            return 255;
        }
    }

    @Override
    public int getMaxDBFSConcurrentPresignedRequests() {
        try {
            return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.MAX_CONCURRENT_PRESIGNED_REQUESTS));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid number format for MaxVolumeOperationConcurrentPresignedRequests. Falling back to default value 50.");
            return 50;
        }
    }

    @Override
    public boolean isComplexDatatypeSupportEnabled() {
        return this.getParameter(DatabricksJdbcUrlParams.ENABLE_COMPLEX_DATATYPE_SUPPORT).equals("1");
    }

    @Override
    public boolean isRequestTracingEnabled() {
        return this.getParameter(DatabricksJdbcUrlParams.ENABLE_REQUEST_TRACING).equals("1");
    }

    @Override
    public int getHttpConnectionPoolSize() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.HTTP_CONNECTION_POOL_SIZE));
    }

    @Override
    public boolean allowSelfSignedCerts() {
        return this.getParameter(DatabricksJdbcUrlParams.ALLOW_SELF_SIGNED_CERTS).equals("1");
    }

    @Override
    public boolean useSystemTrustStore() {
        return this.getParameter(DatabricksJdbcUrlParams.USE_SYSTEM_TRUST_STORE).equals("1");
    }

    @Override
    public List<Integer> getUCIngestionRetriableHttpCodes() {
        return Arrays.stream(this.getParameter(DatabricksJdbcUrlParams.VOLUME_OPERATION_RETRYABLE_HTTP_CODE, this.getParameter(DatabricksJdbcUrlParams.UC_INGESTION_RETRIABLE_HTTP_CODE)).split(",")).map(String::trim).filter(num -> num.matches("\\d+")).map(Integer::parseInt).collect(Collectors.toList());
    }

    @Override
    public int getUCIngestionRetryTimeoutSeconds() {
        return 60 * Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.VOLUME_OPERATION_RETRY_TIMEOUT, this.getParameter(DatabricksJdbcUrlParams.UC_INGESTION_RETRY_TIMEOUT)));
    }

    @Override
    public String getAzureWorkspaceResourceId() {
        return this.getParameter(DatabricksJdbcUrlParams.AZURE_WORKSPACE_RESOURCE_ID);
    }

    @Override
    public int getRowsFetchedPerBlock() {
        int maxRows = 2000000;
        try {
            maxRows = Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.ROWS_FETCHED_PER_BLOCK));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid value for RowsFetchedPerBlock, using default value");
        }
        return maxRows;
    }

    @Override
    public int getSocketTimeout() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.SOCKET_TIMEOUT));
    }

    @Override
    public String getTokenCachePassPhrase() {
        return this.getParameter(DatabricksJdbcUrlParams.TOKEN_CACHE_PASS_PHRASE);
    }

    @Override
    public boolean isTokenCacheEnabled() {
        return this.getParameter(DatabricksJdbcUrlParams.ENABLE_TOKEN_CACHE).equals("1");
    }

    @Override
    public String getApplicationName() {
        return this.getParameter(DatabricksJdbcUrlParams.APPLICATION_NAME);
    }

    @Override
    public int getChunkReadyTimeoutSeconds() {
        return Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.CHUNK_READY_TIMEOUT_SECONDS));
    }

    @Override
    public boolean isTelemetryCircuitBreakerEnabled() {
        return this.getParameter(DatabricksJdbcUrlParams.TELEMETRY_CIRCUIT_BREAKER_ENABLED).equals("1");
    }

    @Override
    public int getHttpMaxConnectionsPerRoute() {
        int maxConnectionsPerRoute = 1000;
        try {
            maxConnectionsPerRoute = Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.HTTP_MAX_CONNECTIONS_PER_ROUTE));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid value for HttpMaxConnectionsPerRoutes");
        }
        return maxConnectionsPerRoute;
    }

    @Override
    public Integer getHttpConnectionRequestTimeout() {
        String httpConnectionRequestTimeout = this.getParameter(DatabricksJdbcUrlParams.HTTP_CONNECTION_REQUEST_TIMEOUT);
        if (!Strings.isNullOrEmpty(httpConnectionRequestTimeout)) {
            try {
                return Integer.parseInt(httpConnectionRequestTimeout);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid value for HttpConnectionRequestTimeout");
            }
        }
        return null;
    }

    private static boolean nullOrEmptyString(String s2) {
        return s2 == null || s2.isEmpty();
    }

    private String getSSLMode() {
        return this.getParameter(DatabricksJdbcUrlParams.SSL);
    }

    private IDatabricksComputeResource buildCompute() throws DatabricksSQLException {
        String httpPath = this.getHttpPath();
        Matcher urlMatcher = DatabricksJdbcConstants.HTTP_WAREHOUSE_PATH_PATTERN.matcher(httpPath);
        if (urlMatcher.find()) {
            return new Warehouse(urlMatcher.group(1));
        }
        urlMatcher = DatabricksJdbcConstants.HTTP_ENDPOINT_PATH_PATTERN.matcher(httpPath);
        if (urlMatcher.find()) {
            return new Warehouse(urlMatcher.group(1));
        }
        urlMatcher = DatabricksJdbcConstants.HTTP_CLUSTER_PATH_PATTERN.matcher(httpPath);
        if (urlMatcher.find()) {
            return new AllPurposeCluster(urlMatcher.group(1), urlMatcher.group(2));
        }
        urlMatcher = DatabricksJdbcConstants.HTTP_PATH_CLI_PATTERN.matcher(httpPath);
        if (urlMatcher.find()) {
            return new AllPurposeCluster("default", "default");
        }
        throw new DatabricksParsingException("Invalid HTTP Path provided " + this.getHttpPath(), DatabricksDriverErrorCode.CONNECTION_ERROR);
    }

    private String getParameter(DatabricksJdbcUrlParams key) {
        return this.parameters.getOrDefault(key.getParamName().toLowerCase(), key.getDefaultValue());
    }

    private String getParameter(DatabricksJdbcUrlParams key, String defaultValue) {
        return this.parameters.getOrDefault(key.getParamName().toLowerCase(), defaultValue);
    }

    private Map<String, String> parseCustomHeaders(ImmutableMap<String, String> parameters) {
        String filterPrefix = DatabricksJdbcUrlParams.HTTP_HEADERS.getParamName();
        return parameters.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(filterPrefix)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(filterPrefix.length()), Map.Entry::getValue));
    }

    @Override
    public boolean forceEnableTelemetry() {
        return this.getParameter(DatabricksJdbcUrlParams.FORCE_ENABLE_TELEMETRY).equals("1");
    }

    @Override
    public int getTelemetryFlushIntervalInMilliseconds() {
        return Math.max(1000, Integer.parseInt(this.getParameter(DatabricksJdbcUrlParams.TELEMETRY_FLUSH_INTERVAL)));
    }
}

