/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.DatabricksConnection;
import com.databricks.jdbc.api.impl.DatabricksParameterMetaData;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.DatabricksResultSetMetaData;
import com.databricks.jdbc.api.impl.DatabricksStatement;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.common.util.SQLInterpolator;
import com.databricks.jdbc.common.util.ValidationUtil;
import com.databricks.jdbc.exception.DatabricksBatchUpdateException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotImplementedException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;

public class DatabricksPreparedStatement
extends DatabricksStatement
implements PreparedStatement {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksPreparedStatement.class);
    private final String sql;
    private DatabricksParameterMetaData databricksParameterMetaData;
    private List<DatabricksParameterMetaData> databricksBatchParameterMetaData;
    private final boolean interpolateParameters;
    private final int CHUNK_SIZE = 8192;

    public DatabricksPreparedStatement(DatabricksConnection connection, String sql) {
        super(connection);
        this.sql = sql;
        this.interpolateParameters = connection.getConnectionContext().supportManyParameters();
        this.databricksParameterMetaData = new DatabricksParameterMetaData(sql);
        this.databricksBatchParameterMetaData = new ArrayList<DatabricksParameterMetaData>();
    }

    DatabricksPreparedStatement(DatabricksConnection connection, String sql, boolean interpolateParameters, DatabricksParameterMetaData databricksParameterMetaData) {
        super(connection);
        this.sql = sql;
        this.interpolateParameters = interpolateParameters;
        this.databricksParameterMetaData = databricksParameterMetaData;
        this.databricksBatchParameterMetaData = new ArrayList<DatabricksParameterMetaData>();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        LOGGER.debug("public ResultSet executeQuery()");
        this.checkIfBatchOperation();
        return this.interpolateIfRequiredAndExecute(StatementType.QUERY);
    }

    @Override
    public int executeUpdate() throws SQLException {
        LOGGER.debug("public int executeUpdate()");
        this.checkIfBatchOperation();
        this.interpolateIfRequiredAndExecute(StatementType.UPDATE);
        return (int)this.resultSet.getUpdateCount();
    }

    @Override
    public int[] executeBatch() throws DatabricksBatchUpdateException {
        LOGGER.debug("public int executeBatch()");
        long[] largeUpdateCount = this.executeLargeBatch();
        int[] updateCount = new int[largeUpdateCount.length];
        for (int i = 0; i < largeUpdateCount.length; ++i) {
            updateCount[i] = (int)largeUpdateCount[i];
        }
        return updateCount;
    }

    @Override
    public long[] executeLargeBatch() throws DatabricksBatchUpdateException {
        LOGGER.debug("public long executeLargeBatch()");
        long[] largeUpdateCount = new long[this.databricksBatchParameterMetaData.size()];
        for (int sqlQueryIndex = 0; sqlQueryIndex < this.databricksBatchParameterMetaData.size(); ++sqlQueryIndex) {
            DatabricksParameterMetaData databricksParameterMetaData = this.databricksBatchParameterMetaData.get(sqlQueryIndex);
            try {
                this.executeInternal(this.sql, databricksParameterMetaData.getParameterBindings(), StatementType.UPDATE, false);
                largeUpdateCount[sqlQueryIndex] = this.resultSet.getUpdateCount();
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error executing batch update for index {}: {}", sqlQueryIndex, e.getMessage(), e);
                largeUpdateCount[sqlQueryIndex] = -3L;
                for (int i = sqlQueryIndex + 1; i < largeUpdateCount.length; ++i) {
                    largeUpdateCount[i] = -3L;
                }
                throw new DatabricksBatchUpdateException(e.getMessage(), DatabricksDriverErrorCode.BATCH_EXECUTE_EXCEPTION, largeUpdateCount);
            }
        }
        return largeUpdateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        LOGGER.debug("public void setNull(int parameterIndex, int sqlType)");
        this.setObject(parameterIndex, null, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        LOGGER.debug("public void setBoolean(int parameterIndex, boolean x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "BOOLEAN");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        LOGGER.debug("public void setByte(int parameterIndex, byte x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "TINYINT");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        LOGGER.debug("public void setShort(int parameterIndex, short x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "SHORT");
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        LOGGER.debug("public void setInt(int parameterIndex, int x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "INT");
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        LOGGER.debug("public void setLong(int parameterIndex, long x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "BIGINT");
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        LOGGER.debug("public void setFloat(int parameterIndex, float x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)Float.valueOf(x), "FLOAT");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        LOGGER.debug("public void setDouble(int parameterIndex, double x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "DOUBLE");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        LOGGER.debug("public void setBigDecimal(int parameterIndex, BigDecimal x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "DECIMAL");
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        LOGGER.debug("public void setString(int parameterIndex, String x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "STRING");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        LOGGER.debug("public void setBytes(int parameterIndex, byte[] x)");
        this.checkIfClosed();
        if (x == null) {
            this.setObject(parameterIndex, null);
        } else if (this.interpolateParameters) {
            this.setObject(parameterIndex, (Object)DatabricksPreparedStatement.bytesToHex(x), -2);
        } else {
            throw new DatabricksSQLFeatureNotSupportedException("setBytes(int parameterIndex, byte[] x) not supported with parametrised query. Enable supportManyParameters in the connection string to use this method.");
        }
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        String hexLiteral = "X'";
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return hexLiteral + new String(hexChars) + "'";
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        LOGGER.debug("public void setDate(int parameterIndex, Date x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "DATE");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        LOGGER.debug("public void setTime(int parameterIndex, Time x)");
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Unsupported data type TIME");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        LOGGER.debug("public void setTimestamp(int parameterIndex, Timestamp x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "TIMESTAMP");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        LOGGER.debug("public void setAsciiStream(int parameterIndex, InputStream x, int length)");
        this.checkIfClosed();
        byte[] bytes = this.readBytesFromInputStream(x, length);
        String asciiString = new String(bytes, StandardCharsets.US_ASCII);
        this.setObject(parameterIndex, (Object)asciiString, "STRING");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        LOGGER.debug("public void setUnicodeStream(int parameterIndex, InputStream x, int length)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setUnicodeStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        LOGGER.debug("public void setBinaryStream(int parameterIndex, InputStream x, int length)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setBinaryStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void clearParameters() throws SQLException {
        LOGGER.debug("public void clearParameters()");
        this.checkIfClosed();
        this.databricksParameterMetaData.getParameterBindings().clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        ValidationUtil.throwErrorIfNull("Prepared statement SQL setObject targetSqlType", targetSqlType);
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        ValidationUtil.throwErrorIfNull("Prepared statement SQL setObject targetSqlType", targetSqlType);
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        LOGGER.debug("public long executeLargeUpdate()");
        this.checkIfBatchOperation();
        this.interpolateIfRequiredAndExecute(StatementType.UPDATE);
        return this.resultSet.getUpdateCount();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        LOGGER.debug("public void setObject(int parameterIndex, Object x, int targetSqlType)");
        this.checkIfClosed();
        String databricksType = DatabricksTypeUtil.getDatabricksTypeFromSQLType(targetSqlType);
        if (!Objects.equals(databricksType, "NULL")) {
            this.setObject(parameterIndex, x, databricksType);
            return;
        }
        throw new DatabricksSQLFeatureNotSupportedException("setObject(int parameterIndex, Object x, int targetSqlType) Not supported SQL type: " + targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        LOGGER.debug("public void setObject(int parameterIndex, Object x)");
        this.checkIfClosed();
        String type = DatabricksTypeUtil.inferDatabricksType(x);
        if (type != null) {
            this.setObject(parameterIndex, x, type);
            return;
        }
        throw new DatabricksSQLFeatureNotSupportedException("setObject(int parameterIndex, Object x) Not supported object type: " + String.valueOf(x.getClass()));
    }

    @Override
    public boolean execute() throws SQLException {
        LOGGER.debug("public boolean execute()");
        this.checkIfClosed();
        this.checkIfBatchOperation();
        this.interpolateIfRequiredAndExecute(StatementType.SQL);
        return DatabricksPreparedStatement.shouldReturnResultSet(this.sql);
    }

    @Override
    public void addBatch() {
        LOGGER.debug("public void addBatch()");
        this.databricksBatchParameterMetaData.add(this.databricksParameterMetaData);
        this.databricksParameterMetaData = new DatabricksParameterMetaData(this.sql);
    }

    @Override
    public void clearBatch() throws DatabricksSQLException {
        LOGGER.debug("public void clearBatch()");
        this.checkIfClosed();
        this.databricksParameterMetaData = new DatabricksParameterMetaData(this.sql);
        this.databricksBatchParameterMetaData = new ArrayList<DatabricksParameterMetaData>();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        LOGGER.debug("public void setCharacterStream(int parameterIndex, Reader reader, int length)");
        this.checkIfClosed();
        try {
            char[] buffer = new char[length];
            int charsRead = reader.read(buffer);
            this.checkLength(charsRead, length);
            String str = new String(buffer);
            this.setObject(parameterIndex, (Object)str, "STRING");
        }
        catch (IOException e) {
            String errorMessage = "Error reading from the Reader";
            LOGGER.error(errorMessage);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        LOGGER.debug("public void setRef(int parameterIndex, Ref x)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setRef(int parameterIndex, Ref x)");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        LOGGER.debug("public void setBlob(int parameterIndex, Blob x)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setBlob(int parameterIndex, Blob x)");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        LOGGER.debug("public void setClob(int parameterIndex, Clob x)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setClob(int parameterIndex, Clob x)");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        LOGGER.debug("public void setArray(int parameterIndex, Array x)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setArray(int parameterIndex, Array x)");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        LOGGER.debug("public ResultSetMetaData getMetaData()");
        this.checkIfClosed();
        if (this.resultSet == null) {
            if (DatabricksStatement.isSelectQuery(this.sql)) {
                LOGGER.info("Fetching metadata before executing the query, some values may not be available");
                return this.getMetaDataFromDescribeQuery();
            }
            return null;
        }
        return this.resultSet.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        LOGGER.debug("public void setDate(int parameterIndex, Date x, Calendar cal)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)x, "DATE");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        LOGGER.debug("public void setTime(int parameterIndex, Time x, Calendar cal)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setTime(int parameterIndex, Time x, Calendar cal)");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        LOGGER.debug("public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)");
        this.checkIfClosed();
        if (cal != null) {
            TimeZone originalTimeZone = TimeZone.getDefault();
            TimeZone.setDefault(cal.getTimeZone());
            x = new Timestamp(x.getTime());
            TimeZone.setDefault(originalTimeZone);
            this.setObject(parameterIndex, (Object)x, "TIMESTAMP");
        } else {
            this.setTimestamp(parameterIndex, x);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        LOGGER.debug("public void setNull(int parameterIndex, int sqlType, String typeName)");
        this.setObject(parameterIndex, null, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        LOGGER.debug("public void setURL(int parameterIndex, URL x)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setURL(int parameterIndex, URL x)");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        LOGGER.debug("public ParameterMetaData getParameterMetaData()");
        return this.databricksParameterMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        LOGGER.debug("public void setRowId(int parameterIndex, RowId x)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setRowId(int parameterIndex, RowId x)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        LOGGER.debug("public void setNString(int parameterIndex, String value)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setNString(int parameterIndex, String value)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        LOGGER.debug("public void setNCharacterStream(int parameterIndex, Reader value, long length)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setNCharacterStream(int parameterIndex, Reader value, long length)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        LOGGER.debug("public void setNClob(int parameterIndex, NClob value)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setNClob(int parameterIndex, NClob value)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        LOGGER.debug("public void setClob(int parameterIndex, Reader reader, long length)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        LOGGER.debug("public void setBlob(int parameterIndex, InputStream inputStream, long length)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setBlob(int parameterIndex, InputStream inputStream, long length)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        LOGGER.debug("public void setNClob(int parameterIndex, Reader reader, long length)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setNClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        LOGGER.debug("public void setSQLXML(int parameterIndex, SQLXML xmlObject)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setSQLXML(int parameterIndex, SQLXML xmlObject)");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        LOGGER.debug("public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength)");
        this.checkIfClosed();
        if (x == null) {
            this.setObject(parameterIndex, null, targetSqlType);
            return;
        }
        String databricksType = DatabricksTypeUtil.getDatabricksTypeFromSQLType(targetSqlType);
        if (Objects.equals(databricksType, "NULL")) {
            throw new DatabricksSQLFeatureNotSupportedException("setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) Not supported SQL type: " + targetSqlType);
        }
        if (targetSqlType == 3 || targetSqlType == 2) {
            BigDecimal bd;
            if (x instanceof BigDecimal) {
                bd = (BigDecimal)x;
            } else if (x instanceof Number) {
                bd = BigDecimal.valueOf(((Number)x).doubleValue());
            } else {
                throw new DatabricksSQLException("Invalid object type for DECIMAL/NUMERIC", DatabricksDriverErrorCode.INVALID_STATE);
            }
            bd = bd.setScale(scaleOrLength, RoundingMode.HALF_UP);
            this.setObject(parameterIndex, (Object)bd, databricksType);
        } else {
            this.setObject(parameterIndex, x, databricksType);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        LOGGER.debug("public void setAsciiStream(int parameterIndex, InputStream x, long length)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)this.readStringFromInputStream(x, length, StandardCharsets.US_ASCII), "STRING");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        LOGGER.debug("public void setBinaryStream(int parameterIndex, InputStream x, long length)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setBinaryStream(int parameterIndex, InputStream x, long length)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        LOGGER.debug("public void setCharacterStream(int parameterIndex, Reader reader, long length)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)this.readStringFromReader(reader, length), "STRING");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        LOGGER.debug("public void setAsciiStream(int parameterIndex, InputStream x)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)this.readStringFromInputStream(x, -1L, StandardCharsets.US_ASCII), "STRING");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        LOGGER.debug("public void setBinaryStream(int parameterIndex, InputStream x)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setBinaryStream(int parameterIndex, InputStream x)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        LOGGER.debug("public void setCharacterStream(int parameterIndex, Reader reader)");
        this.checkIfClosed();
        this.setObject(parameterIndex, (Object)this.readStringFromReader(reader, -1L), "STRING");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        LOGGER.debug("public void setNCharacterStream(int parameterIndex, Reader value)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setNCharacterStream(int parameterIndex, Reader value)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        LOGGER.debug("public void setClob(int parameterIndex, Reader reader)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setClob(int parameterIndex, Reader reader)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        LOGGER.debug("public void setBlob(int parameterIndex, InputStream inputStream)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setBlob(int parameterIndex, InputStream inputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        LOGGER.debug("public void setNClob(int parameterIndex, Reader reader)");
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksPreparedStatement - setNClob(int parameterIndex, Reader reader)");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported in PreparedStatement");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        LOGGER.debug("public void addBatch(String sql = {})", sql);
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotImplementedException("Method not supported: addBatch(String sql)");
    }

    private void checkLength(long targetLength, long sourceLength) throws SQLException {
        if (targetLength != sourceLength) {
            String errorMessage = String.format("Unexpected number of bytes read from the stream. Expected: %d, got: %d", targetLength, sourceLength);
            LOGGER.error(errorMessage);
            throw new DatabricksSQLException(errorMessage, DatabricksDriverErrorCode.INVALID_STATE);
        }
    }

    private void checkIfBatchOperation() throws DatabricksSQLException {
        if (!this.databricksBatchParameterMetaData.isEmpty()) {
            String errorMessage = "Batch must either be executed with executeBatch() or cleared with clearBatch()";
            LOGGER.error(errorMessage);
            throw new DatabricksSQLException(errorMessage, DatabricksDriverErrorCode.INVALID_STATE);
        }
    }

    private byte[] readBytesFromInputStream(InputStream x, int length) throws SQLException {
        if (x == null) {
            String errorMessage = "InputStream cannot be null";
            LOGGER.error(errorMessage);
            throw new DatabricksSQLException(errorMessage, DatabricksDriverErrorCode.INVALID_STATE);
        }
        byte[] bytes = new byte[length];
        try {
            int bytesRead = x.read(bytes);
            this.checkLength(bytesRead, length);
        }
        catch (IOException e) {
            String errorMessage = "Error reading from the InputStream";
            LOGGER.error(errorMessage);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
        return bytes;
    }

    private String readStringFromInputStream(InputStream inputStream, long length, Charset charset) throws SQLException {
        String string;
        if (inputStream == null) {
            String message = "InputStream cannot be null";
            LOGGER.error(message);
            throw new DatabricksValidationException(message);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            long bytesRead;
            int nRead;
            byte[] chunk = new byte[8192];
            for (bytesRead = 0L; length != -1L && bytesRead < length && (nRead = inputStream.read(chunk)) != -1; bytesRead += (long)nRead) {
                buffer.write(chunk, 0, nRead);
            }
            if (length != -1L) {
                this.checkLength(length, bytesRead);
            }
            string = buffer.toString(charset);
        }
        catch (Throwable chunk) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable) {
                    chunk.addSuppressed(throwable);
                }
                throw chunk;
            }
            catch (IOException e) {
                String message = "Error reading from the InputStream";
                LOGGER.error(message);
                throw new DatabricksSQLException(message, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
            }
        }
        buffer.close();
        return string;
    }

    private String readStringFromReader(Reader reader, long length) throws SQLException {
        if (reader == null) {
            String message = "Reader cannot be null";
            LOGGER.error(message);
            throw new DatabricksValidationException(message);
        }
        try {
            long charsRead;
            int nRead;
            StringBuilder buffer = new StringBuilder();
            char[] chunk = new char[8192];
            for (charsRead = 0L; length != -1L && charsRead < length && (nRead = reader.read(chunk)) != -1; charsRead += (long)nRead) {
                buffer.append(chunk, 0, nRead);
            }
            if (length != -1L) {
                this.checkLength(length, charsRead);
            }
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setObject(int parameterIndex, Object x, String databricksType) {
        this.databricksParameterMetaData.put(parameterIndex, ImmutableSqlParameter.builder().type(DatabricksTypeUtil.getColumnInfoType(databricksType)).value(x).cardinal(parameterIndex).build());
    }

    private DatabricksResultSet interpolateIfRequiredAndExecute(StatementType statementType) throws SQLException {
        String interpolatedSql = this.interpolateParameters ? SQLInterpolator.interpolateSQL(this.sql, this.databricksParameterMetaData.getParameterBindings()) : this.sql;
        HashMap<Integer, ImmutableSqlParameter> paramMap = this.interpolateParameters ? new HashMap() : this.databricksParameterMetaData.getParameterBindings();
        return this.executeInternal(interpolatedSql, paramMap, statementType);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ResultSetMetaData getMetaDataFromDescribeQuery() throws DatabricksSQLException {
        String describeQuerySQL = "DESCRIBE QUERY " + SQLInterpolator.surroundPlaceholdersWithQuotes(this.sql);
        try (DatabricksPreparedStatement preparedStatement = new DatabricksPreparedStatement(this.connection, describeQuerySQL, this.interpolateParameters, this.databricksParameterMetaData);){
            DatabricksResultSetMetaData databricksResultSetMetaData;
            block14: {
                ResultSet metadataResultSet = preparedStatement.executeQuery();
                try {
                    ArrayList<String> columnNames = new ArrayList<String>();
                    ArrayList<String> columnDataTypes = new ArrayList<String>();
                    while (metadataResultSet.next()) {
                        columnNames.add(metadataResultSet.getString(1));
                        columnDataTypes.add(metadataResultSet.getString(2));
                    }
                    databricksResultSetMetaData = new DatabricksResultSetMetaData(preparedStatement.getStatementId(), columnNames, columnDataTypes, this.connection.getConnectionContext());
                    if (metadataResultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (metadataResultSet != null) {
                        try {
                            metadataResultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                metadataResultSet.close();
            }
            return databricksResultSetMetaData;
        }
        catch (SQLException e) {
            String errorMessage = "Failed to get query metadata";
            LOGGER.error(e, errorMessage);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.EXECUTE_STATEMENT_FAILED);
        }
    }
}

