/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.support.ToStringer;
import com.databricks.jdbc.api.impl.ImmutableSessionInfo;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.DatabricksClientType;
import com.databricks.jdbc.common.DatabricksJdbcUrlParams;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.dbclient.IDatabricksClient;
import com.databricks.jdbc.dbclient.IDatabricksMetadataClient;
import com.databricks.jdbc.dbclient.impl.sqlexec.DatabricksEmptyMetadataClient;
import com.databricks.jdbc.dbclient.impl.sqlexec.DatabricksMetadataSdkClient;
import com.databricks.jdbc.dbclient.impl.sqlexec.DatabricksSdkClient;
import com.databricks.jdbc.dbclient.impl.thrift.DatabricksThriftServiceClient;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksTemporaryRedirectException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import com.databricks.jdbc.telemetry.latency.DatabricksMetricsTimedProcessor;
import java.util.Map;
import javax.annotation.Nullable;

public class DatabricksSession
implements IDatabricksSession {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksSession.class);
    private IDatabricksClient databricksClient;
    private IDatabricksMetadataClient databricksMetadataClient;
    private final IDatabricksComputeResource computeResource;
    private boolean isSessionOpen;
    private ImmutableSessionInfo sessionInfo;
    private String catalog;
    private String schema;
    private final Map<String, String> sessionConfigs;
    private final Map<String, String> clientInfoProperties;
    private final CompressionCodec compressionCodec;
    private final IDatabricksConnectionContext connectionContext;

    public DatabricksSession(IDatabricksConnectionContext connectionContext) throws DatabricksSQLException {
        if (connectionContext.getClientType() == DatabricksClientType.THRIFT) {
            this.databricksClient = DatabricksMetricsTimedProcessor.createProxy(new DatabricksThriftServiceClient(connectionContext));
        } else {
            this.databricksClient = DatabricksMetricsTimedProcessor.createProxy(new DatabricksSdkClient(connectionContext));
            this.databricksMetadataClient = DatabricksMetricsTimedProcessor.createProxy(new DatabricksMetadataSdkClient(this.databricksClient));
        }
        this.isSessionOpen = false;
        this.sessionInfo = null;
        this.computeResource = connectionContext.getComputeResource();
        this.catalog = connectionContext.getCatalog();
        this.schema = connectionContext.getSchema();
        this.sessionConfigs = connectionContext.getSessionConfigs();
        this.clientInfoProperties = connectionContext.getClientInfoProperties();
        this.compressionCodec = connectionContext.getCompressionCodec();
        this.connectionContext = connectionContext;
    }

    @VisibleForTesting
    public DatabricksSession(IDatabricksConnectionContext connectionContext, IDatabricksClient testDatabricksClient) {
        this.databricksClient = testDatabricksClient;
        if (this.databricksClient instanceof DatabricksSdkClient) {
            this.databricksMetadataClient = new DatabricksMetadataSdkClient(this.databricksClient);
        }
        this.isSessionOpen = false;
        this.sessionInfo = null;
        this.computeResource = connectionContext.getComputeResource();
        this.catalog = connectionContext.getCatalog();
        this.schema = connectionContext.getSchema();
        this.sessionConfigs = connectionContext.getSessionConfigs();
        this.clientInfoProperties = connectionContext.getClientInfoProperties();
        this.compressionCodec = connectionContext.getCompressionCodec();
        this.connectionContext = connectionContext;
    }

    @Override
    @Nullable
    public String getSessionId() {
        LOGGER.debug("public String getSessionId()");
        return this.isSessionOpen ? this.sessionInfo.sessionId() : null;
    }

    @Override
    @Nullable
    public ImmutableSessionInfo getSessionInfo() {
        LOGGER.debug("public String getSessionInfo()");
        return this.sessionInfo;
    }

    @Override
    public IDatabricksComputeResource getComputeResource() {
        LOGGER.debug("public String getComputeResource()");
        return this.computeResource;
    }

    @Override
    public CompressionCodec getCompressionCodec() {
        LOGGER.debug("public String getCompressionType()");
        return this.compressionCodec;
    }

    @Override
    public boolean isOpen() {
        LOGGER.debug("public boolean isOpen()");
        return this.isSessionOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws DatabricksSQLException {
        LOGGER.debug("public void open()");
        DatabricksSession databricksSession = this;
        synchronized (databricksSession) {
            if (!this.isSessionOpen) {
                try {
                    this.sessionInfo = this.databricksClient.createSession(this.computeResource, this.catalog, this.schema, this.sessionConfigs);
                }
                catch (DatabricksTemporaryRedirectException e) {
                    this.connectionContext.setClientType(DatabricksClientType.THRIFT);
                    this.databricksClient = DatabricksMetricsTimedProcessor.createProxy(new DatabricksThriftServiceClient(this.connectionContext));
                    this.sessionInfo = this.databricksClient.createSession(this.computeResource, this.catalog, this.schema, this.sessionConfigs);
                }
                this.isSessionOpen = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DatabricksSQLException {
        LOGGER.debug("public void close()");
        DatabricksSession databricksSession = this;
        synchronized (databricksSession) {
            block10: {
                if (this.isSessionOpen) {
                    try {
                        this.databricksClient.deleteSession(this.sessionInfo);
                    }
                    catch (DatabricksHttpException e) {
                        if (e.getMessage() != null && e.getMessage().toLowerCase().contains("invalid session")) {
                            LOGGER.warn("Session [{}] already expired/invalid on server \u2013 ignoring during close()", this.sessionInfo.sessionId());
                            break block10;
                        }
                        throw e;
                    }
                    finally {
                        this.sessionInfo = null;
                        this.isSessionOpen = false;
                    }
                }
            }
        }
    }

    @Override
    public IDatabricksClient getDatabricksClient() {
        LOGGER.debug("public IDatabricksClient getDatabricksClient()");
        return this.databricksClient;
    }

    @Override
    public IDatabricksMetadataClient getDatabricksMetadataClient() {
        LOGGER.debug("public IDatabricksClient getDatabricksMetadataClient()");
        if (this.connectionContext.getClientType() == DatabricksClientType.THRIFT) {
            return (IDatabricksMetadataClient)((Object)this.databricksClient);
        }
        return this.databricksMetadataClient;
    }

    @Override
    public String getCatalog() {
        LOGGER.debug("public String getCatalog()");
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        LOGGER.debug("public void setCatalog(String catalog = {})", catalog);
        this.catalog = catalog;
    }

    @Override
    public String getSchema() {
        LOGGER.debug("public String getSchema()");
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        LOGGER.debug("public void setSchema(String schema = {})", schema);
        this.schema = schema;
    }

    @Override
    public String toString() {
        return new ToStringer(DatabricksSession.class).add("compute", this.computeResource.toString()).add("catalog", this.catalog).add("schema", this.schema).add("sessionID", this.getSessionId()).toString();
    }

    @Override
    public Map<String, String> getSessionConfigs() {
        LOGGER.debug("public Map<String, String> getSessionConfigs()");
        return this.sessionConfigs;
    }

    @Override
    public void setSessionConfig(String name, String value) {
        LOGGER.debug("public void setSessionConfig(String name = {}, String value = {})", name, value);
        this.sessionConfigs.put(name, value);
    }

    @Override
    public Map<String, String> getClientInfoProperties() {
        LOGGER.debug("public Map<String, String> getClientInfoProperties()");
        return this.clientInfoProperties;
    }

    @Override
    public String getConfigValue(String name) {
        LOGGER.debug("public String getConfigValue(String name = {})", name);
        return this.sessionConfigs.getOrDefault(name.toLowerCase(), this.clientInfoProperties.getOrDefault(name.toLowerCase(), null));
    }

    @Override
    public void setClientInfoProperty(String name, String value) {
        LOGGER.debug(String.format("public void setClientInfoProperty(String name = {%s}, String value = {%s})", name, value));
        if (name.equalsIgnoreCase(DatabricksJdbcUrlParams.AUTH_ACCESS_TOKEN.getParamName())) {
            this.databricksClient.resetAccessToken(value);
            value = "****";
        }
        if (name.equalsIgnoreCase(DatabricksJdbcUrlParams.APPLICATION_NAME.getParamName())) {
            TelemetryHelper.updateTelemetryAppName(this.connectionContext, value);
        }
        this.clientInfoProperties.put(name, value);
    }

    @Override
    public IDatabricksConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public void setEmptyMetadataClient() {
        this.databricksMetadataClient = new DatabricksEmptyMetadataClient(this.connectionContext);
    }

    @Override
    public void forceClose() {
        try {
            this.close();
        }
        catch (DatabricksSQLException e) {
            LOGGER.error("Error closing session resources, but marking the session as closed.");
        }
        finally {
            this.isSessionOpen = false;
        }
    }
}

