/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.DatabricksArray;
import com.databricks.jdbc.api.impl.DatabricksMap;
import com.databricks.jdbc.api.impl.DatabricksStruct;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;

public interface ObjectConverter {
    public static final long[] POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L};
    public static final int DEFAULT_TIMESTAMP_SCALE = 3;

    default public byte toByte(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported byte conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public short toShort(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported short conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public int toInt(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported int conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public long toLong(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported long conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public float toFloat(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported float conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public double toDouble(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported double conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public BigDecimal toBigDecimal(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported BigDecimal conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public BigDecimal toBigDecimal(Object object, int scale) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported BigDecimal(scale) conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported BigInteger conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public LocalDate toLocalDate(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported LocalDate conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public boolean toBoolean(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported boolean conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public byte[] toByteArray(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported byte[] conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public char toChar(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported char conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public String toString(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported String conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public Time toTime(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported Time conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public Timestamp toTimestamp(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported Timestamp conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public Timestamp toTimestamp(Object object, int scale) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported Timestamp(scale) conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public Date toDate(Object object) throws DatabricksSQLException {
        throw new DatabricksSQLException("Unsupported Date conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public DatabricksArray toDatabricksArray(Object object) throws DatabricksSQLException {
        if (object instanceof DatabricksArray) {
            return (DatabricksArray)object;
        }
        throw new DatabricksSQLException("Unsupported Array conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public DatabricksMap toDatabricksMap(Object object) throws DatabricksSQLException {
        if (object instanceof DatabricksMap) {
            return (DatabricksMap)object;
        }
        throw new DatabricksSQLException("Unsupported Map conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    default public DatabricksStruct toDatabricksStruct(Object object) throws DatabricksSQLException {
        if (object instanceof DatabricksStruct) {
            return (DatabricksStruct)object;
        }
        throw new DatabricksSQLException("Unsupported Struct conversion operation", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    default public InputStream toBinaryStream(Object object) throws DatabricksSQLException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ByteArrayInputStream byteArrayInputStream;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new DatabricksSQLException("Could not convert object to binary stream " + object.toString(), (Throwable)e, DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
        }
    }

    default public InputStream toUnicodeStream(Object object) throws DatabricksSQLException {
        return new ByteArrayInputStream(this.toString(object).getBytes(StandardCharsets.UTF_8));
    }

    default public InputStream toAsciiStream(Object object) throws DatabricksSQLException {
        return new ByteArrayInputStream(this.toString(object).getBytes(StandardCharsets.US_ASCII));
    }

    default public Reader toCharacterStream(Object object) throws DatabricksSQLException {
        return new StringReader(this.toString(object));
    }
}

