/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.volume;

import com.databricks.internal.apache.http.HttpEntity;
import com.databricks.internal.apache.http.entity.InputStreamEntity;
import com.databricks.internal.fasterxml.jackson.core.JsonProcessingException;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.google.common.base.Strings;
import com.databricks.jdbc.api.impl.IExecutionResult;
import com.databricks.jdbc.api.impl.VolumeOperationStatus;
import com.databricks.jdbc.api.impl.volume.VolumeInputStream;
import com.databricks.jdbc.api.impl.volume.VolumeOperationProcessor;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.HttpClientType;
import com.databricks.jdbc.common.util.JsonUtil;
import com.databricks.jdbc.common.util.VolumeUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksVolumeOperationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.ResultManifest;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class VolumeOperationResult
implements IExecutionResult {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(VolumeOperationResult.class);
    private final IDatabricksSession session;
    private final IExecutionResult resultHandler;
    private final IDatabricksStatementInternal statement;
    private final IDatabricksHttpClient httpClient;
    private final long rowCount;
    private final long columnCount;
    private VolumeOperationProcessor volumeOperationProcessor;
    private int currentRowIndex;
    private VolumeInputStream volumeInputStream = null;
    private long volumeStreamContentLength = -1L;

    public VolumeOperationResult(long totalRows, long totalColumns, IDatabricksSession session, IExecutionResult resultHandler, IDatabricksStatementInternal statement) {
        this.rowCount = totalRows;
        this.columnCount = totalColumns;
        this.session = session;
        this.resultHandler = resultHandler;
        this.statement = statement;
        this.httpClient = DatabricksHttpClientFactory.getInstance().getClient(session.getConnectionContext(), HttpClientType.VOLUME);
        this.currentRowIndex = -1;
    }

    @VisibleForTesting
    VolumeOperationResult(ResultManifest manifest, IDatabricksSession session, IExecutionResult resultHandler, IDatabricksHttpClient httpClient, IDatabricksStatementInternal statement) {
        this.rowCount = manifest.getTotalRowCount();
        this.columnCount = manifest.getSchema().getColumnCount();
        this.session = session;
        this.resultHandler = resultHandler;
        this.statement = statement;
        this.httpClient = httpClient;
        this.currentRowIndex = -1;
    }

    private void initHandler(IExecutionResult resultHandler) throws DatabricksSQLException {
        VolumeUtil.VolumeOperationType operation = VolumeUtil.VolumeOperationType.fromString(this.getString(resultHandler.getObject(0)));
        String presignedUrl = this.getString(resultHandler.getObject(1));
        String localFile = this.columnCount > 3L ? this.getString(resultHandler.getObject(3)) : null;
        Map<String, String> headers = this.getHeaders(this.getString(resultHandler.getObject(2)));
        String allowedVolumeIngestionPaths = this.getAllowedVolumeIngestionPaths();
        this.volumeOperationProcessor = VolumeOperationProcessor.Builder.createBuilder().operationType(operation).operationUrl(presignedUrl).headers(headers).localFilePath(localFile).allowedVolumeIngestionPathString(allowedVolumeIngestionPaths).isAllowedInputStreamForVolumeOperation(this.statement.isAllowedInputStreamForVolumeOperation()).inputStream(this.statement.getInputStreamForUCVolume()).databricksHttpClient(this.httpClient).getStreamReceiver(entity -> {
            try {
                this.setVolumeOperationEntityStream((HttpEntity)entity);
            }
            catch (Exception e) {
                String message = String.format("Failed to set result set volumeOperationEntityStream %s", e.getMessage());
                LOGGER.error(e, message);
                throw new DatabricksDriverException(message, DatabricksDriverErrorCode.VOLUME_OPERATION_EXCEPTION);
            }
        }).build();
    }

    private String getAllowedVolumeIngestionPaths() {
        String allowedPaths = this.session.getClientInfoProperties().get("VolumeOperationAllowedLocalPaths".toLowerCase());
        if (Strings.isNullOrEmpty(allowedPaths)) {
            allowedPaths = this.session.getClientInfoProperties().getOrDefault("StagingAllowedLocalPaths", "");
        }
        if (Strings.isNullOrEmpty(allowedPaths)) {
            allowedPaths = this.session.getConnectionContext().getVolumeOperationAllowedPaths();
        }
        return allowedPaths;
    }

    private String getString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private Map<String, String> getHeaders(String headersVal) throws DatabricksSQLException {
        if (headersVal != null && !headersVal.isEmpty()) {
            String headers;
            String string = headers = headersVal.charAt(0) == '[' ? headersVal.substring(1, headersVal.length() - 1) : headersVal;
            if (!headers.isEmpty()) {
                try {
                    return JsonUtil.getMapper().readValue(headers, Map.class);
                }
                catch (JsonProcessingException e) {
                    throw new DatabricksVolumeOperationException("Failed to parse headers", (Throwable)e, DatabricksDriverErrorCode.VOLUME_OPERATION_PARSING_ERROR);
                }
            }
        }
        return new HashMap<String, String>();
    }

    private void validateMetadata() throws DatabricksSQLException {
        String errorMessage = null;
        if (this.rowCount > 1L) {
            errorMessage = "Too many rows for Volume Operation";
        } else if (this.columnCount > 4L) {
            errorMessage = "Too many columns for Volume Operation";
        } else if (this.columnCount < 3L) {
            errorMessage = "Too few columns for Volume Operation";
        }
        if (errorMessage != null) {
            throw new DatabricksVolumeOperationException(errorMessage, DatabricksDriverErrorCode.VOLUME_OPERATION_INVALID_STATE);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws DatabricksSQLException {
        if (columnIndex == 0) {
            return this.volumeOperationProcessor.getStatus().name();
        }
        String errorMessage = this.currentRowIndex < 0 ? "Invalid row access" : "Invalid column access";
        throw new DatabricksVolumeOperationException(errorMessage, DatabricksDriverErrorCode.VOLUME_OPERATION_INVALID_STATE);
    }

    @Override
    public long getCurrentRow() {
        return this.currentRowIndex;
    }

    @Override
    public boolean next() throws DatabricksSQLException {
        if (this.hasNext()) {
            this.validateMetadata();
            this.resultHandler.next();
            this.initHandler(this.resultHandler);
            this.volumeOperationProcessor.process();
            this.ensureSuccessVolumeProcessorStatus();
            ++this.currentRowIndex;
            return true;
        }
        return false;
    }

    public void setVolumeOperationEntityStream(HttpEntity httpEntity) throws IOException {
        this.volumeInputStream = new VolumeInputStream(httpEntity);
        this.volumeStreamContentLength = httpEntity.getContentLength();
    }

    public InputStreamEntity getVolumeOperationInputStream() {
        return new InputStreamEntity((InputStream)this.volumeInputStream, this.volumeStreamContentLength);
    }

    @Override
    public boolean hasNext() {
        return this.resultHandler.hasNext();
    }

    @Override
    public void close() {
        this.resultHandler.close();
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public long getChunkCount() {
        return 0L;
    }

    private void ensureSuccessVolumeProcessorStatus() throws DatabricksVolumeOperationException {
        if (this.volumeOperationProcessor.getStatus() == VolumeOperationStatus.FAILED || this.volumeOperationProcessor.getStatus() == VolumeOperationStatus.ABORTED) {
            String errorMessage = String.format("Volume operation status : %s, Error message: %s", new Object[]{this.volumeOperationProcessor.getStatus(), this.volumeOperationProcessor.getErrorMessage()});
            LOGGER.error(errorMessage);
            throw new DatabricksVolumeOperationException(errorMessage, DatabricksDriverErrorCode.VOLUME_OPERATION_EXCEPTION);
        }
    }
}

