/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.safe;

import com.databricks.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.internal.apache.http.client.methods.HttpGet;
import com.databricks.internal.apache.http.util.EntityUtils;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.google.common.cache.CacheBuilder;
import com.databricks.internal.google.common.cache.CacheLoader;
import com.databricks.internal.google.common.cache.LoadingCache;
import com.databricks.internal.google.common.util.concurrent.Futures;
import com.databricks.internal.google.common.util.concurrent.ListenableFuture;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.DatabricksClientConfiguratorManager;
import com.databricks.jdbc.common.safe.FeatureFlagsResponse;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.common.util.JsonUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class DatabricksDriverFeatureFlagsContext {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksDriverFeatureFlagsContext.class);
    private static final String FEATURE_FLAGS_ENDPOINT_SUFFIX = String.format("/api/2.0/connector-service/feature-flags/OSS_JDBC/%s", DriverUtil.getDriverVersionWithoutOSSSuffix());
    private static final int DEFAULT_TTL_SECONDS = 900;
    private static final int REFRESH_BEFORE_EXPIRY_SECONDS = 10;
    private final String featureFlagEndpoint;
    private final IDatabricksConnectionContext connectionContext;
    private LoadingCache<String, String> featureFlags;
    private final ExecutorService asyncExecutor = Executors.newCachedThreadPool();

    public DatabricksDriverFeatureFlagsContext(IDatabricksConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.featureFlags = this.createFeatureFlagsCache(900);
        this.featureFlagEndpoint = String.format("https://%s%s", connectionContext.getHostForOAuth(), FEATURE_FLAGS_ENDPOINT_SUFFIX);
    }

    DatabricksDriverFeatureFlagsContext(IDatabricksConnectionContext connectionContext, Map<String, String> initialFlags) {
        this.connectionContext = connectionContext;
        this.featureFlags = this.createFeatureFlagsCache(900);
        this.featureFlagEndpoint = String.format("https://%s%s", connectionContext.getHostForOAuth(), FEATURE_FLAGS_ENDPOINT_SUFFIX);
        initialFlags.forEach(this.featureFlags::put);
    }

    private LoadingCache<String, String> createFeatureFlagsCache(int ttlSeconds) {
        return CacheBuilder.newBuilder().expireAfterWrite(ttlSeconds, TimeUnit.SECONDS).refreshAfterWrite(Math.max(300, ttlSeconds - 10), TimeUnit.SECONDS).build(new CacheLoader<String, String>(){

            @Override
            public String load(String key) {
                DatabricksDriverFeatureFlagsContext.this.refreshAllFeatureFlags();
                return DatabricksDriverFeatureFlagsContext.this.featureFlags.getIfPresent(key) != null ? (String)DatabricksDriverFeatureFlagsContext.this.featureFlags.getIfPresent(key) : "false";
            }

            @Override
            public ListenableFuture<String> reload(String key, String oldValue) {
                DatabricksDriverFeatureFlagsContext.this.asyncExecutor.submit(() -> DatabricksDriverFeatureFlagsContext.this.refreshAllFeatureFlags());
                return Futures.immediateFuture(oldValue);
            }
        });
    }

    private void refreshAllFeatureFlags() {
        try {
            IDatabricksHttpClient httpClient = DatabricksHttpClientFactory.getInstance().getClient(this.connectionContext);
            HttpGet request = new HttpGet(this.featureFlagEndpoint);
            DatabricksClientConfiguratorManager.getInstance().getConfigurator(this.connectionContext).getDatabricksConfig().authenticate().forEach(request::addHeader);
            this.fetchAndSetFlagsFromServer(httpClient, request);
        }
        catch (Exception e) {
            LOGGER.trace("Error fetching feature flags for context: {}. Error: {}", this.connectionContext, e.getMessage());
        }
    }

    @VisibleForTesting
    void fetchAndSetFlagsFromServer(IDatabricksHttpClient httpClient, HttpGet request) throws DatabricksHttpException, IOException {
        try (CloseableHttpResponse response = httpClient.execute(request);){
            if (response.getStatusLine().getStatusCode() == 200) {
                Integer ttlSeconds;
                String responseBody = EntityUtils.toString(response.getEntity());
                FeatureFlagsResponse featureFlagsResponse = JsonUtil.getMapper().readValue(responseBody, FeatureFlagsResponse.class);
                this.featureFlags.invalidateAll();
                if (featureFlagsResponse.getFlags() != null) {
                    for (FeatureFlagsResponse.FeatureFlagEntry flag : featureFlagsResponse.getFlags()) {
                        this.featureFlags.put(flag.getName(), flag.getValue());
                    }
                }
                if ((ttlSeconds = featureFlagsResponse.getTtlSeconds()) != null) {
                    this.featureFlags = this.createFeatureFlagsCache(ttlSeconds);
                }
            } else {
                LOGGER.trace("Failed to fetch feature flags. Context: {}, Status code: {}", this.connectionContext, response.getStatusLine().getStatusCode());
            }
        }
    }

    public boolean isFeatureEnabled(String name) {
        try {
            return Boolean.parseBoolean(this.featureFlags.get(name));
        }
        catch (Exception e) {
            LOGGER.trace("Error fetching feature flag {}: {}", name, e.getMessage());
            return false;
        }
    }
}

