/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.sqlexec;

import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.common.util.ValidationUtil;
import com.databricks.jdbc.common.util.WildcardUtil;
import com.databricks.jdbc.dbclient.impl.sqlexec.CommandName;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;

public class CommandBuilder {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(CommandBuilder.class);
    private String catalogName = null;
    private String schemaName = null;
    private String tableName = null;
    private String schemaPattern = null;
    private String tablePattern = null;
    private String columnPattern = null;
    private String functionPattern = null;
    private final String sessionContext;

    public CommandBuilder(String catalogName, IDatabricksSession session) {
        this.sessionContext = session.toString();
        this.catalogName = catalogName;
    }

    public CommandBuilder(IDatabricksSession session) {
        this.sessionContext = session.toString();
    }

    public CommandBuilder setSchema(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public CommandBuilder setTable(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public CommandBuilder setSchemaPattern(String pattern) {
        this.schemaPattern = WildcardUtil.jdbcPatternToHive(pattern);
        LOGGER.debug("Schema pattern conversion {} -> {}", pattern, this.schemaPattern);
        return this;
    }

    public CommandBuilder setTablePattern(String pattern) {
        this.tablePattern = WildcardUtil.jdbcPatternToHive(pattern);
        LOGGER.debug("Table pattern conversion {} -> {}", pattern, this.tablePattern);
        return this;
    }

    public CommandBuilder setColumnPattern(String pattern) {
        this.columnPattern = WildcardUtil.jdbcPatternToHive(pattern);
        LOGGER.debug("Column pattern conversion {} -> {}", pattern, this.columnPattern);
        return this;
    }

    public CommandBuilder setFunctionPattern(String pattern) {
        this.functionPattern = WildcardUtil.jdbcPatternToHive(pattern);
        LOGGER.debug("Function pattern conversion {} -> {}", pattern, this.functionPattern);
        return this;
    }

    private String fetchCatalogSQL() {
        return "SHOW CATALOGS";
    }

    private String fetchSchemaSQL() throws SQLException {
        String contextString = String.format("Building command for fetching schema. Catalog %s, SchemaPattern %s and session context %s", this.catalogName, this.schemaPattern, this.sessionContext);
        LOGGER.debug(contextString);
        ValidationUtil.throwErrorIfNull(Collections.singletonMap("catalog", this.catalogName), contextString);
        Object showSchemaSQL = String.format("SHOW SCHEMAS IN %s", this.catalogName);
        if (!WildcardUtil.isNullOrEmpty(this.schemaPattern)) {
            showSchemaSQL = (String)showSchemaSQL + String.format(" LIKE '%s'", this.schemaPattern);
        }
        return showSchemaSQL;
    }

    private String fetchTablesSQL() throws SQLException {
        String contextString = String.format("Building command for fetching tables. Catalog %s, SchemaPattern %s, TablePattern %s and session context %s", this.catalogName, this.schemaPattern, this.tablePattern, this.sessionContext);
        LOGGER.debug(contextString);
        Object showTablesSQL = this.catalogName == null || this.catalogName.equals("*") || this.catalogName.equals("%") ? "SHOW TABLES IN ALL CATALOGS" : String.format("SHOW TABLES IN CATALOG %s", this.catalogName);
        if (!WildcardUtil.isNullOrEmpty(this.schemaPattern)) {
            showTablesSQL = (String)showTablesSQL + String.format(" SCHEMA LIKE '%s'", this.schemaPattern);
        }
        if (!WildcardUtil.isNullOrEmpty(this.tablePattern)) {
            showTablesSQL = (String)showTablesSQL + String.format(" LIKE '%s'", this.tablePattern);
        }
        return showTablesSQL;
    }

    private String fetchColumnsSQL() throws SQLException {
        String contextString = String.format("Building command for fetching columns. Catalog %s, SchemaPattern %s, TablePattern %s, ColumnPattern %s and session context : %s", this.catalogName, this.schemaPattern, this.tablePattern, this.columnPattern, this.sessionContext);
        LOGGER.debug(contextString);
        ValidationUtil.throwErrorIfNull(Collections.singletonMap("catalog", this.catalogName), contextString);
        Object showColumnsSQL = String.format("SHOW COLUMNS IN CATALOG %s", this.catalogName);
        if (!WildcardUtil.isNullOrEmpty(this.schemaPattern)) {
            showColumnsSQL = (String)showColumnsSQL + String.format(" SCHEMA LIKE '%s'", this.schemaPattern);
        }
        if (!WildcardUtil.isNullOrEmpty(this.tablePattern)) {
            showColumnsSQL = (String)showColumnsSQL + String.format(" TABLE LIKE '%s'", this.tablePattern);
        }
        if (!WildcardUtil.isNullOrEmpty(this.columnPattern)) {
            showColumnsSQL = (String)showColumnsSQL + String.format(" LIKE '%s'", this.columnPattern);
        }
        return showColumnsSQL;
    }

    private String fetchFunctionsSQL() throws SQLException {
        String contextString = String.format("Building command for fetching functions. Catalog %s, SchemaPattern %s, FunctionPattern %s. With session context %s", this.catalogName, this.schemaPattern, this.functionPattern, this.sessionContext);
        LOGGER.debug(contextString);
        ValidationUtil.throwErrorIfNull(Collections.singletonMap("catalog", this.catalogName), contextString);
        Object showFunctionsSQL = String.format("SHOW FUNCTIONS IN CATALOG %s", this.catalogName);
        if (!WildcardUtil.isNullOrEmpty(this.schemaPattern)) {
            showFunctionsSQL = (String)showFunctionsSQL + String.format(" SCHEMA LIKE '%s'", this.schemaPattern);
        }
        if (!WildcardUtil.isNullOrEmpty(this.functionPattern)) {
            showFunctionsSQL = (String)showFunctionsSQL + String.format(" LIKE '%s'", this.functionPattern);
        }
        return showFunctionsSQL;
    }

    private String fetchTableTypesSQL() {
        return "SHOW TABLE_TYPES";
    }

    private String fetchPrimaryKeysSQL() throws SQLException {
        String contextString = String.format("Building command for fetching primary keys. Catalog %s, Schema %s, Table %s. With session context: %s", this.catalogName, this.schemaName, this.tableName, this.sessionContext);
        LOGGER.debug(contextString);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("catalog", this.catalogName);
        hashMap.put("schema", this.schemaName);
        hashMap.put("table", this.tableName);
        ValidationUtil.throwErrorIfNull(hashMap, contextString);
        return String.format("SHOW KEYS IN CATALOG %s IN SCHEMA %s IN TABLE %s", this.catalogName, this.schemaName, this.tableName);
    }

    private String fetchForeignKeysSQL() throws SQLException {
        String contextString = String.format("Building command for fetching foreign keys. Catalog %s, Schema %s, Table %s. With session context: %s", this.catalogName, this.schemaName, this.tableName, this.sessionContext);
        LOGGER.debug(contextString);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("catalog", this.catalogName);
        hashMap.put("schema", this.schemaName);
        hashMap.put("table", this.tableName);
        ValidationUtil.throwErrorIfNull(hashMap, contextString);
        return String.format("SHOW FOREIGN KEYS IN CATALOG %s IN SCHEMA %s IN TABLE %s", this.catalogName, this.schemaName, this.tableName);
    }

    public String getSQLString(CommandName command) throws SQLException {
        switch (command) {
            case LIST_CATALOGS: {
                return this.fetchCatalogSQL();
            }
            case LIST_PRIMARY_KEYS: {
                return this.fetchPrimaryKeysSQL();
            }
            case LIST_SCHEMAS: {
                return this.fetchSchemaSQL();
            }
            case LIST_TABLE_TYPES: {
                return this.fetchTableTypesSQL();
            }
            case LIST_TABLES: {
                return this.fetchTablesSQL();
            }
            case LIST_FUNCTIONS: {
                return this.fetchFunctionsSQL();
            }
            case LIST_COLUMNS: {
                return this.fetchColumnsSQL();
            }
            case LIST_FOREIGN_KEYS: {
                return this.fetchForeignKeysSQL();
            }
        }
        throw new DatabricksSQLFeatureNotSupportedException(String.format("Invalid command issued %s. Context: %s", new Object[]{command, this.sessionContext}));
    }
}

