/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.model.telemetry.TelemetryFrontendLog;
import com.databricks.jdbc.telemetry.ITelemetryClient;
import com.databricks.jdbc.telemetry.ITelemetryPushClient;
import com.databricks.jdbc.telemetry.TelemetryClientFactory;
import com.databricks.jdbc.telemetry.TelemetryPushTask;
import com.databricks.jdbc.telemetry.latency.TelemetryCollector;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TelemetryClient
implements ITelemetryClient {
    private final IDatabricksConnectionContext context;
    private final DatabricksConfig databricksConfig;
    private final int eventsBatchSize;
    private final ExecutorService executorService;
    private final ITelemetryPushClient telemetryPushClient;
    private final ScheduledExecutorService scheduledExecutorService;
    private List<TelemetryFrontendLog> eventsBatch = new LinkedList<TelemetryFrontendLog>();
    private volatile long lastFlushedTime;
    private ScheduledFuture<?> flushTask;
    private final int flushIntervalMillis;

    private static ThreadFactory createSchedulerThreadFactory() {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Telemetry-Scheduler-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public TelemetryClient(IDatabricksConnectionContext connectionContext, ExecutorService executorService, DatabricksConfig config) {
        this.eventsBatchSize = connectionContext.getTelemetryBatchSize();
        this.context = connectionContext;
        this.databricksConfig = config;
        this.executorService = executorService;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(TelemetryClient.createSchedulerThreadFactory());
        this.flushIntervalMillis = this.context.getTelemetryFlushIntervalInMilliseconds();
        this.lastFlushedTime = System.currentTimeMillis();
        this.telemetryPushClient = TelemetryClientFactory.getTelemetryPushClient(true, this.context, this.databricksConfig);
        this.schedulePeriodicFlush();
    }

    public TelemetryClient(IDatabricksConnectionContext connectionContext, ExecutorService executorService) {
        this.eventsBatchSize = connectionContext.getTelemetryBatchSize();
        this.context = connectionContext;
        this.databricksConfig = null;
        this.executorService = executorService;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(TelemetryClient.createSchedulerThreadFactory());
        this.flushIntervalMillis = this.context.getTelemetryFlushIntervalInMilliseconds();
        this.lastFlushedTime = System.currentTimeMillis();
        this.telemetryPushClient = TelemetryClientFactory.getTelemetryPushClient(false, this.context, null);
        this.schedulePeriodicFlush();
    }

    private void schedulePeriodicFlush() {
        if (this.flushTask != null) {
            this.flushTask.cancel(false);
        }
        this.flushTask = this.scheduledExecutorService.scheduleAtFixedRate(this::periodicFlush, this.flushIntervalMillis, this.flushIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void periodicFlush() {
        long now = System.currentTimeMillis();
        if (now - this.lastFlushedTime >= (long)this.flushIntervalMillis) {
            this.flush(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportEvent(TelemetryFrontendLog event) {
        TelemetryClient telemetryClient = this;
        synchronized (telemetryClient) {
            this.eventsBatch.add(event);
        }
        if (this.isBatchFull()) {
            this.flush(false);
        }
    }

    @Override
    public void close() {
        TelemetryCollector.getInstance().exportAllPendingTelemetryDetails();
        this.flush(true);
        if (this.flushTask != null) {
            this.flushTask.cancel(false);
        }
        this.scheduledExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean forceFlush) {
        TelemetryClient telemetryClient = this;
        synchronized (telemetryClient) {
            if (!forceFlush ? this.isBatchFull() : !this.eventsBatch.isEmpty()) {
                List<TelemetryFrontendLog> logsToBeFlushed = this.eventsBatch;
                this.executorService.submit(new TelemetryPushTask(logsToBeFlushed, this.telemetryPushClient));
                this.eventsBatch = new LinkedList<TelemetryFrontendLog>();
            }
            this.lastFlushedTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentSize() {
        TelemetryClient telemetryClient = this;
        synchronized (telemetryClient) {
            return this.eventsBatch.size();
        }
    }

    private boolean isBatchFull() {
        return this.eventsBatch.size() >= this.eventsBatchSize;
    }
}

