/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.common.future;

import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.databricks.client.dsi.dataengine.interfaces.IArray;
import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.interfaces.future.IJDBCDataSource;
import com.databricks.client.dsi.dataengine.interfaces.future.IResultSet;
import com.databricks.client.dsi.dataengine.interfaces.future.ISqlDataSourceVector;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.future.UnsupportedException;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.jdbc.common.BaseForwardResultSet;
import com.databricks.client.jdbc.common.SResultSetMetaData;
import com.databricks.client.jdbc.interfaces.IResultSetParent;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.ExceptionType;
import com.databricks.client.utilities.TypeNames;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class SForwardResultSet
extends BaseForwardResultSet<IResultSetParent, IResultSet> {
    private final IJDBCDataSource[] m_dataSources = SForwardResultSet.initDataSources(this.m_resultSet, this.m_warningListener, this.m_logger);
    private Closeable m_lastReturnedStream = null;
    protected long m_tempPrimitiveStorage;
    private static Getter<IArray, Object> s_arrayGetter = new Getter<IArray, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2003);
        }

        @Override
        protected IArray doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getArray();
        }
    };
    private static Getter<InputStream, Object> s_asciiStreamGetter = new Getter<InputStream, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-1);
        }

        @Override
        protected InputStream doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return this.returnStream(sForwardResultSet, iJDBCDataSource.getAsciiStream());
        }
    };
    private static Getter<BigDecimal, Object> s_bigDecimalGetter = new Getter<BigDecimal, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(3);
        }

        @Override
        protected BigDecimal doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getBigDecimal();
        }
    };
    private static Getter<BigDecimal, Object> s_bigDecimalGetterWithScale = new Getter<BigDecimal, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(3);
        }

        @Override
        protected BigDecimal doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getBigDecimal((int)sForwardResultSet.m_tempPrimitiveStorage);
        }
    };
    private static Getter<InputStream, Object> s_binaryStreamGetter = new Getter<InputStream, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-1);
        }

        @Override
        protected InputStream doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return this.returnStream(sForwardResultSet, iJDBCDataSource.getBinaryStream());
        }
    };
    private static Getter<Blob, Object> s_blobGetter = new Getter<Blob, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-4);
        }

        @Override
        protected Blob doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getBlob();
        }
    };
    private static Getter<byte[], Object> s_bytesGetter = new Getter<byte[], Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-3);
        }

        @Override
        protected byte[] doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getBytes();
        }
    };
    private static Getter<Reader, Object> s_charStreamGetter = new Getter<Reader, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-1);
        }

        @Override
        protected Reader doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return this.returnStream(sForwardResultSet, iJDBCDataSource.getCharacterStream());
        }
    };
    private static Getter<Clob, Object> s_clobGetter = new Getter<Clob, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2005);
        }

        @Override
        protected Clob doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getClob();
        }
    };
    private static Getter<Date, Object> s_dateGetter = new Getter<Date, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(91);
        }

        @Override
        protected Date doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getDate();
        }
    };
    private static Getter<Date, Calendar> s_dateGetterWithCal = new Getter<Date, Calendar>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(91);
        }

        @Override
        protected Date doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Calendar calendar) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getDate(calendar);
        }
    };
    private static Getter<Reader, Object> s_nCharStreamGetter = new Getter<Reader, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-16);
        }

        @Override
        protected Reader doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return this.returnStream(sForwardResultSet, iJDBCDataSource.getNCharacterStream());
        }
    };
    private static Getter<NClob, Object> s_nClobGetter = new Getter<NClob, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2011);
        }

        @Override
        protected NClob doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getNClob();
        }
    };
    private static Getter<String, Object> s_nStringGetter = new Getter<String, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-9);
        }

        @Override
        protected String doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getNString();
        }
    };
    private static Getter<Object, Object> s_objectGetter = new Getter<Object, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2000);
        }

        @Override
        protected Object doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getObject();
        }
    };
    private static Getter<Object, Map<String, Class<?>>> s_objectGetterWithMap = new Getter<Object, Map<String, Class<?>>>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2000);
        }

        @Override
        protected Object doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Map<String, Class<?>> map) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getObject(map);
        }
    };
    protected static Getter<Object, Class<?>> s_objectGetterWithClass = new Getter<Object, Class<?>>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2000);
        }

        @Override
        protected Object doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Class<?> clazz) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getObject(clazz);
        }
    };
    private static Getter<Ref, Object> s_refGetter = new Getter<Ref, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2006);
        }

        @Override
        protected Ref doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getRef();
        }
    };
    private static Getter<RowId, Object> s_rowIdGetter = new Getter<RowId, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-8);
        }

        @Override
        protected RowId doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getRowId();
        }
    };
    private static Getter<SQLXML, Object> s_sqlXmlGetter = new Getter<SQLXML, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2009);
        }

        @Override
        protected SQLXML doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getSQLXML();
        }
    };
    private static Getter<Time, Object> s_timeGetter = new Getter<Time, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(92);
        }

        @Override
        protected Time doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getTime();
        }
    };
    private static Getter<Time, Calendar> s_timeGetterWithCal = new Getter<Time, Calendar>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(92);
        }

        @Override
        protected Time doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Calendar calendar) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getTime(calendar);
        }
    };
    private static Getter<Timestamp, Object> s_timestampGetter = new Getter<Timestamp, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(93);
        }

        @Override
        protected Timestamp doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getTimestamp();
        }
    };
    private static Getter<Timestamp, Calendar> s_timestampGetterWithCal = new Getter<Timestamp, Calendar>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(93);
        }

        @Override
        protected Timestamp doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Calendar calendar) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getTimestamp(calendar);
        }
    };
    private static Getter<String, Object> s_stringGetter = new Getter<String, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(12);
        }

        @Override
        protected String doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getString();
        }
    };
    private static Getter<InputStream, Object> s_unicodeStreamGetter = new Getter<InputStream, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-1);
        }

        @Override
        protected InputStream doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return this.returnStream(sForwardResultSet, iJDBCDataSource.getUnicodeStream());
        }
    };
    private static Getter<URL, Object> s_urlGetter = new Getter<URL, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(70);
        }

        @Override
        protected URL doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource, Object object) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed {
            return iJDBCDataSource.getURL();
        }
    };
    private static PrimitiveGetter s_booleanGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(16);
        }

        @Override
        protected void doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed {
            sForwardResultSet.m_tempPrimitiveStorage = iJDBCDataSource.getBoolean() ? 1L : 0L;
        }
    };
    private static PrimitiveGetter s_byteGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-6);
        }

        @Override
        protected void doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed {
            sForwardResultSet.m_tempPrimitiveStorage = iJDBCDataSource.getByte();
        }
    };
    private static PrimitiveGetter s_shortGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(5);
        }

        @Override
        protected void doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed {
            sForwardResultSet.m_tempPrimitiveStorage = iJDBCDataSource.getShort();
        }
    };
    private static PrimitiveGetter s_intGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(4);
        }

        @Override
        protected void doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed {
            sForwardResultSet.m_tempPrimitiveStorage = iJDBCDataSource.getInt();
        }
    };
    private static PrimitiveGetter s_longGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-5);
        }

        @Override
        protected void doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed {
            sForwardResultSet.m_tempPrimitiveStorage = iJDBCDataSource.getLong();
        }
    };
    private static PrimitiveGetter s_floatGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(7);
        }

        @Override
        protected void doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed {
            sForwardResultSet.m_tempPrimitiveStorage = Float.floatToRawIntBits(iJDBCDataSource.getFloat());
        }
    };
    private static PrimitiveGetter s_doubleGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(8);
        }

        @Override
        protected void doGet(SForwardResultSet sForwardResultSet, IJDBCDataSource iJDBCDataSource) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed {
            sForwardResultSet.m_tempPrimitiveStorage = Double.doubleToRawLongBits(iJDBCDataSource.getDouble());
        }
    };

    public SForwardResultSet(IResultSetParent iResultSetParent, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(iResultSetParent, iResultSet, iLogger);
    }

    private static IJDBCDataSource[] initDataSources(IResultSet iResultSet, IWarningListener iWarningListener, ILogger iLogger) throws SQLException {
        if (iResultSet == null) {
            return null;
        }
        try {
            if (iResultSet instanceof ISqlDataSourceVector) {
                ISqlDataSourceVector iSqlDataSourceVector = (ISqlDataSourceVector)((Object)iResultSet);
                List<? extends IColumn> list = iResultSet.getSelectColumns();
                IJDBCDataSource[] iJDBCDataSourceArray = new IJDBCDataSource[list.size()];
                for (int i = 0; i < iJDBCDataSourceArray.length; ++i) {
                    iJDBCDataSourceArray[i] = ConvertingJDBCDataSource.wrapSqlDataSourceIfNecessary(iSqlDataSourceVector.getSqlDataSource(i), list.get(i).getTypeMetadata(), iWarningListener);
                }
                return iJDBCDataSourceArray;
            }
            throw new RuntimeException("resultSet must implement com.databricks.dsi.dataengine.interfaces.future.ISqlDataSourceVector");
        }
        catch (UnsupportedException unsupportedException) {
            throw SForwardResultSet.getUnsupportedException(iWarningListener);
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, iWarningListener, iLogger);
        }
    }

    protected static final SQLException getUnsupportedException(IWarningListener iWarningListener) {
        return ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, iWarningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
    }

    protected final SQLException getUnsupportedException() {
        return SForwardResultSet.getUnsupportedException(this.m_warningListener);
    }

    protected IJDBCDataSource getDataSource(int n) {
        return this.m_dataSources[n];
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.initializeColumnsIfNeeded();
            if (this.getResultSetMetaData() == null) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(this.createResultSetMetadata());
                assert (this.getResultSetMetaData() != null);
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    protected abstract SResultSetMetaData createResultSetMetadata();

    @Override
    protected void closeCurrentStream() {
        if (this.m_lastReturnedStream != null) {
            try {
                this.m_lastReturnedStream.close();
            }
            catch (IOException iOException) {
                LogUtilities.logDebug(iOException, this.m_logger);
            }
            this.m_lastReturnedStream = null;
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.checkIfOpen();
        IArray iArray = s_arrayGetter.get(this, n);
        return iArray == null ? null : this.createArray(iArray);
    }

    protected Array createArray(IArray iArray) throws SQLException {
        return this.m_parentStatement.getObjectFactory().newArray(iArray, this.m_parentStatement.getJDBCConnection(), this.m_warningListener, this.m_logger);
    }

    @Override
    public String getString(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_stringGetter.get(this, n);
    }

    protected SQLException getInvalidColumnTypeException(int n) {
        return this.getInvalidColumnTypeException(n, ((IColumn)this.m_resultSetColumns.get(n - 1)).getTypeMetadata().getTypeName());
    }

    protected SQLException getInvalidColumnTypeException(int n, String string) {
        return ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_booleanGetter.get(this, n);
        return this.m_tempPrimitiveStorage != 0L;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_byteGetter.get(this, n);
        return (byte)this.m_tempPrimitiveStorage;
    }

    @Override
    public short getShort(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_shortGetter.get(this, n);
        return (short)this.m_tempPrimitiveStorage;
    }

    @Override
    public int getInt(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_intGetter.get(this, n);
        return (int)this.m_tempPrimitiveStorage;
    }

    @Override
    public long getLong(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_longGetter.get(this, n);
        return this.m_tempPrimitiveStorage;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_floatGetter.get(this, n);
        return Float.intBitsToFloat((int)this.m_tempPrimitiveStorage);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_doubleGetter.get(this, n);
        return Double.longBitsToDouble(this.m_tempPrimitiveStorage);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.m_tempPrimitiveStorage = n2;
        return s_bigDecimalGetterWithScale.get(this, n);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_bytesGetter.get(this, n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_dateGetter.get(this, n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_timeGetter.get(this, n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_timestampGetter.get(this, n);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_asciiStreamGetter.get(this, n);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_unicodeStreamGetter.get(this, n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_binaryStreamGetter.get(this, n);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_objectGetter.get(this, n);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_charStreamGetter.get(this, n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_bigDecimalGetter.get(this, n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_objectGetterWithMap.get(this, n, map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_refGetter.get(this, n);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_blobGetter.get(this, n);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_clobGetter.get(this, n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_dateGetterWithCal.get(this, n, calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_timeGetterWithCal.get(this, n, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_timestampGetterWithCal.get(this, n, calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_urlGetter.get(this, n);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_rowIdGetter.get(this, n);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_nClobGetter.get(this, n);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_sqlXmlGetter.get(this, n);
    }

    @Override
    public String getNString(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_nStringGetter.get(this, n);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_nCharStreamGetter.get(this, n);
    }

    private static abstract class PrimitiveGetter {
        private PrimitiveGetter() {
        }

        public final void get(SForwardResultSet sForwardResultSet, int n) throws SQLException {
            sForwardResultSet.checkIfOpen();
            try {
                sForwardResultSet.checkIfValidColumnNumber(n);
                sForwardResultSet.closeCurrentStream();
                IJDBCDataSource iJDBCDataSource = sForwardResultSet.getDataSource(n - 1);
                this.doGet(sForwardResultSet, iJDBCDataSource);
                sForwardResultSet.m_wasLastValueNull = iJDBCDataSource.wasNull();
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw sForwardResultSet.getInvalidColumnTypeException(n, this.getTypeName());
            }
            catch (ConversionFailed conversionFailed) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, (IWarningListener)sForwardResultSet.m_warningListener, ExceptionType.DATA, this.getTypeName());
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, sForwardResultSet.m_warningListener, sForwardResultSet.m_logger);
            }
        }

        protected abstract String getTypeName();

        protected abstract void doGet(SForwardResultSet var1, IJDBCDataSource var2) throws ErrorException, IncorrectTypeException, SQLException, ConversionFailed;
    }

    protected static abstract class Getter<T, S> {
        protected Getter() {
        }

        public final T get(SForwardResultSet sForwardResultSet, int n) throws SQLException {
            return this.get(sForwardResultSet, n, null);
        }

        public final T get(SForwardResultSet sForwardResultSet, int n, S s) throws SQLException {
            sForwardResultSet.checkIfOpen();
            try {
                sForwardResultSet.checkIfValidColumnNumber(n);
                sForwardResultSet.closeCurrentStream();
                IJDBCDataSource iJDBCDataSource = sForwardResultSet.getDataSource(n - 1);
                T t = this.doGet(sForwardResultSet, iJDBCDataSource, s);
                sForwardResultSet.m_wasLastValueNull = t == null;
                return t;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw sForwardResultSet.getInvalidColumnTypeException(n, this.getTypeName());
            }
            catch (UnsupportedException unsupportedException) {
                throw sForwardResultSet.getUnsupportedException();
            }
            catch (ConversionFailed conversionFailed) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, (IWarningListener)sForwardResultSet.m_warningListener, ExceptionType.DATA, this.getTypeName());
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, sForwardResultSet.m_warningListener, sForwardResultSet.m_logger);
            }
        }

        protected final <Y extends Closeable> Y returnStream(SForwardResultSet sForwardResultSet, Y y) {
            sForwardResultSet.m_lastReturnedStream = y;
            return y;
        }

        protected abstract String getTypeName();

        protected abstract T doGet(SForwardResultSet var1, IJDBCDataSource var2, S var3) throws ErrorException, IncorrectTypeException, UnsupportedException, SQLException, ConversionFailed;
    }
}

