/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aebuilder.relation;

import com.databricks.client.sqlengine.aeprocessor.AEQColumnName;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.value.AEColumnReferenceBuilder;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.AESortSpec;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.databricks.client.sqlengine.exceptions.InvalidQueryException;
import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.PTFlagNode;
import com.databricks.client.sqlengine.parser.parsetree.PTListNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.type.PTFlagType;
import com.databricks.client.sqlengine.parser.type.PTListType;
import com.databricks.client.sqlengine.parser.type.PTLiteralType;
import com.databricks.client.sqlengine.parser.type.PTNonterminalType;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class AESortSpecBuilder {
    public static List<AESortSpec> build(AEQueryScope aEQueryScope, AEValueExprList aEValueExprList) throws ErrorException {
        PTListNode pTListNode = aEQueryScope.getPtSortSpecList();
        if (pTListNode == null) {
            return null;
        }
        AESortSpecBuilder.checkOrderByListIsValid(pTListNode);
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.ORDER_BY);
        return AESortSpecBuilder.buildSortSpecificationList(pTListNode, aEQueryScope, aEValueExprList);
    }

    private static List<AESortSpec> buildSortSpecificationList(PTListNode pTListNode, AEQueryScope aEQueryScope, AEValueExprList aEValueExprList) throws ErrorException {
        int n = aEValueExprList.getNumChildren();
        ArrayList<AESortSpec> arrayList = new ArrayList<AESortSpec>(n);
        AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(aEQueryScope);
        for (IPTNode iPTNode : pTListNode) {
            PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
            IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.SORT_KEY);
            boolean bl = AESortSpecBuilder.isOrderSpecAscending(pTNonterminalNode.getChild(PTPositionalType.ORDER_SPEC));
            int n2 = AESortSpecBuilder.findColumnInSelectList(aEValueExprList, iPTNode2, aEQueryScope);
            if (0 > n2) {
                AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprBuilder.build(iPTNode2);
                if (aEValueExpr instanceof AELiteral) {
                    n2 = AESortSpecBuilder.decodeColumnNumber((AELiteral)aEValueExpr);
                    if (n2 < 0 || n2 >= n) {
                        throw SQLEngineExceptionFactory.orderByPositionOutOfRangeException();
                    }
                } else {
                    if (aEValueExpr instanceof AEParameter) {
                        throw new SQLEngineException(SQLEngineMessageKey.DYN_PARAM_NOT_ALLOWED.name(), new String[]{"ORDER BY"});
                    }
                    AESortSpecBuilder.validateSortKey(aEValueExpr, aEQueryScope);
                    n2 = AESortSpecBuilder.resolveColumn(aEValueExprList, aEValueExpr, aEQueryScope);
                }
            }
            assert (n2 >= 0);
            arrayList.add(new AESortSpec(n2, bl));
        }
        return arrayList;
    }

    private static int findColumnInSelectList(AEValueExprList aEValueExprList, IPTNode iPTNode, AEQueryScope aEQueryScope) throws ErrorException {
        AEQColumnName aEQColumnName;
        int n = -1;
        try {
            aEQColumnName = AEColumnReferenceBuilder.buildQualifiedColumnName(aEQueryScope.getDataEngine().getContext(), iPTNode);
        }
        catch (ErrorException errorException) {
            return n;
        }
        int n2 = aEValueExprList.getNumChildren();
        AEValueExpr aEValueExpr = null;
        for (int i = 0; i < n2; ++i) {
            AEValueExpr aEValueExpr2 = (AEValueExpr)aEValueExprList.getChild(i);
            if (!aEValueExpr2.matchesName(aEQColumnName, aEQueryScope.isCaseSensitive())) continue;
            if (aEValueExpr2.isSortable()) {
                if (null == aEValueExpr) {
                    n = i;
                    aEValueExpr = aEValueExpr2;
                    continue;
                }
                if (aEValueExpr2.isEquivalent(aEValueExpr)) continue;
                throw SQLEngineExceptionFactory.columnReferenceNotUniqueException(aEQColumnName.toString());
            }
            throw SQLEngineExceptionFactory.invalidOrderByColumnException(aEQColumnName.toString());
        }
        return n;
    }

    private static int resolveColumn(AEValueExprList aEValueExprList, AEValueExpr aEValueExpr, AEQueryScope aEQueryScope) throws InvalidQueryException {
        int n = aEValueExprList.findNode(aEValueExpr);
        if (0 > n) {
            if (aEQueryScope.hasDistinct()) {
                throw new InvalidQueryException(SQLEngineMessageKey.ORDERBY_EXPR_NOT_IN_SELECT_DISTINCT.name());
            }
            if (aEQueryScope.hasSetOperation()) {
                throw new InvalidQueryException(SQLEngineMessageKey.ORDERBY_EXPR_NOT_IN_SELECTLIST.name());
            }
            n = aEValueExprList.getNumChildren();
            aEValueExprList.addNode(aEValueExpr);
        }
        return n;
    }

    private static void validateSortKey(AEValueExpr aEValueExpr, final AEQueryScope aEQueryScope) throws ErrorException {
        AEDefaultVisitor<Boolean> aEDefaultVisitor = new AEDefaultVisitor<Boolean>(){

            @Override
            public Boolean visit(AESearchedCase aESearchedCase) throws ErrorException {
                throw SQLEngineExceptionFactory.invalidOrderByColumnException("CASE");
            }

            @Override
            public Boolean visit(AESimpleCase aESimpleCase) throws ErrorException {
                throw SQLEngineExceptionFactory.invalidOrderByColumnException("CASE");
            }

            @Override
            public Boolean visit(AEColumnReference aEColumnReference) throws ErrorException {
                if (!aEColumnReference.isSortable()) {
                    throw SQLEngineExceptionFactory.invalidOrderByColumnException(aEColumnReference.getQColumnName().toString());
                }
                return true;
            }

            @Override
            public Boolean visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
                switch (aEGeneralAggrFn.getAggrFnId()) {
                    case COUNT: 
                    case SUM: {
                        if (!aEQueryScope.hasGroupingExpression()) break;
                        return true;
                    }
                }
                return aEGeneralAggrFn.getOperand().acceptVisitor(this);
            }

            @Override
            public Boolean visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
                return aEQueryScope.hasGroupingExpression();
            }

            @Override
            protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
                boolean bl = false;
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    IAENode iAENode2 = iterator.next();
                    bl = bl || iAENode2.acceptVisitor(this) != false;
                }
                return bl;
            }
        };
        if (!aEValueExpr.acceptVisitor(aEDefaultVisitor).booleanValue()) {
            throw SQLEngineExceptionFactory.invalidOrderByExprException();
        }
    }

    private static void checkOrderByListIsValid(PTListNode pTListNode) throws ErrorException {
        AEBuilderCheck.ParseTreeMatcher parseTreeMatcher = AEBuilderCheck.nonTerminal(PTNonterminalType.SORT_SPECIFICATION).withExactChildren(PTPositionalType.SORT_KEY, AEBuilderCheck.anything(), PTPositionalType.ORDER_SPEC, AEBuilderCheck.optional(AEBuilderCheck.instanceOf(PTFlagNode.class)));
        AEBuilderCheck.checkThat(pTListNode, AEBuilderCheck.is(AEBuilderCheck.list(PTListType.SORT_SPECIFICATION_LIST)).withChildren(parseTreeMatcher));
    }

    private static int decodeColumnNumber(AELiteral aELiteral) throws ErrorException {
        if (PTLiteralType.USINT != aELiteral.getLiteralType()) {
            throw SQLEngineExceptionFactory.invalidOrderByExprException();
        }
        try {
            int n = Integer.parseInt(aELiteral.getStringValue());
            return n - 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw SQLEngineExceptionFactory.orderByPositionOutOfRangeException();
        }
    }

    private static boolean isOrderSpecAscending(IPTNode iPTNode) {
        if (iPTNode.isEmptyNode()) {
            return true;
        }
        assert (EnumSet.of(PTFlagType.ASC, PTFlagType.DESC).contains((Object)((PTFlagNode)iPTNode).getFlagType()));
        return PTFlagType.ASC == ((PTFlagNode)iPTNode).getFlagType();
    }
}

