/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.materializer;

import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.databricks.client.sqlengine.executor.conversions.SqlConverterGenerator;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.sqlengine.executor.etree.ETResourceManager;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.value.ETParameter;
import com.databricks.client.sqlengine.utilities.ExternalAlgorithmUtil;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.Pair;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Map;

public class MaterializerContext {
    private Map<AERelationalExpr, ETRelationalExpr> m_materializedRelationMap;
    private final SqlConverterGenerator m_converterGenerator;
    private final IWarningListener m_warningListener;
    private final SqlDataEngineContext m_dataEngineContext;
    private long m_sharedBytesToReserve = 0L;
    private ILogger m_log;
    private final ETCancelState m_cancelState;
    private Map<AENamedRelationalExpr, Pair<AEBinaryRelationalExpr, Integer>> m_joinMapping;
    private Map<AERelationalExpr, ETRelationalExpr> m_joinOperandWrapperMapping;
    private Map<Integer, ETParameter> m_parameters;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_extAlgoProp = null;
    private final ETResourceManager m_rManager;

    public MaterializerContext(SqlConverterGenerator sqlConverterGenerator, IWarningListener iWarningListener, SqlDataEngineContext sqlDataEngineContext, ETResourceManager eTResourceManager, ILogger iLogger) {
        this.m_converterGenerator = sqlConverterGenerator;
        this.m_warningListener = iWarningListener;
        this.m_materializedRelationMap = new HashMap<AERelationalExpr, ETRelationalExpr>();
        this.m_dataEngineContext = sqlDataEngineContext;
        this.m_joinMapping = new HashMap<AENamedRelationalExpr, Pair<AEBinaryRelationalExpr, Integer>>();
        this.m_joinOperandWrapperMapping = new HashMap<AERelationalExpr, ETRelationalExpr>();
        this.m_parameters = new HashMap<Integer, ETParameter>();
        this.m_log = iLogger;
        this.m_cancelState = new ETCancelState();
        this.m_rManager = eTResourceManager;
    }

    public SqlConverterGenerator getSqlConverterGenerator() {
        return this.m_converterGenerator;
    }

    public ILogger getLog() {
        return this.m_log;
    }

    public ETRelationalExpr getMaterializedRelation(AERelationalExpr aERelationalExpr) {
        return this.m_materializedRelationMap.get(aERelationalExpr);
    }

    public Pair<AEBinaryRelationalExpr, Integer> resolveJoinRelation(AENamedRelationalExpr aENamedRelationalExpr) {
        return this.m_joinMapping.get(aENamedRelationalExpr);
    }

    public ETRelationalExpr getJoinOperandWrapper(AERelationalExpr aERelationalExpr) {
        return this.m_joinOperandWrapperMapping.get(aERelationalExpr);
    }

    public SqlDataEngineContext getDataEngineContext() {
        return this.m_dataEngineContext;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    public ETCancelState getCancelState() {
        return this.m_cancelState;
    }

    public ETResourceManager getResourceManager() {
        return this.m_rManager;
    }

    public void setMaterializedRelation(AERelationalExpr aERelationalExpr, ETRelationalExpr eTRelationalExpr) {
        if (this.m_materializedRelationMap.containsKey(aERelationalExpr)) {
            throw new UnsupportedOperationException("Logic error - the key: " + aERelationalExpr + " already has a materialized relation.");
        }
        this.m_materializedRelationMap.put(aERelationalExpr, eTRelationalExpr);
    }

    public void requireSharedBytes(long l) {
        if (0L > l) {
            throw new IllegalArgumentException();
        }
        if (l > this.m_sharedBytesToReserve) {
            this.m_sharedBytesToReserve = l;
        }
    }

    public void setJoinMapping(AENamedRelationalExpr aENamedRelationalExpr, AEBinaryRelationalExpr aEBinaryRelationalExpr, int n) {
        if (!(aEBinaryRelationalExpr instanceof AEJoin) && !(aEBinaryRelationalExpr instanceof AECrossJoin)) {
            throw new IllegalArgumentException("Join mapping is set with none join node.");
        }
        this.m_joinMapping.put(aENamedRelationalExpr, new Pair<AEBinaryRelationalExpr, Integer>(aEBinaryRelationalExpr, n));
    }

    public void setJoinOperandWrapper(AERelationalExpr aERelationalExpr, ETRelationalExpr eTRelationalExpr) {
        if (this.m_joinOperandWrapperMapping.containsKey(aERelationalExpr)) {
            throw new UnsupportedOperationException("Logic error - the key: " + aERelationalExpr + " already has a materialized relation wrapper.");
        }
        this.m_joinOperandWrapperMapping.put(aERelationalExpr, eTRelationalExpr);
    }

    public void updateMapping(AEBinaryRelationalExpr aEBinaryRelationalExpr, AEBinaryRelationalExpr aEBinaryRelationalExpr2, int n) {
        for (Map.Entry<AENamedRelationalExpr, Pair<AEBinaryRelationalExpr, Integer>> entry : this.m_joinMapping.entrySet()) {
            AEBinaryRelationalExpr aEBinaryRelationalExpr3 = entry.getValue().key();
            if (aEBinaryRelationalExpr3 != aEBinaryRelationalExpr) continue;
            entry.getValue().setKey(aEBinaryRelationalExpr2);
            entry.getValue().setValue(entry.getValue().value() + n);
        }
    }

    public void registerParameter(int n, ETParameter eTParameter) {
        if (this.m_parameters.containsKey(n)) {
            throw new IllegalArgumentException("Duplicate parameter index.");
        }
        this.m_parameters.put(n, eTParameter);
    }

    public Map<Integer, ETParameter> getParameters() {
        return this.m_parameters;
    }

    public ExternalAlgorithmUtil.ExternalAlgorithmProperties getExternalAlgorithmProperties() throws ErrorException {
        if (this.m_extAlgoProp == null) {
            this.m_extAlgoProp = ExternalAlgorithmUtil.createProperties(this.m_dataEngineContext.getDataEngine(), this.m_log, this.m_warningListener, this.m_rManager);
        }
        return this.m_extAlgoProp;
    }
}

