/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

@Deprecated
public abstract class TimestampJDBCDataSink
extends ConvertingJDBCDataSink {
    private final int m_fractionalSecondsPrecision;

    public TimestampJDBCDataSink(IWarningListener iWarningListener, TypeMetadata typeMetadata, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
        assert (typeMetadata.getPrecision() >= 0);
        this.m_fractionalSecondsPrecision = typeMetadata.getPrecision();
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fractionalSecondsPrecision;
    }

    protected abstract void doSet(Timestamp var1, Calendar var2) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object != null && !(object instanceof Timestamp)) {
            throw new IncorrectTypeException();
        }
        this.doSet((Timestamp)object, this.getLocalCalendarForConversions());
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: {
                this.doSet(null, null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            Timestamp timestamp = NonTrivialJDBCConversions.stringToTimestamp(string, this.getFractionalSecondsPrecision(), this.getAndClearListener(), null);
            if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
                this.onFractionalTruncation(string, this.getFractionalSecondsPrecision(), "setString");
            }
            this.doSet(timestamp, this.getLocalCalendarForConversions());
        }
    }

    @Override
    public void setDate(Date date, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (date == null) {
            this.setNull(91);
        } else {
            if (calendar == null) {
                calendar = this.getLocalCalendarForConversions();
            }
            this.setTimestamp(NonTrivialJDBCConversions.dateToTimestamp(date, calendar), calendar);
        }
    }

    @Override
    public void setTime(Time time, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (time == null) {
            this.setNull(92);
        } else {
            Timestamp timestamp = NonTrivialJDBCConversions.timeToTimestamp(time, this.getFractionalSecondsPrecision(), calendar, this.getAndClearListener());
            if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
                this.onFractionalTruncation(time, this.getFractionalSecondsPrecision(), "setTime");
            }
            this.setTimestamp(timestamp, calendar);
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (timestamp == null) {
            this.setNull(93);
        } else {
            int n;
            if (calendar == null) {
                calendar = this.getLocalCalendarForConversions();
            }
            if ((n = NonTrivialJDBCConversions.roundNanosecondsToPrecision(timestamp.getNanos(), this.m_fractionalSecondsPrecision)) != timestamp.getNanos()) {
                this.onFractionalTruncation(timestamp, this.m_fractionalSecondsPrecision, "setTimestamp");
                timestamp.setNanos(n);
            }
            this.doSet(timestamp, calendar);
        }
    }
}

