/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.dataengine.utilities;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContextStatus;
import com.databricks.client.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.databricks.client.dsi.dataengine.utilities.ParameterInputValue;
import com.databricks.client.dsi.dataengine.utilities.ParameterOutputValue;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ExecutionContext {
    private ArrayList<ParameterInputValue> m_inputs;
    private ArrayList<ParameterOutputValue> m_outputs;
    private ParameterGeneratedValues m_generatedParams;
    private ExecutionContextStatus m_status;

    protected ExecutionContext(ArrayList<ParameterInputValue> arrayList, ArrayList<ParameterOutputValue> arrayList2) {
        this(arrayList, arrayList2, null);
    }

    protected ExecutionContext(ArrayList<ParameterInputValue> arrayList, ArrayList<ParameterOutputValue> arrayList2, ParameterGeneratedValues parameterGeneratedValues) {
        this.m_inputs = arrayList;
        this.m_outputs = arrayList2;
        this.m_generatedParams = parameterGeneratedValues;
        this.m_status = ExecutionContextStatus.NOT_EXECUTED;
    }

    public ExecutionContextStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(ExecutionContextStatus executionContextStatus) {
        this.m_status = Objects.requireNonNull(executionContextStatus);
    }

    public ArrayList<ParameterInputValue> getInputs() {
        return this.m_inputs;
    }

    public ArrayList<ParameterOutputValue> getOutputs() {
        return this.m_outputs;
    }

    public ParameterGeneratedValues getGeneratedParameters() {
        return this.m_generatedParams;
    }

    public int[] getSelectedGeneratedColumns(List<IColumn> list) throws ErrorException {
        return ExecutionContext.getSelectedGeneratedColumns(this.m_generatedParams, list);
    }

    public static int[] getSelectedGeneratedColumns(ParameterGeneratedValues parameterGeneratedValues, List<IColumn> list) throws ErrorException {
        String[] stringArray;
        assert (null != list);
        if (parameterGeneratedValues == null || Boolean.FALSE.equals(parameterGeneratedValues.isAutoGeneratedKeys())) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            stringArray = list.get(i);
            if (!stringArray.isAutoUnique()) continue;
            arrayList.add(i + 1);
            hashMap.put(stringArray.getName().toLowerCase(), i + 1);
        }
        if (Boolean.TRUE.equals(parameterGeneratedValues.isAutoGeneratedKeys())) {
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                nArray[n++] = n2;
            }
            return nArray;
        }
        int[] nArray = parameterGeneratedValues.getColumnIndexes();
        if (parameterGeneratedValues.getGeneratedType() == ParameterGeneratedValues.GeneratedType.COLUMN_INDEXES) {
            for (int i = 0; i < nArray.length; ++i) {
                if (Collections.binarySearch(arrayList, nArray[i]) >= 0) continue;
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), Integer.toString(nArray[i]), ExceptionType.DATA);
            }
            return nArray;
        }
        stringArray = parameterGeneratedValues.getColumnNames();
        int[] nArray2 = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = (Integer)hashMap.get(stringArray[i].toLowerCase());
            if (n == null) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), stringArray[i], ExceptionType.DATA);
            }
            nArray2[i] = n;
        }
        return nArray2;
    }

    public void setInputParam(int n, ParameterInputValue parameterInputValue) {
        this.m_inputs.set(n, parameterInputValue);
    }
}

