/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.api;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.utilities.StringConverter;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.IServerVersion;
import com.databricks.client.hivecommon.IServerVersionUtils;
import com.databricks.client.hivecommon.api.IHiveServerBuffer;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public abstract class HiveServer2BaseBuffer
implements IHiveServerBuffer {
    private static final java.util.Date today = Calendar.getInstance().getTime();
    public TFetchResultsResp m_hiveServer2Buffer = null;
    public ILogger m_logger = null;
    protected int m_numRows = 0;
    public HiveJDBCSettings m_settings;

    public HiveServer2BaseBuffer(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
    }

    @Override
    public abstract boolean getData(int var1, long var2, long var4, DataWrapper var6, int var7, short var8, String var9, HiveJDBCSettings var10) throws ErrorException;

    public TFetchResultsResp getHiveServer2Buffer() {
        return this.m_hiveServer2Buffer;
    }

    public abstract List<Integer> getIntColumn(int var1) throws ErrorException;

    public abstract int getNumColumns();

    @Override
    public int getNumRowsInBuffer() {
        return this.m_numRows;
    }

    public abstract List<String> getStringColumn(int var1) throws ErrorException;

    @Override
    public final void initializeBuffer() throws ErrorException {
        this.setNumRows();
        this.handleInitializeBuffer();
    }

    @Override
    public boolean isGetNextBuffer(int n) throws ErrorException {
        return n >= this.m_numRows;
    }

    @Override
    public void parseRow(int n) throws ErrorException {
    }

    protected Timestamp convertTimestamp(String string) throws ErrorException {
        Timestamp timestamp = null;
        try {
            timestamp = this.m_settings.m_useCustomTimestampConverter.booleanValue() ? NonTrivialJDBCConversions.stringToTimestamp(string) : Timestamp.valueOf(string);
        }
        catch (ConversionFailed conversionFailed) {
            IServerVersionUtils iServerVersionUtils = this.m_settings.m_platformVersionUtils;
            IServerVersion iServerVersion = this.m_settings.m_serverVersion;
            if (iServerVersionUtils.supportsTimeOnlyTimestamp(iServerVersion) && this.m_settings.m_supportTimeOnlyTimestamp) {
                try {
                    Time time = StringConverter.parseTime(string, null);
                    if (null != time) {
                        timestamp = new Timestamp(time.getTime());
                        timestamp.setDate(today.getDate());
                        timestamp.setMonth(today.getMonth());
                        timestamp.setYear(today.getYear());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Date date;
                    if (iServerVersionUtils.supportsDateOnlyTimestamp(iServerVersion) && null != (date = StringConverter.parseDate(string, null))) {
                        return new Timestamp(date.getDate());
                    }
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), illegalArgumentException.getMessage());
                }
            }
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Timestamp Conversion has failed.");
        }
        return timestamp;
    }

    protected abstract void handleInitializeBuffer() throws ErrorException;

    protected abstract void setNumRows() throws ErrorException;
}

