/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.oauth;

import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.utils.OSUtils;
import com.databricks.client.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.JsonNode;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuthUtil {
    private static final String IP_LIST_SPLIT_KEY = "-";
    private static final String METADATA_ERROR_DESC = "Invalid metadata access";
    private static final String LOCAL_ADDRESS_ERROR_DESC = "Invalid local Address";
    private static final String IP_RANGE_PARSE_ERROR = "Invalid IP range parsed";

    public static boolean IsUrlAzureCloud(String string) {
        return string != null && string.endsWith(".azuredatabricks.net") || string.endsWith(".databricks.azure.cn") || string.endsWith(".databricks.azure.cn");
    }

    public static boolean IsUrlAWS_GCP(String string) {
        return string != null && string.endsWith(".databricks.com") || string.endsWith(".cloud.databricks.us") || string.endsWith(".cloud.databricks.mil") || string.endsWith(".gcp.databricks.com");
    }

    public static URI getServerURI(String string, List<String> list) throws ErrorException {
        URI uRI = null;
        OAuthUtil.checkInvalidAuthorizationUrl(string, list);
        try {
            uRI = new URL(string).toURI();
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            throw errorException;
        }
        return uRI;
    }

    public static void checkInvalidAuthorizationUrl(String string, List<String> list) throws ErrorException {
        Serializable serializable;
        Object object;
        String string2 = "";
        Boolean bl = false;
        if (string == null) {
            bl = true;
        }
        try {
            if (list != null && list.size() > 0 && OAuthUtil.isAuthURLEnabled(string, list)) {
                return;
            }
        }
        catch (MalformedURLException | UnknownHostException iOException) {
            bl = true;
            string2 = iOException.getMessage();
        }
        try {
            object = System.getenv("DATABRICKS_RUNTIME_VERSION");
            serializable = Inet6Address.getByName(new URL(string).getHost());
            if (OSUtils.isLinux() && object != null && serializable.isSiteLocalAddress()) {
                bl = true;
                string2 = LOCAL_ADDRESS_ERROR_DESC;
            }
        }
        catch (MalformedURLException | UnknownHostException iOException) {
            bl = true;
            string2 = "Invalid URL";
        }
        object = Pattern.compile("metadata|fd00:ec2::254|169.254.169.254", 2).matcher(string);
        if (((Matcher)object).find()) {
            bl = true;
            string2 = METADATA_ERROR_DESC;
        }
        if (bl.booleanValue()) {
            serializable = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), string2);
            throw serializable;
        }
    }

    public static boolean isAuthURLEnabled(String string, List<String> list) throws UnknownHostException, ErrorException, MalformedURLException {
        String string2 = OAuthUtil.fetchIPString(string);
        BigInteger bigInteger = OAuthUtil.ipToBigInt(string2);
        List<String> list2 = list;
        for (String string3 : list2) {
            if (string3.contains(IP_LIST_SPLIT_KEY)) {
                Serializable serializable;
                String[] stringArray = string3.split(IP_LIST_SPLIT_KEY);
                if (stringArray.length != 2) {
                    serializable = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), IP_RANGE_PARSE_ERROR);
                    throw serializable;
                }
                serializable = OAuthUtil.ipToBigInt(stringArray[0]);
                BigInteger bigInteger2 = OAuthUtil.ipToBigInt(stringArray[1]);
                BigInteger bigInteger3 = ((BigInteger)serializable).min(bigInteger2);
                BigInteger bigInteger4 = ((BigInteger)serializable).max(bigInteger2);
                if (bigInteger3.compareTo(bigInteger) == 1 || bigInteger4.compareTo(bigInteger) == -1) continue;
                return true;
            }
            if (OAuthUtil.ipToBigInt(string3).compareTo(bigInteger) != 0) continue;
            return true;
        }
        return false;
    }

    public static String fetchIPString(String string) throws UnknownHostException {
        try {
            string = Inet6Address.getByName(new URL(string).getHost()).getHostAddress();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return string;
    }

    public static BigInteger ipToBigInt(String string) throws UnknownHostException, ErrorException {
        InetAddress inetAddress = Inet6Address.getByName(string);
        byte[] byArray = inetAddress.getAddress();
        return new BigInteger(1, byArray);
    }

    public static void setExpiryTime(String string, OAuthSettings oAuthSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        int n = Integer.valueOf(OAuthUtil.parseJsonResponse(string.toString(), "expires_in"));
        if (oAuthSettings.m_tokenExpiryBuffer < n) {
            n -= oAuthSettings.m_tokenExpiryBuffer;
        } else {
            LogUtilities.logWarning("Token expiry buffer " + String.valueOf(oAuthSettings.m_tokenExpiryBuffer) + " is greater than the token expiry time " + n + ". A new token will be requested.", iLogger);
            n = 0;
        }
        oAuthSettings.m_expiryTime = System.currentTimeMillis() + (long)(n * 1000);
    }

    protected static String parseJsonResponse(String string, String string2) throws ErrorException {
        JsonNode jsonNode = null;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode2 = null;
        try {
            jsonNode2 = objectMapper.readTree(string);
        }
        catch (IOException iOException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), iOException.getMessage());
            errorException.initCause(iOException);
            throw errorException;
        }
        jsonNode = jsonNode2.get(string2);
        if (jsonNode != null) {
            return jsonNode.asText();
        }
        return null;
    }

    public static boolean isAccessTokenExpired(String string, int n) {
        if (string == null) {
            return true;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            return true;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Base64 base64 = new Base64(true);
        String string4 = new String(base64.decode(string2));
        String string5 = new String(base64.decode(string3));
        try {
            String string6 = OAuthUtil.parseJsonResponse(string5, "exp");
            long l = System.currentTimeMillis() / 1000L - (long)n;
            if (Long.parseLong(string6) > l) {
                return false;
            }
        }
        catch (ErrorException errorException) {
            return true;
        }
        return true;
    }
}

