/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aeoptimizer;

import com.databricks.client.sqlengine.aeprocessor.aemanipulator.AETreeManipulator;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.IAEOptimizer;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.NullRejectVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAEUnaryNode;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AENot;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExprScope;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.databricks.client.sqlengine.dsiext.dataengine.PassdownInformation;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class AEFilterOptimizer
implements IAEOptimizer {
    private final SqlDataEngineContext m_context;
    private final PassdownInformation m_passdownInfo;
    private IAENode m_currentRoot;
    private static final AEDefaultVisitor<Boolean> s_havingChecker = new AEDefaultVisitor<Boolean>(){

        @Override
        public Boolean visit(AEProxyColumn aEProxyColumn) {
            return true;
        }

        @Override
        protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
            if (iAENode.getNumChildren() > 0) {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    if (!iterator.next().acceptVisitor(this).booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }
    };

    public AEFilterOptimizer(SqlDataEngineContext sqlDataEngineContext, PassdownInformation passdownInformation) {
        this.m_context = sqlDataEngineContext;
        this.m_passdownInfo = passdownInformation;
    }

    @Override
    public void optimize(IAEStatement iAEStatement) throws ErrorException {
        this.m_currentRoot = Objects.requireNonNull(iAEStatement);
        this.clearOptimizationFlags(iAEStatement);
        this.convertOuterJoin(iAEStatement);
        this.doOptimize(iAEStatement);
        this.postProcess(iAEStatement);
    }

    private void doOptimize(IAENode iAENode) throws ErrorException {
        Objects.requireNonNull(iAENode);
        while (AETreeWalker.walk(iAENode, new OptimizeAction()).booleanValue()) {
        }
    }

    private boolean doPushDownFilter(AEBooleanExpr aEBooleanExpr, boolean bl) throws ErrorException {
        IAENode iAENode;
        assert (this.m_currentRoot != null);
        Set<AENamedRelationalExpr> set = this.extractRelationalExprs(aEBooleanExpr);
        if (set.isEmpty()) {
            this.setFilterOptimized(aEBooleanExpr);
            return false;
        }
        for (iAENode = aEBooleanExpr.getParent(); !(iAENode instanceof AERelationalExpr) && iAENode != this.m_currentRoot; iAENode = iAENode.getParent()) {
        }
        AETreeWalker aETreeWalker = new AETreeWalker(iAENode);
        AERelationalExpr aERelationalExpr = null;
        while (aETreeWalker.hasNext()) {
            IAENode iAENode2 = aETreeWalker.next();
            if (!(iAENode2 instanceof AEJoin) && !(iAENode2 instanceof AECrossJoin)) continue;
            AEBinaryRelationalExpr aEBinaryRelationalExpr = (AEBinaryRelationalExpr)iAENode2;
            PushdownInfo pushdownInfo = new PushdownInfo(aEBinaryRelationalExpr, set, bl);
            boolean bl2 = this.processJoin(pushdownInfo);
            if (!bl2) break;
            if (pushdownInfo.m_isInLeftSubTree) {
                aERelationalExpr = pushdownInfo.m_joinNode.getLeftOperand();
                pushdownInfo.m_inOuterJoinCond = false;
                aETreeWalker = new AETreeWalker(aEBinaryRelationalExpr.getLeftOperand());
                continue;
            }
            if (!pushdownInfo.m_foundRelExprInLeft) {
                aERelationalExpr = pushdownInfo.m_joinNode.getRightOperand();
                pushdownInfo.m_inOuterJoinCond = false;
                aETreeWalker = new AETreeWalker(aEBinaryRelationalExpr.getRightOperand());
                continue;
            }
            if (!(pushdownInfo.m_joinNode instanceof AECrossJoin) && ((AEJoin)pushdownInfo.m_joinNode).isOuterJoin()) continue;
            aERelationalExpr = pushdownInfo.m_joinNode;
        }
        if (aERelationalExpr == null) {
            aEBooleanExpr.setIsOptimized(true);
            return false;
        }
        AETreeManipulator.pushDownFilter(this.m_passdownInfo, aEBooleanExpr, aERelationalExpr);
        return true;
    }

    private boolean pushDownFilter(AEBooleanExpr aEBooleanExpr, boolean bl) throws ErrorException {
        IAENode iAENode;
        if (aEBooleanExpr.isOptimized()) {
            return false;
        }
        if (this.childOfSearchedWhenClause(aEBooleanExpr)) {
            this.setFilterOptimized(aEBooleanExpr);
            return false;
        }
        IAENode iAENode2 = aEBooleanExpr.getParent();
        boolean bl2 = bl;
        if (!bl2 && iAENode2 instanceof AEJoin && ((AEJoin)(iAENode = (AEJoin)iAENode2)).isOuterJoin()) {
            bl2 = true;
        }
        switch (aEBooleanExpr.getType()) {
            case COMPARISON: 
            case LIKE_PRED: 
            case NULL_PRED: {
                return this.doPushDownFilter(aEBooleanExpr, bl2);
            }
            case NOT: {
                return this.pushDownNot((AENot)aEBooleanExpr, bl2);
            }
            case OR: {
                return this.pushDownOr((AEOr)aEBooleanExpr, bl2);
            }
            case AND: {
                return this.pushDownAnd((AEAnd)aEBooleanExpr, bl2);
            }
            case IN_PRED: {
                iAENode = (AEInPredicate)aEBooleanExpr;
                IAENode iAENode3 = ((AEInPredicate)iAENode).getRightOperand().getChildItr().next();
                if (iAENode3 instanceof AESubQuery || iAENode3 instanceof AEValueSubQuery) {
                    this.setFilterOptimized((AEBooleanExpr)iAENode);
                    this.doOptimize(iAENode3);
                    return true;
                }
                return this.doPushDownFilter((AEBooleanExpr)iAENode, bl);
            }
            case EXISTS_PRED: {
                iAENode = (AEExistsPredicate)aEBooleanExpr;
                this.setFilterOptimized((AEBooleanExpr)iAENode);
                this.doOptimize(((AEExistsPredicate)iAENode).getOperand());
                return true;
            }
            case QUANITIFIED_COMPARISON: {
                iAENode = (AEQuantifiedComparison)aEBooleanExpr;
                this.setFilterOptimized((AEBooleanExpr)iAENode);
                this.doOptimize(((AEQuantifiedComparison)iAENode).getRightOperand());
                return true;
            }
        }
        aEBooleanExpr.setIsOptimized(true);
        return false;
    }

    private boolean pushDownAnd(AEAnd aEAnd, boolean bl) throws ErrorException {
        AEBooleanExpr aEBooleanExpr = aEAnd.getLeftOperand();
        AEBooleanExpr aEBooleanExpr2 = aEAnd.getRightOperand();
        if (aEBooleanExpr.isOptimized() && aEBooleanExpr2.isOptimized()) {
            aEAnd.setIsOptimized(true);
            return false;
        }
        return (!aEBooleanExpr.isOptimized() && this.pushDownFilter(aEBooleanExpr, bl)) | (!aEBooleanExpr2.isOptimized() && this.pushDownFilter(aEBooleanExpr2, bl));
    }

    private boolean pushDownOr(AEOr aEOr, boolean bl) throws ErrorException {
        boolean bl2 = this.doPushDownFilter(aEOr, bl);
        this.setFilterOptimized(aEOr);
        return bl2;
    }

    private boolean pushDownNot(AENot aENot, boolean bl) throws ErrorException {
        boolean bl2 = this.doPushDownFilter(aENot, bl);
        this.setFilterOptimized(aENot);
        return bl2;
    }

    private boolean processJoin(final PushdownInfo pushdownInfo) throws ErrorException {
        AEJoin.AEJoinType aEJoinType;
        AEBinaryRelationalExpr aEBinaryRelationalExpr = pushdownInfo.m_joinNode;
        if (aEBinaryRelationalExpr instanceof AEJoin) {
            aEJoinType = ((AEJoin)aEBinaryRelationalExpr).getJoinType();
        } else {
            assert (aEBinaryRelationalExpr instanceof AECrossJoin);
            aEJoinType = AEJoin.AEJoinType.FULL_OUTER_JOIN;
        }
        if (AEJoin.AEJoinType.FULL_OUTER_JOIN == aEJoinType) {
            return false;
        }
        boolean bl = AEJoin.AEJoinType.INNER_JOIN == aEJoinType;
        boolean bl2 = AEJoin.AEJoinType.LEFT_OUTER_JOIN == aEJoinType;
        boolean bl3 = AEJoin.AEJoinType.RIGHT_OUTER_JOIN == aEJoinType;
        pushdownInfo.m_isInLeftSubTree = true;
        if (bl || !pushdownInfo.m_inOuterJoinCond && bl2 || pushdownInfo.m_inOuterJoinCond && bl3) {
            AETreeWalker.walk(aEBinaryRelationalExpr.getLeftOperand(), new AETreeWalker.Action<Void>(){

                @Override
                public void act(IAENode iAENode) throws ErrorException {
                    if (iAENode instanceof AENamedRelationalExpr) {
                        if (pushdownInfo.m_foundRelExprs.remove(iAENode)) {
                            pushdownInfo.m_foundRelExprInLeft = true;
                        }
                        if (iAENode instanceof AESubQuery) {
                            this.skipChildren();
                        }
                    }
                }
            });
        }
        if (pushdownInfo.m_foundRelExprs.isEmpty()) {
            return true;
        }
        pushdownInfo.m_isInLeftSubTree = false;
        if (bl || !pushdownInfo.m_inOuterJoinCond && bl3 || pushdownInfo.m_inOuterJoinCond && bl2) {
            AETreeWalker.walk(aEBinaryRelationalExpr.getRightOperand(), new AETreeWalker.Action<Void>(){

                @Override
                public void act(IAENode iAENode) throws ErrorException {
                    if (iAENode instanceof AENamedRelationalExpr) {
                        pushdownInfo.m_foundRelExprs.remove(iAENode);
                    }
                    if (iAENode instanceof AESubQuery) {
                        this.skipChildren();
                    }
                }
            });
        }
        return pushdownInfo.m_foundRelExprs.isEmpty();
    }

    private void clearOptimizationFlags(IAEStatement iAEStatement) throws ErrorException {
        AETreeWalker.walk(iAEStatement, new AETreeWalker.Action<Void>(){

            @Override
            public void act(IAENode iAENode) throws ErrorException {
                if (iAENode instanceof AEBooleanExpr) {
                    ((AEBooleanExpr)iAENode).setIsOptimized(false);
                }
            }
        });
    }

    private boolean convertOuterJoin(IAEStatement iAEStatement) throws ErrorException {
        if (iAEStatement instanceof AEQuery) {
            return this.convertOuterJoin(((AEQuery)iAEStatement).getOperand(), new HashSet<AERelationalExpr>());
        }
        if (iAEStatement instanceof AEInsert) {
            return this.convertOuterJoin(((AEInsert)iAEStatement).getRelationalExpr(), new HashSet<AERelationalExpr>());
        }
        return false;
    }

    private boolean convertOuterJoin(AERelationalExpr aERelationalExpr, Set<AERelationalExpr> set) throws ErrorException {
        if (aERelationalExpr instanceof AESelect) {
            return this.convertOuterJoinForSelectNode((AESelect)aERelationalExpr, set);
        }
        if (aERelationalExpr instanceof AEUnaryRelationalExpr) {
            return this.convertOuterJoin(((AEUnaryRelationalExpr)aERelationalExpr).getOperand(), set);
        }
        if (aERelationalExpr instanceof AEJoin) {
            return this.convertOuterJoinForJoinNode((AEJoin)aERelationalExpr, set);
        }
        if (aERelationalExpr instanceof AEBinaryRelationalExpr) {
            return this.convertOuterJoinBinary((AEBinaryRelationalExpr)aERelationalExpr, set);
        }
        if (aERelationalExpr instanceof AECommonTableExprScope) {
            return this.convertOuterJoin(((AECommonTableExprScope)aERelationalExpr).getRightOperand(), set);
        }
        return false;
    }

    private boolean convertOuterJoinBinary(AEBinaryRelationalExpr aEBinaryRelationalExpr, Set<AERelationalExpr> set) throws ErrorException {
        AEBinaryRelationalExpr aEBinaryRelationalExpr2 = aEBinaryRelationalExpr;
        HashSet<AERelationalExpr> hashSet = new HashSet<AERelationalExpr>(set);
        return this.convertOuterJoin(aEBinaryRelationalExpr2.getLeftOperand(), hashSet) | this.convertOuterJoin(aEBinaryRelationalExpr2.getRightOperand(), set);
    }

    private boolean convertOuterJoinForSelectNode(AESelect aESelect, Set<AERelationalExpr> set) throws ErrorException {
        AEBooleanExpr aEBooleanExpr = aESelect.getCondition();
        set.addAll(this.extractNullRejected(aEBooleanExpr));
        return this.convertOuterJoin(aESelect.getOperand(), set);
    }

    private boolean convertOuterJoinForJoinNode(AEJoin aEJoin, Set<AERelationalExpr> set) throws ErrorException {
        switch (aEJoin.getJoinType()) {
            case INNER_JOIN: {
                set.addAll(this.extractNullRejected(aEJoin.getJoinCondition()));
                return this.convertOuterJoinBinary(aEJoin, set);
            }
            case LEFT_OUTER_JOIN: {
                Object object;
                if (set.contains(aEJoin.getRightOperand()) && (object = this.convertJoinType(AEJoin.AEJoinType.INNER_JOIN, aEJoin)) != null) {
                    this.convertOuterJoinForJoinNode((AEJoin)object, set);
                    return true;
                }
                object = new HashSet<AERelationalExpr>(set);
                object.addAll(this.extractNullRejected(aEJoin.getJoinCondition()));
                return this.convertOuterJoin(aEJoin.getLeftOperand(), set) | this.convertOuterJoin(aEJoin.getRightOperand(), (Set<AERelationalExpr>)object);
            }
            case RIGHT_OUTER_JOIN: {
                Object object;
                if (set.contains(aEJoin.getLeftOperand()) && null != (object = this.convertJoinType(AEJoin.AEJoinType.INNER_JOIN, aEJoin))) {
                    this.convertOuterJoinForJoinNode((AEJoin)object, set);
                    return true;
                }
                object = new HashSet<AERelationalExpr>(set);
                object.addAll(this.extractNullRejected(aEJoin.getJoinCondition()));
                return this.convertOuterJoin(aEJoin.getLeftOperand(), (Set<AERelationalExpr>)object) | this.convertOuterJoin(aEJoin.getRightOperand(), set);
            }
            case FULL_OUTER_JOIN: {
                AEJoin aEJoin2;
                if (set.contains(aEJoin.getLeftOperand())) {
                    aEJoin2 = set.contains(aEJoin.getRightOperand()) ? this.convertJoinType(AEJoin.AEJoinType.INNER_JOIN, aEJoin) : this.convertJoinType(AEJoin.AEJoinType.LEFT_OUTER_JOIN, aEJoin);
                } else if (set.contains(aEJoin.getRightOperand())) {
                    aEJoin2 = this.convertJoinType(AEJoin.AEJoinType.RIGHT_OUTER_JOIN, aEJoin);
                } else {
                    return this.convertOuterJoinBinary(aEJoin, set);
                }
                this.convertOuterJoinForJoinNode(aEJoin2, set);
                return true;
            }
        }
        return false;
    }

    private AEJoin convertJoinType(AEJoin.AEJoinType aEJoinType, AEJoin aEJoin) throws ErrorException {
        switch (aEJoin.getJoinType()) {
            case LEFT_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: {
                if (AEJoin.AEJoinType.INNER_JOIN != aEJoinType) {
                    throw new IllegalArgumentException();
                }
            }
            case FULL_OUTER_JOIN: {
                AEJoin aEJoin2 = new AEJoin(aEJoinType, aEJoin.getLeftOperand(), aEJoin.getRightOperand(), aEJoin.getJoinCondition());
                AETreeManipulator.replaceRelExpr(aEJoin, aEJoin2);
                return aEJoin2;
            }
        }
        throw new IllegalArgumentException();
    }

    private void postProcess(IAEStatement iAEStatement) throws ErrorException {
        AETreeWalker aETreeWalker = new AETreeWalker(iAEStatement);
        while (aETreeWalker.hasNext()) {
            AERelationalExpr aERelationalExpr;
            IAENode iAENode = aETreeWalker.next();
            if (iAENode instanceof AEJoin) {
                aERelationalExpr = (AEJoin)iAENode;
                if (((AEJoin)aERelationalExpr).isOuterJoin() || !(((AEJoin)aERelationalExpr).getJoinCondition() instanceof AEBooleanTrue)) continue;
                AETreeManipulator.convertJoinToCrossJoin((AEJoin)aERelationalExpr);
                aETreeWalker = new AETreeWalker(iAEStatement);
                continue;
            }
            if (!(iAENode instanceof AESelect)) continue;
            aERelationalExpr = (AESelect)iAENode;
            if (((AESelect)aERelationalExpr).getCondition() instanceof AEBooleanTrue) {
                AETreeManipulator.removeSelect((AESelect)aERelationalExpr);
                aETreeWalker = new AETreeWalker(iAEStatement);
                continue;
            }
            if (!(((AEUnaryRelationalExpr)aERelationalExpr).getOperand() instanceof AECrossJoin)) continue;
            AETreeManipulator.convertCrossJoinToInnerJoin((AECrossJoin)((AEUnaryRelationalExpr)aERelationalExpr).getOperand(), (AESelect)aERelationalExpr);
            aETreeWalker = new AETreeWalker(iAEStatement);
        }
    }

    private boolean childOfSearchedWhenClause(AEBooleanExpr aEBooleanExpr) {
        IAENode iAENode = aEBooleanExpr.getParent();
        while (iAENode instanceof AEBooleanExpr) {
            iAENode = iAENode.getParent();
        }
        return iAENode instanceof AESearchedWhenClause;
    }

    private Set<AENamedRelationalExpr> extractRelationalExprs(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        final Set<AENamedRelationalExpr> set = Collections.newSetFromMap(new IdentityHashMap());
        AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){

            @Override
            public Void visit(AEColumnReference aEColumnReference) {
                set.add(aEColumnReference.getNamedRelationalExpr());
                return null;
            }

            @Override
            protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    iterator.next().acceptVisitor(this);
                }
                return null;
            }
        };
        aEBooleanExpr.acceptVisitor(aEDefaultVisitor);
        return set;
    }

    private Set<AERelationalExpr> extractNullRejected(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        return aEBooleanExpr.acceptVisitor(new NullRejectVisitor());
    }

    private void setFilterOptimized(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        AETreeWalker.walk(aEBooleanExpr, new AETreeWalker.Action<Void>(){

            @Override
            public void act(IAENode iAENode) throws ErrorException {
                if (iAENode instanceof AEBooleanExpr) {
                    ((AEBooleanExpr)iAENode).setIsOptimized(true);
                } else if (iAENode instanceof AESubQuery || iAENode instanceof AEValueSubQuery) {
                    this.skipChildren();
                }
            }
        });
    }

    private static class PushdownInfo {
        public AEBinaryRelationalExpr m_joinNode;
        public boolean m_foundRelExprInLeft;
        public boolean m_isInLeftSubTree;
        public boolean m_inOuterJoinCond;
        public final Set<AENamedRelationalExpr> m_foundRelExprs = Collections.newSetFromMap(new IdentityHashMap());

        public PushdownInfo(AEBinaryRelationalExpr aEBinaryRelationalExpr, Set<AENamedRelationalExpr> set, boolean bl) {
            this.m_joinNode = aEBinaryRelationalExpr;
            this.m_foundRelExprInLeft = false;
            this.m_isInLeftSubTree = true;
            this.m_foundRelExprs.addAll(set);
            this.m_inOuterJoinCond = bl;
        }
    }

    private class OptimizeAction
    extends AETreeWalker.Action<Boolean> {
        private boolean m_optimized = false;

        private OptimizeAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void act(IAENode iAENode) throws ErrorException {
            if (iAENode instanceof AESubQuery || iAENode instanceof AEValueSubQuery) {
                this.skipChildren();
                IAENode iAENode2 = AEFilterOptimizer.this.m_currentRoot;
                AEFilterOptimizer.this.m_currentRoot = iAENode;
                try {
                    IAEUnaryNode iAEUnaryNode = (IAEUnaryNode)((Object)iAENode);
                    AEFilterOptimizer.this.doOptimize(iAEUnaryNode.getOperand());
                }
                finally {
                    AEFilterOptimizer.this.m_currentRoot = iAENode2;
                }
            } else if (iAENode instanceof AEBooleanExpr) {
                AEBooleanExpr aEBooleanExpr = (AEBooleanExpr)iAENode;
                if (aEBooleanExpr.isOptimized() || aEBooleanExpr instanceof AEBooleanTrue) {
                    this.skipChildren();
                } else if (((Boolean)aEBooleanExpr.acceptVisitor(s_havingChecker)).booleanValue()) {
                    AEFilterOptimizer.this.setFilterOptimized(aEBooleanExpr);
                } else if (AEFilterOptimizer.this.pushDownFilter(aEBooleanExpr, false)) {
                    this.m_optimized = true;
                    this.skipAll();
                }
            }
        }

        @Override
        public Boolean getResult() {
            return this.m_optimized;
        }
    }
}

