/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine.metadata;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.core.utilities.DataAccessApiContext;
import com.databricks.client.dsi.core.utilities.OdbcContext;
import com.databricks.client.dsi.dataengine.filters.IFilter;
import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.DSITypeUtilities;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.databricks.client.dsi.dataengine.utilities.Nullable;
import com.databricks.client.dsi.dataengine.utilities.ParameterType;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.databricks.client.sqlengine.dsiext.dataengine.Identifier;
import com.databricks.client.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.databricks.client.sqlengine.dsiext.dataengine.StoredProcedure;
import com.databricks.client.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DSIExtProcedureColumnsMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private ILogger m_logger;
    private StoredProcedure m_curProcedure = null;
    private SqlDataEngine m_dataEngine;
    private ParamOrColumnIterator m_curRow;
    private boolean nextRowLoaded = false;

    @Deprecated
    public DSIExtProcedureColumnsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.PROCEDURE_NAME, sqlDataEngine.getIsODBC2());
        this.init(iLogger, map, sqlDataEngine);
    }

    public DSIExtProcedureColumnsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine, List<IFilter> list) {
        super(iMetadataHelper, MetadataSourceColumnTag.PROCEDURE_NAME, sqlDataEngine.getIsODBC2(), list);
        this.init(iLogger, map, sqlDataEngine);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_dataEngine = null;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curProcedure.getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curProcedure.getSchemaName(), dataWrapper, l, l2);
            }
            case PROCEDURE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curProcedure.getProcedureName(), dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getName(), dataWrapper, l, l2);
            }
            case PROCEDURE_COLUMN_TYPE: {
                dataWrapper.setSmallInt(this.m_curRow.getType());
                break;
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.m_curRow.getDataType());
                break;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getTypeName(), dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(Math.min(Integer.MAX_VALUE, TypeUtilities.getColumnSize(this.m_curRow.m_meta)));
                break;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setInteger(this.m_curRow.getBufferLength());
                break;
            }
            case DECIMAL_DIGITS: {
                dataWrapper.setSmallInt(this.m_curRow.getDecimalDigits());
                break;
            }
            case NUM_PREC_RADIX: {
                dataWrapper.setSmallInt(this.m_curRow.getNumPrecRadix());
                break;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_curRow.getNullable().ordinal());
                break;
            }
            case REMARKS: {
                dataWrapper.setVarChar(this.m_curRow.getRemarks());
                break;
            }
            case COLUMN_DEF: {
                dataWrapper.setVarChar(this.m_curRow.getColumnDef());
                break;
            }
            case SQL_DATA_TYPE: {
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(this.m_curRow.getSqlDataType()));
                break;
            }
            case SQL_DATETIME_SUB: {
                dataWrapper.setSmallInt(this.m_curRow.getSqlDateTimeSub());
                break;
            }
            case CHAR_OCTET_LENGTH: {
                Integer n = this.m_curRow.getCharOctetLength();
                if (n == null) {
                    dataWrapper.setNull(4);
                    break;
                }
                dataWrapper.setInteger(n.intValue());
                break;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_curRow.getOrdinal());
                break;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getNullable().isNullable(), dataWrapper, l, l2);
            }
            case IS_RESULT_SET: {
                dataWrapper.setSmallInt(this.m_curRow.m_isParam ? 0 : 1);
                break;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                break;
            }
            case SPECIFIC_NAME: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
            default: {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
            }
        }
        return false;
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.nextRowLoaded || this.m_curRow.moveToNext()) {
            this.nextRowLoaded = true;
            return true;
        }
        if (this.m_curRow.m_isParam) {
            List<? extends IColumn> list = this.m_curProcedure.getCurrentResultMetadata();
            this.m_curRow.fromColumns(list);
            return this.hasMoreRows();
        }
        Identifier identifier = super.getNextProcedureOrTable();
        if (null == identifier) {
            return false;
        }
        try {
            this.m_curProcedure = Objects.requireNonNull(this.m_dataEngine.openProcedure(identifier.getCatalog(), identifier.getSchema(), identifier.getName()), () -> String.format("%s.openProcedure(\"%s\", \"%s\", \"%s\") returned NULL, even though that Catalog/Schema/ProcedureName was returned from the metadata helper!", this.m_dataEngine.getClass().getName(), identifier.getCatalog(), identifier.getSchema(), identifier.getName()));
            List<? extends ProcedureParameterMetadata> list = this.m_curProcedure.getParameters();
            this.m_curRow.fromParams(list);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
        return this.hasMoreRows();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = this.nextRowLoaded;
        if (!bl) {
            bl = this.hasMoreRows();
        }
        this.nextRowLoaded = false;
        return bl;
    }

    private void init(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, SqlDataEngine sqlDataEngine) {
        this.m_logger = iLogger;
        this.m_dataEngine = sqlDataEngine;
        this.m_curRow = new ParamOrColumnIterator(map.get((Object)MetadataSourceColumnTag.COLUMN_NAME));
    }

    private long getMaxCodepointSize(TypeMetadata typeMetadata) {
        assert (typeMetadata.isCharacterType());
        DataAccessApiContext dataAccessApiContext = this.m_dataEngine.getParentStatement().getParentConnection().getDataAccessApiContext();
        if (DataAccessApiContext.Api.ODBC.equals((Object)dataAccessApiContext.GetApi())) {
            OdbcContext odbcContext = (OdbcContext)dataAccessApiContext;
            return DSIExtProcedureColumnsMetadataSource.isWideChar(typeMetadata) ? (long)odbcContext.getSqlCWCharMaxCodepointSize() : (long)odbcContext.getSqlCCharMaxCodepointSize();
        }
        return 4L;
    }

    private static boolean isWideChar(TypeMetadata typeMetadata) {
        switch (typeMetadata.getType()) {
            case -10: 
            case -9: 
            case -8: {
                return true;
            }
        }
        return false;
    }

    private final class ParamOrColumnIterator {
        private static final int SQL_NO_TOTAL = -3;
        boolean m_isParam = false;
        Iterator<?> m_iterator = null;
        IColumn m_col = null;
        ProcedureParameterMetadata m_param = null;
        TypeMetadata m_meta = null;
        int m_ordinal = -1;
        String m_filter;

        ParamOrColumnIterator(String string) {
            this.m_filter = string;
        }

        void fromColumns(List<? extends IColumn> list) {
            this.m_iterator = null == list ? null : list.iterator();
            this.m_isParam = false;
            this.m_ordinal = 0;
            this.m_param = null;
        }

        void fromParams(List<? extends ProcedureParameterMetadata> list) {
            this.m_iterator = null == list ? null : list.iterator();
            this.m_isParam = true;
            if (null != list && !list.isEmpty() && list.get(0).getParameterType() == ParameterType.RETURN_VALUE) {
                this.m_ordinal = -1;
            }
            this.m_ordinal = 0;
            this.m_col = null;
        }

        boolean moveToNext() {
            while (null != this.m_iterator && this.m_iterator.hasNext()) {
                if (this.m_isParam) {
                    this.m_param = (ProcedureParameterMetadata)this.m_iterator.next();
                    this.m_meta = this.m_param.getTypeMetadata();
                } else {
                    this.m_col = (IColumn)this.m_iterator.next();
                    this.m_meta = this.m_col.getTypeMetadata();
                }
                ++this.m_ordinal;
                if (null != this.m_filter && !this.m_filter.equals(this.getName())) continue;
                return true;
            }
            this.m_iterator = null;
            this.m_col = null;
            this.m_param = null;
            this.m_meta = null;
            return false;
        }

        String getName() {
            return this.m_isParam ? this.m_param.getName() : this.m_col.getName();
        }

        short getType() {
            return this.m_isParam ? (short)this.m_param.getParameterType().getIntValue() : (short)3;
        }

        int getDataType() {
            return this.m_meta.getType();
        }

        String getTypeName() {
            return this.m_meta.getTypeName();
        }

        long getLength() {
            return this.m_isParam ? this.m_param.getColumnLength() : this.m_col.getColumnLength();
        }

        int getBufferLength() {
            if (this.m_meta.isCharacterType()) {
                return this.computeBufferSize(this.getLength(), DSIExtProcedureColumnsMetadataSource.this.getMaxCodepointSize(this.m_meta));
            }
            if (this.m_meta.isBinaryType()) {
                return this.computeBufferSize(this.getLength(), 1L);
            }
            return TypeUtilities.getSizeInBytes(this.m_meta.getType());
        }

        Integer getDecimalDigits() {
            int n = -1;
            if (this.m_meta.isIntervalType() || 92 == this.m_meta.getType() || 93 == this.m_meta.getType()) {
                n = this.m_meta.getPrecision();
            } else if (this.m_meta.isExactNumericType()) {
                n = this.m_meta.getScale();
            } else if (this.m_meta.isIntegerType()) {
                n = 0;
            }
            return n < 0 ? null : Integer.valueOf(n);
        }

        Integer getNumPrecRadix() {
            int n = -1;
            if (this.m_meta.isIntegerType() || this.m_meta.isExactNumericType()) {
                n = 10;
            } else if (this.m_meta.isApproximateNumericType()) {
                n = 2;
            }
            return n < 0 ? null : Integer.valueOf(n);
        }

        Nullable getNullable() {
            return this.m_isParam ? this.m_param.getNullable() : this.m_col.getNullable();
        }

        String getRemarks() {
            return null;
        }

        String getColumnDef() {
            return null;
        }

        int getSqlDataType() {
            return this.getDataType();
        }

        Integer getSqlDateTimeSub() {
            short s = TypeUtilities.getIntervalCodeFromConciseType(this.getDataType());
            return s == 0 ? null : Integer.valueOf(s);
        }

        Integer getCharOctetLength() {
            if (this.m_meta.isCharacterType()) {
                return this.computeBufferSize(this.getLength(), 2L);
            }
            if (this.m_meta.isBinaryType()) {
                return this.computeBufferSize(this.getLength(), 1L);
            }
            return null;
        }

        int getOrdinal() {
            return this.m_ordinal;
        }

        private int computeBufferSize(long l, long l2) {
            assert (l >= 0L);
            assert (l2 > 0L);
            if (l2 == 0L || Integer.MAX_VALUE / l2 < l) {
                return -3;
            }
            return (int)(l * l2);
        }
    }
}

