/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree;

import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.etree.IETResource;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public final class ETTempFolderResource
implements IETResource {
    private final Path m_folder;
    private final ILogger m_logger;

    public ETTempFolderResource(File file, ILogger iLogger) {
        this.m_folder = file.toPath().resolve(UUID.randomUUID().toString());
        this.m_logger = iLogger;
    }

    @Override
    public void allocate() throws ErrorException {
        try {
            Files.createDirectories(this.m_folder, new FileAttribute[0]);
            try {
                this.m_folder.toFile().deleteOnExit();
            }
            catch (Exception exception) {
                Files.delete(this.m_folder);
                throw exception;
            }
        }
        catch (Exception exception) {
            throw SQLEngineExceptionFactory.failedToCreateFile(this.getPathStr(), exception.getLocalizedMessage());
        }
        if (!Files.isReadable(this.m_folder)) {
            throw SQLEngineExceptionFactory.failedToCreateFile(this.getPathStr(), "Directory not readable.");
        }
        if (!Files.isWritable(this.m_folder)) {
            throw SQLEngineExceptionFactory.failedToCreateFile(this.getPathStr(), "Directory not writable.");
        }
    }

    @Override
    public void free() throws ErrorException {
        try {
            this.deleteDirectoryRecursively();
        }
        catch (Exception exception) {
            if (this.m_logger != null) {
                LogUtilities.logError(exception, this.m_logger);
            }
            throw SQLEngineExceptionFactory.failedToDeleteFile(this.m_folder.toString());
        }
    }

    private String getPathStr() {
        return this.m_folder.toAbsolutePath().toString();
    }

    private void deleteDirectoryRecursively() throws IOException {
        Files.walkFileTree(this.m_folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            boolean hasFoundFile = false;

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (path.equals(ETTempFolderResource.this.m_folder)) {
                    throw new RuntimeException(String.format("Expected \"%s\" to be a directory, was a file!", ETTempFolderResource.this.getPathStr()));
                }
                if (!this.hasFoundFile) {
                    if (ETTempFolderResource.this.m_logger != null) {
                        LogUtilities.logWarning("Temporary files are not cleaned up after execution.", ETTempFolderResource.this.m_logger);
                    }
                    this.hasFoundFile = true;
                }
                assert (false);
                Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (!path.equals(ETTempFolderResource.this.m_folder)) {
                    throw new RuntimeException(String.format("Unexpected directory \"%s\" found under temp file directory \"%s\"", path.getFileName(), ETTempFolderResource.this.getPathStr()));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                if (iOException != null) {
                    throw iOException;
                }
                Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

