/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.SEDefines;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigInteger;

public abstract class AbstractBigIntBinArithFunctor
implements IBinaryArithmeticFunctor {
    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        BigInteger bigInteger;
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        BigInteger bigInteger2 = iSqlDataWrapper.getBigInt();
        BigInteger bigInteger3 = this.calculate(bigInteger2, bigInteger = iSqlDataWrapper2.getBigInt());
        if (!this.checkRange(bigInteger3)) {
            throw SQLEngineExceptionFactory.numArithOverflowException();
        }
        eTDataRequest.getData().setBigInt(bigInteger3);
        return false;
    }

    protected abstract BigInteger calculate(BigInteger var1, BigInteger var2) throws ErrorException;

    private boolean checkRange(BigInteger bigInteger) {
        return SEDefines.SQL_BIGINT_MIN.compareTo(bigInteger) <= 0 && bigInteger.compareTo(SEDefines.SQL_BIGINT_MAX) <= 0;
    }
}

