/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;

public abstract class AbstractRealBinArithFunctor
implements IBinaryArithmeticFunctor {
    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        float f;
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        float f2 = iSqlDataWrapper.getReal();
        float f3 = this.calculate(f2, f = iSqlDataWrapper2.getReal());
        if (Float.isNaN(f3)) {
            if (!Float.isNaN(f2) && !Float.isNaN(f)) {
                throw SQLEngineExceptionFactory.notANumberValue();
            }
        } else if (!(Float.isInfinite(f2) || Float.isInfinite(f) || this.checkRange(f3))) {
            throw SQLEngineExceptionFactory.numArithOverflowException();
        }
        eTDataRequest.getData().setReal(f3);
        return false;
    }

    protected abstract float calculate(float var1, float var2) throws ErrorException;

    private boolean checkRange(float f) {
        return -3.4028234663852886E38 <= (double)f && (double)f <= 3.4028234663852886E38;
    }
}

