/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.executor.conversions.ConversionUtil;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.DateTimeFunctorUtil;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.conv.ConversionResult;
import com.databricks.client.support.conv.DateTimeConverter;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Timestamp;

public class TimestampMinusIntFunctor
implements IBinaryArithmeticFunctor {
    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        Timestamp timestamp = null;
        long l = 0L;
        if (iSqlDataWrapper.getType() == 93) {
            timestamp = iSqlDataWrapper.getTimestamp();
            l = iSqlDataWrapper2.getInteger();
        } else {
            timestamp = iSqlDataWrapper2.getTimestamp();
            l = iSqlDataWrapper.getInteger();
        }
        timestamp = DateTimeFunctorUtil.timestampPlusNum(timestamp, -l);
        ConversionResult conversionResult = new ConversionResult();
        timestamp = DateTimeConverter.toTimestamp(timestamp, conversionResult, eTDataRequest.getColumn().getTypeMetadata().getPrecision());
        ConversionUtil.checkResult(conversionResult, iWarningListener, -1, -1);
        eTDataRequest.getData().setTimestamp(timestamp);
        return false;
    }
}

