/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.databricks.client.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.future.UnsupportedException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;

public abstract class LocalDateTimeJDBCDataSource
extends ConvertingJDBCDataSource {
    private final int m_fracSecPrec;

    public LocalDateTimeJDBCDataSource(IWarningListener iWarningListener, TypeMetadata typeMetadata, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
        this.m_fracSecPrec = typeMetadata.getPrecision();
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fracSecPrec;
    }

    protected abstract LocalDateTime getLocalDateTime() throws ErrorException;

    @Override
    public Timestamp get() throws ErrorException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        return localDateTime == null ? null : NonTrivialJDBCConversions.localDateTimeToTimestamp(localDateTime);
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        return NonTrivialJDBCConversions.localDateTimeToString(localDateTime, this.getFractionalSecondsPrecision());
    }

    @Override
    public Date getDate(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        if (calendar != null) {
            localDateTime = ZonedDateTime.of(localDateTime, calendar.getTimeZone().toZoneId()).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        LocalDate localDate = NonTrivialJDBCConversions.localDateTimeToLocalDate(localDateTime, this.getAndClearListener());
        if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
            this.onFractionalTruncation(localDateTime, 0, "getTime");
        }
        return NonTrivialJDBCConversions.localDateToSqlDate(localDate);
    }

    @Override
    public Time getTime(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        if (calendar != null) {
            localDateTime = ZonedDateTime.of(localDateTime, calendar.getTimeZone().toZoneId()).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        Time time = NonTrivialJDBCConversions.localTimeToSqlTime(localDateTime.toLocalTime(), this.getAndClearListener());
        if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
            this.onFractionalTruncation(localDateTime, 3, "getTime");
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        if (calendar != null) {
            localDateTime = ZonedDateTime.of(localDateTime, calendar.getTimeZone().toZoneId()).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        return NonTrivialJDBCConversions.localDateTimeToTimestamp(localDateTime);
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 91: 
            case 92: 
            case 93: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }

    @Override
    public <T> T getObject(Class<T> clazz) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        if (LocalDateTime.class.equals(clazz)) {
            return clazz.cast(this.getLocalDateTime());
        }
        if (LocalDate.class.equals(clazz)) {
            LocalDateTime localDateTime = this.getLocalDateTime();
            if (localDateTime == null) {
                return null;
            }
            LocalDate localDate = NonTrivialJDBCConversions.localDateTimeToLocalDate(localDateTime, this.getAndClearListener());
            if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
                this.onFractionalTruncation(localDateTime, 0, "getObject");
            }
            return clazz.cast(localDate);
        }
        if (LocalTime.class.equals(clazz)) {
            LocalDateTime localDateTime = this.getLocalDateTime();
            return clazz.cast(localDateTime == null ? null : localDateTime.toLocalTime());
        }
        return super.getObject(clazz);
    }
}

