/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.core;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.dsi.core.interfaces.IEnvironment;
import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.dsi.core.utilities.ClientInfoData;
import com.databricks.client.dsi.core.utilities.ConnSettingRequestMap;
import com.databricks.client.dsi.core.utilities.ConnSettingResponseMap;
import com.databricks.client.dsi.core.utilities.Variant;
import com.databricks.client.dsi.exceptions.BadAuthException;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.hivecommon.AuthMech;
import com.databricks.client.hivecommon.BrandingPreferences;
import com.databricks.client.hivecommon.HiveJDBCCasePreservingAlias;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.HiveServerType;
import com.databricks.client.hivecommon.IServerVersion;
import com.databricks.client.hivecommon.KrbAuthType;
import com.databricks.client.hivecommon.ServiceDiscoveryMode;
import com.databricks.client.hivecommon.TransportMode;
import com.databricks.client.hivecommon.api.HS2Client;
import com.databricks.client.hivecommon.api.IHiveClient;
import com.databricks.client.hivecommon.api.IHiveClientFactory;
import com.databricks.client.hivecommon.api.SSOSettings;
import com.databricks.client.hivecommon.api.TEHTTPSettings;
import com.databricks.client.hivecommon.api.ZookeeperSettings;
import com.databricks.client.hivecommon.core.HiveJDBCCommonConnectionLogger;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.core.HiveJDBCStatement;
import com.databricks.client.hivecommon.core.ThreadPoolExecutorExt;
import com.databricks.client.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.hivecommon.utils.HiveCommonConnectionUtils;
import com.databricks.client.hivecommon.utils.HiveCommonGSSCredentialMap;
import com.databricks.client.hivecommon.utils.HiveCommonQueryTranslationUtils;
import com.databricks.client.jdbc.common.CommonCoreUtils;
import com.databricks.client.jdbc.common.CommonTestProperty;
import com.databricks.client.jdbc.common.CustomNetworkHooksSettings;
import com.databricks.client.jdbc.common.OAuthFlow;
import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.common.ProductInfoHandler;
import com.databricks.client.jdbc.common.ProxySettings;
import com.databricks.client.jdbc.common.SSLSettings;
import com.databricks.client.jdbc.core.DSConnectionUtils;
import com.databricks.client.jdbc.core.LoginTimeoutConnection;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.OAuthUtil;
import com.databricks.client.jdbc.utils.ParseQueryUtils;
import com.databricks.client.jdbc.utils.StringUtils;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogLevel;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.Warning;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.ClientInfoException;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class HiveJDBCCommonConnection
extends LoginTimeoutConnection {
    private static final String MASKED_FIELD_VAL = "****";
    private static final String NO_PROP_KEY_PREFIX = "";
    private static final int LOG_INDEX_LOWER_LIMIT = -1;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final String AOSS_PREFIX = "AOSS_";
    private static final long DEFAULT_ARROW_FETCH_MAX_BYTES = 300000000L;
    private static final long MIN_ARROW_FETCH_MAX_BYTES = 5000000L;
    private static final int JDK_8_MAJOR_VER = 8;
    private static final int DEFAULT_HEART_BEAT_INTERVAL = 30000;
    private static final int CONN_SETTING_WAS_READ_IDX = 0;
    private static final int CONN_SETTING_VALUE_IDX = 1;
    private static final String JWT_AUTH_HEADER_KEY = "Authorization";
    private static final String JWT_AUTH_HEADER_VALUE_PREFIX = "Bearer ";
    private static final String DATABRICKS_SUBPROTOCAL_NAME = "databricks";
    public static final String SPARK_SUBPROTOCAL_NAME = "spark";
    private static final int DEFAULT_OAUTH2_TIME_OUT = 60;
    private static final String DEFAULT_HTTP_CODE_FOR_UCINGESTION_RETRY = "408,502,503,504";
    private static final String DEFAULT_HTTP_CODE_FOR_OAUTH_RETRY = "408,502,503,504";
    private static final String UNSUPPORTED_OPERATION = "Unsupported connection property";
    private static final String PAT_USER_NAME = "token";
    private static final String APPLICATION_NAME = "ApplicationName";
    protected static int s_connectionID = 0;
    protected static Object s_loggerLock = new Object();
    protected HiveJDBCCommonConnectionLogger m_log;
    protected HiveJDBCSettings m_settings;
    protected IHiveClient m_hiveClient;
    private ExecutorService m_threadPool;
    private ConnSettingRequestMap m_requestMap;
    private boolean m_authMechSpecifiedByUser = false;
    private boolean m_transportModeSpecifiedByUser = false;
    private boolean m_useSasl = true;
    protected Map<String, Boolean> m_definedSettings = new TreeMap<String, Boolean>(String.CASE_INSENSITIVE_ORDER);
    protected IHiveClientFactory m_factory;

    protected HiveJDBCCommonConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        this.setDefaultProperties();
        this.m_threadPool = new ThreadPoolExecutorExt(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.m_factory = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getClientFactory();
    }

    public void cancelDelegationToken(String string) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                ((HS2Client)this.m_hiveClient).cancelDelegationToken(string);
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getMessage(), string});
                errorException.initCause(exception);
                throw errorException;
            }
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "cancelDelegationToken");
            throw errorException;
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_threadPool.shutdown();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new HiveJDBCStatement(this, this.m_requestMap);
    }

    @Override
    public void disconnect() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_hiveClient) {
            this.m_hiveClient.disconnect();
        }
    }

    @Override
    public void establishConnection(ConnSettingRequestMap connSettingRequestMap, int n) throws ErrorException, BadAuthException {
        Object object;
        Object exception;
        Variant variant;
        Variant variant2;
        block192: {
            block191: {
                block190: {
                    block189: {
                        block188: {
                            block187: {
                                block186: {
                                    block185: {
                                        block184: {
                                            block183: {
                                                block182: {
                                                    block181: {
                                                        block180: {
                                                            connSettingRequestMap.setHiddenKey("AOSS_PWD", "Auth_AccessToken", "Auth_RefreshToken", "JWTString", "OAuth2Secret");
                                                            CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, 2, 7, 5, HiveJDBCCommonDriver.DRIVER_BUILD_NUMBER);
                                                            this.m_requestMap = connSettingRequestMap;
                                                            this.m_settings = new HiveJDBCSettings();
                                                            this.m_log.RegisterSettings(this.m_settings);
                                                            this.m_settings.m_thriftHTTPSettings = new TEHTTPSettings();
                                                            this.m_settings.m_zookeeperSettings = new ZookeeperSettings();
                                                            this.m_settings.m_ssoSettings = new SSOSettings();
                                                            this.m_settings.m_enableArrow = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).supportsArrowSerialization();
                                                            this.m_settings.m_arrowMaxBytesPerFetch = 0L;
                                                            this.m_settings.m_arrowTimestampAsString = true;
                                                            this.m_settings.m_nonRowcountQueryPrefixes = new ArrayList<String>();
                                                            this.setImplementationDefaultSettings();
                                                            this.m_definedSettings.put("SuppressWarningsAsDebugLog", true);
                                                            this.m_settings.m_suppressWarningsAsDebugLog = this.readOptionalBooleanSetting(connSettingRequestMap, "SuppressWarningsAsDebugLog", this.m_settings.m_suppressWarningsAsDebugLog, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                                            int n2 = this.readOptionalIntegerSetting(connSettingRequestMap, "ErrMsgAndLogQueryRedactIndex", this.m_settings.m_errMsgAndLogQueryRedactIndex);
                                                            if (n2 >= -1) {
                                                                this.m_settings.m_errMsgAndLogQueryRedactIndex = n2;
                                                            }
                                                            this.m_settings.m_enableCloudFetchUrlLogging = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableCloudFetchUrlLogging", this.m_settings.m_enableCloudFetchUrlLogging, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                                            this.m_settings.m_enableCloudFetchErrorTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableCloudFetchErrorTesting", this.m_settings.m_enableCloudFetchErrorTesting, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                                            if (this.m_settings.m_enableCloudFetchErrorTesting.booleanValue()) {
                                                                LogUtilities.logWarning("EnableCloudFetchErrorTesting is enabled. This should only be turned onfor testing purposes.", (ILogger)this.m_log);
                                                            }
                                                            this.m_definedSettings.put("EnablePKFK", true);
                                                            this.m_settings.m_enablePKFK = this.readOptionalBooleanSetting(connSettingRequestMap, "EnablePKFK", this.m_settings.m_enablePKFK, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                                            this.m_definedSettings.put("PkFkApiNotSupportedTest", true);
                                                            this.m_settings.m_pkfkApiNotSupportedTest = this.readOptionalBooleanSetting(connSettingRequestMap, "PkFkApiNotSupportedTest", this.m_settings.m_pkfkApiNotSupportedTest, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                                            this.m_definedSettings.put("AsyncExecPkFk", true);
                                                            this.m_settings.m_AsyncExecPKFk = this.readOptionalBooleanSetting(connSettingRequestMap, "AsyncExecPkFk", this.m_settings.m_AsyncExecPKFk, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("EnableErrorEmulation", true);
                                                            this.m_settings.m_enableErrorEmulation = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableErrorEmulation", this.m_settings.m_enableErrorEmulation, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("EmulateServerProtocolVersion", true);
                                                            this.m_settings.m_emulateServerProtocolVersion = this.readOptionalIntegerSetting(connSettingRequestMap, "EmulateServerProtocolVersion", this.m_settings.m_emulateServerProtocolVersion);
                                                            this.m_definedSettings.put("EnableTestGetOperationStatusOnAsyncPKFK", true);
                                                            this.m_settings.m_enableTestGetOperationStatusOnRunAsyncPkFk = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableTestGetOperationStatusOnAsyncPKFK", this.m_settings.m_enableTestGetOperationStatusOnRunAsyncPkFk, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("EnableTestSetAsyncPkFk", true);
                                                            this.m_settings.m_enableTestSetAsyncPkFk = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableTestSetAsyncPkFk", this.m_settings.m_enableTestSetAsyncPkFk, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("EnableTestGetDirectResultsPkFk", true);
                                                            this.m_settings.m_enableTestGetDirectResultsPkFk = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableTestGetDirectResultsPkFk", this.m_settings.m_enableTestGetDirectResultsPkFk, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("QueryIDLimit", true);
                                                            this.m_settings.m_queryIDLimit = this.readOptionalIntegerSetting(connSettingRequestMap, "QueryIDLimit", this.m_settings.m_queryIDLimit);
                                                            this.m_definedSettings.put("EnableThrowUnsupportedRestrictionExceptionPkFk", true);
                                                            this.m_settings.m_enableThrowUnsupportedRestrictionexceptionPkFk = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableThrowUnsupportedRestrictionExceptionPkFk", this.m_settings.m_enableThrowUnsupportedRestrictionexceptionPkFk, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("EnableTestOverrideAuthorizationUrl", true);
                                                            this.m_settings.m_enableTestOverrideAuthorizationUrl = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableTestOverrideAuthorizationUrl", this.m_settings.m_enableTestOverrideAuthorizationUrl, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("CommonTestProperty", true);
                                                            variant2 = connSettingRequestMap.getProperty("CommonTestProperty");
                                                            if (variant2 != null) {
                                                                this.m_settings.m_commonTestProperty = CommonTestProperty.convertToTestConnectionProperty(variant2, this.getWarningListener());
                                                            }
                                                            this.m_definedSettings.put("EnableTestGetOperationHandleCountHeartBeatThread", true);
                                                            this.m_settings.m_enableTestGetOperationHandleCountHeartBeatThread = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableTestGetOperationHandleCountHeartBeatThread", this.m_settings.m_enableTestGetOperationHandleCountHeartBeatThread, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            if (this.m_settings.m_enableTestGetOperationHandleCountHeartBeatThread.booleanValue()) {
                                                                LogUtilities.logWarning("m_enableTestGetOperationHandleCountHeartBeatThread is enabled. This should only be turned onfor testing purposes.", (ILogger)this.m_log);
                                                            }
                                                            this.m_definedSettings.put("TestConfigExclusionFromSSP", true);
                                                            this.m_settings.m_testConfigExclusionFromSSP = this.readOptionalStringSetting(connSettingRequestMap, "TestConfigExclusionFromSSP", this.m_settings.m_testConfigExclusionFromSSP);
                                                            if (!this.m_settings.m_testConfigExclusionFromSSP.isEmpty()) {
                                                                LogUtilities.logWarning("TestConfigExclusionFromSSP is enabled. This should only be turned onfor testing purposes.", (ILogger)this.m_log);
                                                            }
                                                            this.m_definedSettings.put("EnableAdditionalHttpHeadersForCloudFetch", true);
                                                            this.m_settings.m_enableAdditionalHttpHeadersForCloudFetch = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableAdditionalHttpHeadersForCloudFetch", this.m_settings.m_enableAdditionalHttpHeadersForCloudFetch, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("EnableAsyncModeForMetadataOperation", true);
                                                            this.m_settings.m_enableAsyncModeForMetadataOperation = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableAsyncModeForMetadataOperation", this.m_settings.m_enableAsyncModeForMetadataOperation, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.m_definedSettings.put("EnableNativeParameterizedQuery", true);
                                                            this.m_settings.m_enableNativeParameterizedQuery = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableNativeParameterizedQuery", this.m_settings.m_enableNativeParameterizedQuery, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                            this.setSupportedHttpRetryType();
                                                            this.m_definedSettings.put("Host", true);
                                                            this.m_settings.m_connDBType = this.getRequiredSetting("DatabaseType", connSettingRequestMap).getString();
                                                            this.m_definedSettings.put("DatabaseType", true);
                                                            this.m_settings.m_port = 443;
                                                            this.m_settings.m_isConnAlive = false;
                                                            this.m_settings.m_timeout = 0;
                                                            this.m_settings.m_rowsFetchedPerBlock = 10000;
                                                            this.m_settings.m_stringColumnSize = (short)255;
                                                            this.m_settings.m_binaryColumnSize = Short.MAX_VALUE;
                                                            this.m_settings.m_asyncExecPollInterval = 1;
                                                            this.m_settings.m_authMech = BrandingPreferences.defaultAuthMech;
                                                            this.m_settings.m_useNativeQuery = false;
                                                            this.m_settings.m_decimalColumnScale = (short)10;
                                                            this.m_settings.m_switchCataANDSchema = BrandingPreferences.defaultCatalogSchemaSwitch;
                                                            this.m_settings.m_preparedStmtGetMetadataLimitZero = false;
                                                            this.m_settings.m_columnNameAliaseCase = HiveJDBCCasePreservingAlias.SERVER_DETERMINED;
                                                            this.m_settings.m_pushdownCatalogFunctionFilters = true;
                                                            this.validateLicenseFile();
                                                            this.m_settings.m_optimizedInsert = false;
                                                            this.m_definedSettings.put("OptimizedInsert", true);
                                                            this.m_settings.m_stripCatalogName = true;
                                                            this.m_settings.m_supportTimeOnlyTimestamp = false;
                                                            this.m_settings.m_upperCaseResultSetColName = false;
                                                            this.m_settings.m_automaticColumnRename = false;
                                                            this.m_settings.m_tableNameColIndex = 0;
                                                            this.m_settings.m_isTemporaryColIndex = 1;
                                                            this.m_settings.m_fetchEndWaitTime = 5L;
                                                            this.m_settings.m_protocolVersion = TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1;
                                                            this.m_settings.m_nonSSPs = new ArrayList<String>();
                                                            this.m_settings.m_nonSSPs.add("driver");
                                                            this.m_settings.m_nonSSPs.add("url");
                                                            this.m_settings.m_nonSSPPrefixes = new ArrayList<String>();
                                                            this.m_settings.m_nonSSPPrefixes.add("http.header.");
                                                            this.m_settings.m_setFetchSizeTakesPrecedence = true;
                                                            this.m_settings.m_enableSetFetchSizeTesting = false;
                                                            this.m_settings.m_expectedFetchSize = 0;
                                                            this.readDriverSpecificSettings(connSettingRequestMap);
                                                            this.m_definedSettings.put("NonRowcountQueryPrefixes", true);
                                                            Variant variant3 = this.getOptionalSetting("NonRowcountQueryPrefixes", connSettingRequestMap);
                                                            if (null != variant3) {
                                                                this.parseNonRowcountQueryPrefixes(variant3.getString());
                                                            } else {
                                                                this.parseNonRowcountQueryPrefixes(BrandingPreferences.defaultNonRowcountQueryPrefixes);
                                                            }
                                                            this.m_definedSettings.put("IdleHttpConnectionExpiry", true);
                                                            Variant variant4 = this.getOptionalSetting("IdleHttpConnectionExpiry", connSettingRequestMap);
                                                            if (null != variant4) {
                                                                try {
                                                                    if (variant4.getInt() >= 0) {
                                                                        this.m_settings.m_idleHttpConnectionExpiry = variant4.getInt();
                                                                    } else if (null != this.getWarningListener()) {
                                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant4.getString(), "IdleHttpConnectionExpiry"}));
                                                                    }
                                                                }
                                                                catch (Exception exception2) {
                                                                    if (null == this.getWarningListener()) break block180;
                                                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant4.getString(), "IdleHttpConnectionExpiry"}));
                                                                }
                                                            }
                                                        }
                                                        this.m_definedSettings.put("EnableIdleHttpConnectionExpiry", true);
                                                        this.m_settings.m_enableIdleHttpConnectionExpiry = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableIdleHttpConnectionExpiry", true, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                        this.m_definedSettings.put("AuthSuccessBrowserAutoCloseWaitTimeMs", true);
                                                        Variant variant5 = this.getOptionalSetting("AuthSuccessBrowserAutoCloseWaitTimeMs", connSettingRequestMap);
                                                        if (null != variant5) {
                                                            try {
                                                                if (variant5.getInt() >= 0) {
                                                                    this.m_settings.m_ssoSettings.m_browserCloseWaitTime = variant5.getInt();
                                                                } else if (null != this.getWarningListener()) {
                                                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant5.getString(), "AuthSuccessBrowserAutoCloseWaitTimeMs"}));
                                                                }
                                                            }
                                                            catch (Exception exception3) {
                                                                if (null == this.getWarningListener()) break block181;
                                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant5.getString(), "AuthSuccessBrowserAutoCloseWaitTimeMs"}));
                                                            }
                                                        }
                                                    }
                                                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion("AUTO", this.m_log);
                                                    variant2 = this.getOptionalSetting("ServerVersion", connSettingRequestMap);
                                                    this.m_definedSettings.put("ServerVersion", true);
                                                    if (variant2 != null) {
                                                        try {
                                                            IServerVersion iServerVersion;
                                                            this.m_settings.m_strServerVersion = variant2.getString();
                                                            this.m_settings.m_serverVersion = iServerVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(variant2.getString(), this.m_log);
                                                            this.m_settings.m_serverVersionSetByUser = true;
                                                        }
                                                        catch (Exception exception4) {
                                                            if (null == this.getWarningListener()) break block182;
                                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant2.getString(), "ServerVersion"}));
                                                        }
                                                    }
                                                }
                                                this.m_definedSettings.put("PassMaxProtocolVerInOpenSessionReq", true);
                                                this.m_settings.m_isPassMaxProtocolVerInOpenSessionReq = this.readOptionalBooleanSetting(connSettingRequestMap, "PassMaxProtocolVerInOpenSessionReq", true, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                                this.m_settings.m_fastConnect = false;
                                                variant2 = this.getOptionalSetting("FastConnection", connSettingRequestMap);
                                                this.m_definedSettings.put("FastConnection", true);
                                                if (variant2 != null) {
                                                    try {
                                                        boolean bl;
                                                        this.m_settings.m_fastConnect = bl = variant2.getInt() == 1;
                                                    }
                                                    catch (Exception exception5) {
                                                        if (null == this.getWarningListener()) break block183;
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant2.getString(), "FastConnection", "0, 1"}));
                                                    }
                                                }
                                            }
                                            variant2 = this.getOptionalSetting("transportMode", connSettingRequestMap);
                                            this.m_definedSettings.put("transportMode", true);
                                            if (variant2 != null) {
                                                try {
                                                    String string = variant2.getString();
                                                    this.m_transportModeSpecifiedByUser = true;
                                                    if (string.equalsIgnoreCase("http")) {
                                                        this.m_settings.m_transportMode = TransportMode.HTTP;
                                                    } else if (string.equalsIgnoreCase("binary")) {
                                                        this.m_settings.m_transportMode = TransportMode.BINARY;
                                                    } else if (string.equalsIgnoreCase("sasl")) {
                                                        this.m_settings.m_transportMode = TransportMode.SASL;
                                                    } else {
                                                        this.m_settings.m_transportMode = TransportMode.SASL;
                                                        this.m_transportModeSpecifiedByUser = false;
                                                        if (null != this.getWarningListener()) {
                                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_TRANSPORT_MODE_ERROR.name(), new String[]{variant2.getString()}));
                                                        }
                                                    }
                                                    break block184;
                                                }
                                                catch (Exception exception6) {
                                                    this.m_settings.m_transportMode = this.m_settings.m_transportMode = TransportMode.SASL;
                                                    this.m_transportModeSpecifiedByUser = false;
                                                    if (null != this.getWarningListener()) {
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_TRANSPORT_MODE_ERROR.name(), new String[]{variant2.getString()}));
                                                    }
                                                    break block184;
                                                }
                                            }
                                            this.m_settings.m_transportMode = BrandingPreferences.defaultTransportMode;
                                        }
                                        if (TransportMode.HTTP == this.m_settings.m_transportMode) {
                                            variant2 = this.getOptionalSetting("httpPath", connSettingRequestMap);
                                            this.m_definedSettings.put("httpPath", true);
                                            if (variant2 != null) {
                                                this.m_settings.m_httpPath = variant2.getString();
                                            }
                                            variant2 = this.getOptionalSetting("UseLegacyUserAgent", connSettingRequestMap);
                                            this.m_definedSettings.put("UseLegacyUserAgent", true);
                                            if (variant2 != null) {
                                                this.m_settings.m_thriftHTTPSettings.setLegacyUserAgent();
                                            } else {
                                                variant2 = this.getOptionalSetting("UserAgentEntry", connSettingRequestMap);
                                                this.m_definedSettings.put("UserAgentEntry", true);
                                                if (null != variant2) {
                                                    this.m_settings.m_userAgentEntryProperty = variant2.getString();
                                                    this.m_settings.m_thriftHTTPSettings.setUserAgentEntry(variant2);
                                                }
                                            }
                                            this.m_settings.m_thriftHTTPSettings.m_enableSessionTag = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableThriftSessionTag", this.m_settings.m_thriftHTTPSettings.m_enableSessionTag, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                            this.setCustomHTTPHeaders(connSettingRequestMap);
                                        }
                                        this.readServiceDiscoverySettings(connSettingRequestMap);
                                        variant2 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
                                        this.m_definedSettings.put("AuthMech", true);
                                        if (variant2 != null) {
                                            try {
                                                int n3 = variant2.getInt();
                                                AuthMech object32 = AuthMech.getAuthMech(n3);
                                                if (null != object32) {
                                                    this.m_settings.m_authMech = object32;
                                                    this.m_authMechSpecifiedByUser = true;
                                                    this.rectifyAuthMech(this.m_settings);
                                                }
                                                break block185;
                                            }
                                            catch (Exception exception7) {
                                                if (exception7 instanceof ErrorException) {
                                                    throw (ErrorException)exception7;
                                                }
                                                this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                                                this.m_authMechSpecifiedByUser = false;
                                                if (null != this.getWarningListener()) {
                                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                                                }
                                                break block185;
                                            }
                                        }
                                        this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                                        this.m_authMechSpecifiedByUser = false;
                                        LogUtilities.logInfo("Auth Mech is set to default: " + (Object)((Object)this.m_settings.m_authMech), (ILogger)this.m_log);
                                        if (AuthMech.NOAUTH == this.m_settings.m_authMech) {
                                            this.m_settings.m_transportMode = TransportMode.BINARY;
                                        }
                                    }
                                    this.m_settings.m_proxySettings = new ProxySettings();
                                    DSConnectionUtils.readProxySettings(connSettingRequestMap, this.m_settings.m_proxySettings);
                                    this.m_definedSettings.put("ProxyUid", true);
                                    this.m_definedSettings.put("ProxyPwd", true);
                                    this.m_definedSettings.put("UseProxy", true);
                                    this.m_definedSettings.put("ProxyType", true);
                                    this.m_definedSettings.put("ProxyHost", true);
                                    this.m_definedSettings.put("ProxyPort", true);
                                    this.m_definedSettings.put("ProxyAuth", true);
                                    this.m_definedSettings.put("DisableProxyForCloudFetch", true);
                                    this.m_definedSettings.put("InvalidPortProxyCloudFetch", true);
                                    this.m_definedSettings.put("ProxyIgnoreList", true);
                                    if (this.m_settings.m_proxySettings.m_useProxy && this.m_settings.m_proxySettings.m_proxyIgnoreList != null && !this.m_settings.m_proxySettings.m_proxyIgnoreList.isEmpty()) {
                                        for (String exception8 : this.m_settings.m_proxySettings.m_proxyIgnoreList) {
                                            if (!this.m_settings.m_host.contains(exception8)) continue;
                                            this.m_settings.m_proxySettings.m_isHostInProxyIgnoreList = true;
                                            break;
                                        }
                                    }
                                    this.m_settings.m_useResolvedHostname = false;
                                    this.m_definedSettings.put("UseResolvedHostname", false);
                                    variant2 = this.getOptionalSetting("UseResolvedHostname", connSettingRequestMap);
                                    if (null != variant2) {
                                        int n4 = 0;
                                        try {
                                            n4 = variant2.getInt();
                                        }
                                        catch (Exception exception9) {
                                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"UseResolvedHostname", variant2.getString(), "0 , 1"});
                                            errorException.initCause(exception9);
                                            throw errorException;
                                        }
                                        if (1 == n4) {
                                            this.m_settings.m_useResolvedHostname = true;
                                        }
                                    }
                                    variant2 = this.getOptionalSetting("ConnCatalog", connSettingRequestMap);
                                    this.m_definedSettings.put("ConnCatalog", true);
                                    if (null == variant2 || variant2.getString().equalsIgnoreCase("NULL")) {
                                        this.m_settings.m_catalog = this.m_settings.m_platformCatalog;
                                        this.m_settings.m_catalogSetByUser = false;
                                        LogUtilities.logInfo("Catalog is set to default: " + this.m_settings.m_catalog, (ILogger)this.m_log);
                                    } else {
                                        this.m_settings.m_catalog = variant2.getString();
                                        this.m_settings.m_catalogSetByUser = true;
                                    }
                                    variant2 = this.getOptionalSetting("ConnSchema", connSettingRequestMap);
                                    this.m_definedSettings.put("ConnSchema", true);
                                    if (null == variant2 || variant2.getString().equalsIgnoreCase("NULL")) {
                                        this.m_settings.m_Schema = "default";
                                        LogUtilities.logInfo("Schema is set to default: " + this.m_settings.m_Schema, (ILogger)this.m_log);
                                    } else {
                                        this.m_settings.m_Schema = variant2.getString();
                                    }
                                    variant2 = this.getOptionalSetting("KrbHostFQDN", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbHostFQDN", true);
                                    if (variant2 != null) {
                                        this.m_settings.m_krbHostFQDN = variant2.getString();
                                        if (ServiceDiscoveryMode.NO_SERVICE_DISCOVERY == this.m_settings.m_serviceDiscoveryMode && this.m_settings.m_krbHostFQDN.equals("_HOST")) {
                                            this.m_settings.m_krbHostFQDN = this.m_settings.m_host;
                                        }
                                    }
                                    variant2 = this.getOptionalSetting("KrbRealm", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbRealm", true);
                                    if (variant2 != null) {
                                        this.m_settings.m_krbRealm = variant2.getString();
                                    }
                                    variant2 = this.getOptionalSetting("KrbServiceName", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbServiceName", true);
                                    if (variant2 != null) {
                                        this.m_settings.m_krbServiceName = variant2.getString();
                                    }
                                    this.m_settings.m_krbAuthType = KrbAuthType.AUTO_DETECT;
                                    variant2 = this.getOptionalSetting("krbAuthType", connSettingRequestMap);
                                    this.m_definedSettings.put("krbAuthType", true);
                                    if (variant2 != null) {
                                        try {
                                            int n5 = variant2.getInt();
                                            if (n5 < KrbAuthType.values().length && n5 >= 0) {
                                                this.m_settings.m_krbAuthType = KrbAuthType.values()[n5];
                                            } else if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_INVALID_KRB_AUTH_TYPE.name()));
                                            }
                                        }
                                        catch (Exception exception10) {
                                            if (null == this.getWarningListener()) break block186;
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_INVALID_KRB_AUTH_TYPE.name()));
                                        }
                                    }
                                }
                                variant2 = this.getOptionalSetting("krbJAASFile", connSettingRequestMap);
                                this.m_definedSettings.put("krbJAASFile", true);
                                if (null != variant2) {
                                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), UNSUPPORTED_OPERATION);
                                    throw errorException;
                                }
                                this.m_settings.m_username = PAT_USER_NAME;
                                this.m_settings.m_password = null;
                                this.m_definedSettings.put("UID", true);
                                if ((AuthMech.SASL_PLAIN_UID == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech || this.m_settings.m_platformVersionUtils.sendUidViaOpenSessionReq(this.m_settings.m_authMech)) && (variant2 = this.getOptionalSetting("UID", connSettingRequestMap)) != null) {
                                    this.m_settings.m_username = variant2.getString();
                                }
                                if (AuthMech.SASL_PLAIN_UID == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech) {
                                    if (this.m_authMechSpecifiedByUser && null == PAT_USER_NAME) {
                                        variant2 = this.getRequiredSetting("UID", connSettingRequestMap);
                                        this.m_settings.m_username = variant2.getString();
                                    } else if (this.m_settings.m_username == null || this.m_settings.m_username.length() == 0) {
                                        this.m_settings.m_username = "anonymous";
                                        if (null != this.getWarningListener()) {
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PARAMETER_NOT_SET.name(), new String[]{"UID", "anonymous"}));
                                        }
                                    }
                                }
                                this.m_definedSettings.put("PWD", true);
                                if (AuthMech.UIDPWD == this.m_settings.m_authMech) {
                                    boolean bl = false;
                                    this.m_definedSettings.put("allowBasicAuthentication", true);
                                    bl = this.readOptionalBooleanSetting(connSettingRequestMap, "allowBasicAuthentication", bl, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                    if (!(bl || this.m_settings.m_username != null && this.m_settings.m_username.equals(PAT_USER_NAME))) {
                                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"UID", this.m_settings.m_username, PAT_USER_NAME});
                                        throw errorException;
                                    }
                                    if (this.m_authMechSpecifiedByUser) {
                                        variant2 = this.getRequiredSetting("PWD", connSettingRequestMap);
                                        this.m_settings.m_password = variant2.getString();
                                    } else {
                                        variant2 = this.getOptionalSetting("PWD", connSettingRequestMap);
                                        if (variant2 != null) {
                                            this.m_settings.m_password = variant2.getString();
                                        }
                                        if (this.m_settings.m_password == null || this.m_settings.m_password.length() == 0) {
                                            this.m_settings.m_password = "anonymous";
                                            if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PARAMETER_NOT_SET.name(), new String[]{"PWD", "anonymous"}));
                                            }
                                        }
                                    }
                                }
                                this.m_settings.m_serverSSLSettings = new SSLSettings();
                                this.m_settings.m_serverSSLSettings.m_enableSSL = true;
                                DSConnectionUtils.readSSLSettings(connSettingRequestMap, null, this.m_settings.m_serverSSLSettings, this.m_settings.m_forceSSL, NO_PROP_KEY_PREFIX, this.getWarningListener());
                                this.addSslPropertiesToDefinedSettings(NO_PROP_KEY_PREFIX);
                                this.setOAuthProperties(connSettingRequestMap);
                                this.setOAuthConfig(this.m_settings, connSettingRequestMap, variant2);
                                if (ServiceDiscoveryMode.AOSS == this.m_settings.m_serviceDiscoveryMode) {
                                    this.readAOSSSettings(connSettingRequestMap);
                                }
                                variant2 = this.getOptionalSetting("UseNativeQuery", connSettingRequestMap);
                                this.m_definedSettings.put("UseNativeQuery", true);
                                if (null != variant2) {
                                    try {
                                        this.m_settings.m_useNativeQuery = variant2.getInt() == 1;
                                    }
                                    catch (Exception exception11) {
                                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_NATIVEMODE_ERR.name(), exception11.getMessage());
                                        errorException.initCause(exception11);
                                        throw errorException;
                                    }
                                }
                                this.m_definedSettings.put("UpperCaseResultSetColName", true);
                                this.m_settings.m_upperCaseResultSetColName = this.readOptionalBooleanSetting(connSettingRequestMap, "UpperCaseResultSetColName", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                this.m_definedSettings.put("EnableIsQualifierTypeReturnedTesting", true);
                                this.m_settings.m_enableIsQualifierTypeReturnedTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableIsQualifierTypeReturnedTesting", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                if (this.m_settings.m_enableIsQualifierTypeReturnedTesting) {
                                    LogUtilities.logWarning("EnableIsQualifierTypeReturnedTesting is enabled. This should only be turned on for testing purposes.", (ILogger)this.m_log);
                                }
                                variant2 = this.getOptionalSetting("DelegationUID", connSettingRequestMap);
                                this.m_definedSettings.put("DelegationUID", true);
                                if (null != variant2) {
                                    try {
                                        this.m_settings.m_delegationUID = variant2.getString();
                                    }
                                    catch (Exception exception12) {
                                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATIONUID_ERR.name(), exception12.getMessage());
                                        errorException.initCause(exception12);
                                        throw errorException;
                                    }
                                }
                                variant2 = this.getOptionalSetting("DefaultStringColumnLength", connSettingRequestMap);
                                this.m_definedSettings.put("DefaultStringColumnLength", true);
                                if (null != variant2) {
                                    try {
                                        this.m_settings.m_stringColumnSize = variant2.getShort();
                                        if (this.m_settings.m_stringColumnSize <= 0 || this.m_settings.m_stringColumnSize > Short.MAX_VALUE) {
                                            this.m_settings.m_stringColumnSize = (short)255;
                                            if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_STRINGCOLUMNSIZE_ERR.name(), new String[]{"Column size value is invalid."}));
                                            }
                                        }
                                    }
                                    catch (Exception exception13) {
                                        this.m_settings.m_stringColumnSize = (short)255;
                                        if (null == this.getWarningListener()) break block187;
                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_STRINGCOLUMNSIZE_ERR.name(), new String[]{"Column size data type is invalid."}));
                                    }
                                }
                            }
                            variant2 = this.getOptionalSetting("AsyncExecPollInterval", connSettingRequestMap);
                            this.m_definedSettings.put("AsyncExecPollInterval", true);
                            if (null != variant2) {
                                try {
                                    this.m_settings.m_asyncExecPollInterval = variant2.getInt();
                                    if (0 >= this.m_settings.m_asyncExecPollInterval) {
                                        this.m_settings.m_asyncExecPollInterval = 1;
                                        if (null != this.getWarningListener()) {
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ASYNCEXECPOLLINTERVAL_ERR.name()));
                                        }
                                    }
                                }
                                catch (Exception exception14) {
                                    this.m_settings.m_asyncExecPollInterval = 1;
                                    if (null == this.getWarningListener()) break block188;
                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ASYNCEXECPOLLINTERVAL_ERR.name()));
                                }
                            }
                        }
                        variant2 = this.getOptionalSetting("FetchEndWaitTime", connSettingRequestMap);
                        this.m_definedSettings.put("FetchEndWaitTime", true);
                        if (null != variant2) {
                            try {
                                this.m_settings.m_fetchEndWaitTime = variant2.getLong();
                            }
                            catch (Exception exception15) {
                                this.m_settings.m_fetchEndWaitTime = 5L;
                                if (null == this.getWarningListener()) break block189;
                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant2.getString(), "FetchEndWaitTime", String.valueOf(5L)}));
                            }
                        }
                    }
                    variant = this.getOptionalSetting("SocketTimeOut", connSettingRequestMap);
                    this.m_definedSettings.put("SocketTimeOut", true);
                    if (null != variant) {
                        try {
                            this.m_settings.m_timeout = variant.getInt() * 1000;
                            if (this.m_settings.m_timeout < 0) {
                                this.m_settings.m_timeout = 0;
                                if (null != this.getWarningListener()) {
                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.SET_SOCKETTIMEOUT_ERR.name(), new String[]{"Timeout value cannot be negative."}));
                                }
                            }
                        }
                        catch (Exception exception16) {
                            this.m_settings.m_timeout = 0;
                            if (null == this.getWarningListener()) break block190;
                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.SET_SOCKETTIMEOUT_ERR.name(), new String[]{"Timeout value must be an integer."}));
                        }
                    }
                }
                Variant variant3 = this.getOptionalSetting("RowsFetchedPerBlock", connSettingRequestMap);
                this.m_definedSettings.put("RowsFetchedPerBlock", true);
                if (null != variant3) {
                    try {
                        this.m_settings.m_rowsFetchedPerBlock = variant3.getInt();
                        if (this.m_settings.m_rowsFetchedPerBlock < 0) {
                            this.m_settings.m_rowsFetchedPerBlock = 10000;
                            if (null != this.getWarningListener()) {
                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of RowsFetchedPerBlock cannot be negative."}));
                            }
                        }
                    }
                    catch (Exception exception17) {
                        this.m_settings.m_rowsFetchedPerBlock = 10000;
                        if (null == this.getWarningListener()) break block191;
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of RowsFetchedPerBlock must be an integer."}));
                    }
                }
            }
            this.m_definedSettings.put("SetFetchSizeTakesPrecedence", true);
            this.m_settings.m_setFetchSizeTakesPrecedence = this.readOptionalBooleanSetting(connSettingRequestMap, "SetFetchSizeTakesPrecedence", true, HiveJDBCMessageKey.CONN_CONF_ERROR);
            this.m_definedSettings.put("EnableSetFetchSizeTesting", true);
            this.m_settings.m_enableSetFetchSizeTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableSetFetchSizeTesting", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
            if (this.m_settings.m_enableSetFetchSizeTesting) {
                LogUtilities.logWarning("EnableSetFetchSizeTesting is enabled. This should only be turned on for testing purposes.", (ILogger)this.m_log);
            }
            this.m_definedSettings.put("ExpectedFetchSize", true);
            this.m_settings.m_expectedFetchSize = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "ExpectedFetchSize", this.m_settings.m_rowsFetchedPerBlock);
            Variant variant4 = this.getOptionalSetting("DecimalColumnScale", connSettingRequestMap);
            this.m_definedSettings.put("DecimalColumnScale", true);
            if (null != variant4) {
                try {
                    this.m_settings.m_decimalColumnScale = variant4.getShort();
                    if (this.m_settings.m_decimalColumnScale < 0 || this.m_settings.m_decimalColumnScale > 38) {
                        this.m_settings.m_decimalColumnScale = (short)10;
                        if (null != this.getWarningListener()) {
                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of Decimal Column Scale must be less than 38 and greater or equal to 0."}));
                        }
                    }
                }
                catch (Exception object2) {
                    this.m_settings.m_decimalColumnScale = (short)10;
                    if (null == this.getWarningListener()) break block192;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_DECIMALCOLUMNSCALE_ERR.name(), new String[]{"Value of RowsFetchedPerBlock must be an integer."}));
                }
            }
        }
        this.m_definedSettings.put("BinaryColumnLength", true);
        this.m_settings.m_binaryColumnSize = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "BinaryColumnLength", Short.MAX_VALUE);
        this.m_definedSettings.put("EnableZeroRowsTesting", true);
        this.m_settings.m_thriftHTTPSettings.m_enableZeroRowsTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableZeroRowsTesting", false, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_settings.m_disableDNSResolver = true;
        this.m_definedSettings.put("DisableDNSResolver", true);
        this.m_settings.m_disableDNSResolver = this.readOptionalBooleanSetting(connSettingRequestMap, "DisableDNSResolver", this.m_settings.m_disableDNSResolver, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        if (this.m_settings.m_thriftHTTPSettings.m_enableZeroRowsTesting) {
            this.m_definedSettings.put("EmulateZeroRowFetchBlocks", true);
            this.m_settings.m_thriftHTTPSettings.m_emulateZeroRowBlocks = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "EmulateZeroRowFetchBlocks", 0);
        }
        this.m_definedSettings.put("ReportGetFunctionsApiCallSupport", true);
        this.m_settings.m_reportGetFunctionsApiCallSupport = this.readOptionalBooleanSetting(connSettingRequestMap, "ReportGetFunctionsApiCallSupport", true, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        variant2 = this.getOptionalSetting("ServerReturnsCorrectHasMoreRows", connSettingRequestMap);
        this.m_definedSettings.put("ServerReturnsCorrectHasMoreRows", true);
        if (null != variant2) {
            try {
                this.m_settings.m_isServerReturnsCorrectHasMoreRows = variant2.getInt() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (Exception exception18) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"ServerReturnsCorrectHasMoreRows", variant2.getString(), "0 , 1"});
                errorException.initCause(exception18);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("CatalogSchemaSwitch", connSettingRequestMap);
        this.m_definedSettings.put("CatalogSchemaSwitch", true);
        if (null != variant2) {
            try {
                if (variant2.getInt() == 0) {
                    this.m_settings.m_switchCataANDSchema = false;
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SWITCHCATASCHEMA_TYPE_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
            catch (Exception exception19) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SWITCHCATASCHEMA_ERR.name(), exception19.getMessage());
                errorException.initCause(exception19);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("PreparedMetaLimitZero", connSettingRequestMap);
        this.m_definedSettings.put("PreparedMetaLimitZero", true);
        if (null != variant2) {
            try {
                this.m_settings.m_preparedStmtGetMetadataLimitZero = variant2.getInt() == 1;
            }
            catch (IncorrectTypeException exception20) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_PREPAREDMETALIMITZERO_TYPE_ERR.name(), exception20.getMessage());
                errorException.initCause(exception20);
                throw errorException;
            }
            catch (Exception exception21) {
                ErrorException object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_PREPAREDMETALIMITZERO_ERR.name(), exception21.getMessage());
                object2.initCause(exception21);
                throw object2;
            }
        }
        variant2 = this.getOptionalSetting("LowerCaseResultSetColumnName", connSettingRequestMap);
        this.m_definedSettings.put("LowerCaseResultSetColumnName", true);
        if (null != variant2) {
            try {
                if (variant2.getInt() == 0) {
                    this.m_settings.m_columnNameAliaseCase = HiveJDBCCasePreservingAlias.PRESERVE_CASE;
                } else if (variant2.getInt() == 1) {
                    this.m_settings.m_columnNameAliaseCase = HiveJDBCCasePreservingAlias.LOWERCASE;
                }
            }
            catch (Exception exception22) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_LOWERCASE_COLUMNNAME_ALIASE_ERROR.name()));
            }
        }
        variant2 = this.getOptionalSetting("PushdownCatalogFunctionFilters", connSettingRequestMap);
        this.m_definedSettings.put("PushdownCatalogFunctionFilters", true);
        if (null != variant2) {
            try {
                this.m_settings.m_pushdownCatalogFunctionFilters = variant2.getInt() == 1;
            }
            catch (Exception exception23) {
                this.m_settings.m_pushdownCatalogFunctionFilters = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PUSHDOWN_CATALOG_FUNCTION_FILTERS_ERROR.name()));
            }
        }
        variant2 = this.getOptionalSetting("StripCatalogName", connSettingRequestMap);
        this.m_definedSettings.put("StripCatalogName", true);
        if (null != variant2) {
            try {
                if (0 == variant2.getInt() && !this.m_settings.m_useNativeQuery) {
                    this.m_settings.m_stripCatalogName = false;
                }
            }
            catch (IncorrectTypeException exception24) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STRIPCATALOGNAME_TYPE_ERR.name(), exception24.getMessage());
                errorException.initCause(exception24);
                throw errorException;
            }
            catch (Exception exception25) {
                ErrorException object4 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STRIPCATALOGNAME_ERR.name(), exception25.getMessage());
                object4.initCause(exception25);
                throw object4;
            }
        }
        if (this.m_settings.m_switchCataANDSchema) {
            this.m_settings.m_stripCatalogName = false;
        }
        variant2 = this.getOptionalSetting("userGSSCredentialID", connSettingRequestMap);
        this.m_definedSettings.put("userGSSCredentialID", true);
        if (null != variant2 && null != (exception = HiveCommonGSSCredentialMap.get(variant2.getString()))) {
            this.m_settings.m_userGSSCredential = exception;
            HiveCommonGSSCredentialMap.remove(variant2.getString());
        }
        this.m_settings.m_useCustomCoercionMap = true;
        variant2 = this.getOptionalSetting("UseCustomTypeCoercionMap", connSettingRequestMap);
        this.m_definedSettings.put("UseCustomTypeCoercionMap", true);
        if (null != variant2) {
            try {
                this.m_settings.m_useCustomCoercionMap = variant2.getInt() == 1;
            }
            catch (Exception exception26) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"UseCustomTypeCoercionMap", variant2.getString(), "0 , 1"});
                errorException.initCause(exception26);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("AutomaticColumnRename", connSettingRequestMap);
        this.m_definedSettings.put("AutomaticColumnRename", true);
        if (null != variant2) {
            try {
                this.m_settings.m_automaticColumnRename = variant2.getInt() == 1;
            }
            catch (Exception exception27) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"AutomaticColumnRename", variant2.getString(), "0 , 1"});
                errorException.initCause(exception27);
                throw errorException;
            }
        }
        this.m_settings.m_hiveAsyncQueryTest = false;
        variant2 = this.getOptionalSetting("HiveAsyncQueryTest", connSettingRequestMap);
        this.m_definedSettings.put("HiveAsyncQueryTest", true);
        if (null != variant2) {
            try {
                this.m_settings.m_hiveAsyncQueryTest = variant2.getInt() == 1;
            }
            catch (Exception exception28) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"HiveAsyncQueryTest", variant2.getString(), "0 , 1"});
                errorException.initCause(exception28);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("DelegationToken", connSettingRequestMap);
        this.m_definedSettings.put("DelegationToken", true);
        if (null != variant2) {
            try {
                this.m_settings.m_delegationToken = variant2.getString();
            }
            catch (Exception exception29) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"DelegationToken", variant2.getString()});
                errorException.initCause(exception29);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("NonSSPs", connSettingRequestMap);
        this.m_definedSettings.put("NonSSPs", true);
        if (null != variant2) {
            try {
                exception = variant2.getString();
                object = ((String)exception).split(",");
                this.m_settings.m_nonSSPs.addAll(Arrays.asList(object));
            }
            catch (Exception exception30) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"NonSSPs", variant2.getString()});
                errorException.initCause(exception30);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("NonSSPPrefixes", connSettingRequestMap);
        this.m_definedSettings.put("NonSSPPrefixes", true);
        if (null != variant2) {
            try {
                exception = variant2.getString();
                this.m_settings.m_nonSSPPrefixes.clear();
                if (!((String)exception).isEmpty()) {
                    object = ((String)exception).split(",");
                    this.m_settings.m_nonSSPPrefixes.addAll(Arrays.asList(object));
                }
            }
            catch (Exception exception31) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"NonSSPPrefixes", variant2.getString()});
                ((Throwable)object).initCause(exception31);
                throw object;
            }
        }
        this.m_settings.m_customNetworkHooksSettings = new CustomNetworkHooksSettings();
        DSConnectionUtils.readCustomNetworkHooksProperties(connSettingRequestMap, this.m_settings.m_customNetworkHooksSettings);
        this.m_definedSettings.put("SocketFactory", true);
        this.m_definedSettings.put("SocketFactoryArg", true);
        this.m_definedSettings.put("DnsResolver", true);
        this.m_definedSettings.put("DnsResolverArg", true);
        this.m_definedSettings.put("IgnoreTransactions", true);
        this.m_definedSettings.put("ClaimTransactionSupportWhenIgnoreTransactionsEnabled", true);
        this.readAndApplyTransactionSettings(connSettingRequestMap);
        this.m_settings.m_socketTimeoutAfterConnected = true;
        variant2 = this.getOptionalSetting("SocketTimeoutAfterConnected", connSettingRequestMap);
        this.m_definedSettings.put("SocketTimeoutAfterConnected", true);
        if (null != variant2) {
            try {
                this.m_settings.m_socketTimeoutAfterConnected = variant2.getInt() != 0;
            }
            catch (Exception exception32) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"SocketTimeoutAfterConnected", variant2.getString(), "0 , 1"});
                ((Throwable)object).initCause(exception32);
                throw object;
            }
        }
        this.m_definedSettings.put("Username", true);
        this.m_definedSettings.put("TestSensitiveDataInSsp", true);
        this.m_settings.m_testSensitiveDataInSsp = this.readOptionalBooleanSetting(connSettingRequestMap, "TestSensitiveDataInSsp", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        if (this.m_settings.m_testSensitiveDataInSsp.booleanValue()) {
            LogUtilities.logWarning("TestSensitiveDataInSsp is enabled. This should be used for testing purposes only.", (ILogger)this.m_log);
        }
        this.m_definedSettings.put("SensitiveKeysInSsp", true);
        this.m_settings.m_sensitiveKeysInSsp = this.readOptionalStringSetting(connSettingRequestMap, "SensitiveKeysInSsp", "UID,Username,PWD,Password");
        this.m_definedSettings.put("UseLegacyCatalogRemovalLogic", true);
        this.m_settings.m_useLegacyCatalogRemovalLogic = this.readOptionalBooleanSetting(connSettingRequestMap, "UseLegacyCatalogRemovalLogic", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("EnableCatalogRemovalForTest", true);
        this.m_settings.m_enableCatalogRemovalForTest = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableCatalogRemovalForTest", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        HiveCommonConnectionUtils.readHttpRetrySettings(connSettingRequestMap, this.m_settings.m_supportedHttpRetryType, this.m_settings.m_thriftHTTPSettings.m_httpRetrySettingsList, this.getWarningListener());
        HiveCommonConnectionUtils.readHttpErrorEmulationSettings(connSettingRequestMap, this.m_settings.m_thriftHTTPSettings.m_httpErrorEmulationSettingsMap, this.getWarningListener());
        this.m_definedSettings.put("EnableHttpErrorTesting", true);
        this.m_definedSettings.put("HttpEmulatedError", true);
        HiveCommonConnectionUtils.readZookeeperSettings(connSettingRequestMap, this.m_settings.m_zookeeperSettings, this.getWarningListener(), this.m_log);
        if (AuthMech.SAML_2_0 == this.m_settings.m_authMech) {
            HiveCommonConnectionUtils.readSSOSAMLSettings(connSettingRequestMap, this.m_settings, this.m_definedSettings, this.m_log, n);
        }
        if (AuthMech.JWT == this.m_settings.m_authMech) {
            this.setJWTProperties(connSettingRequestMap);
        }
        this.m_definedSettings.put("EnableZkRoundRobinStrategy", true);
        this.m_definedSettings.put("EnableZookeeperTesting", true);
        this.m_definedSettings.put("ZKTestHosts", true);
        this.m_definedSettings.put("ZKTestIndices", true);
        this.m_definedSettings.put("ZKTestSetCallIndex", true);
        this.m_definedSettings.put("MaxNumServerLists", true);
        this.m_definedSettings.put("EnableMultipleCatalogSupport", true);
        this.m_settings.m_requestEnableMultiCatalog = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableMultipleCatalogSupport", this.m_settings.m_requestEnableMultiCatalog, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.setDriverSpecificSettings();
        this.m_definedSettings.put("EnableDirectResults", true);
        this.m_settings.m_enableDirectResults = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableDirectResults", this.m_settings.m_enableDirectResults, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("EnableArrow", true);
        this.m_settings.m_enableArrow = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableArrow", this.m_settings.m_enableArrow, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("MaxBytesPerFetchRequest", true);
        this.m_definedSettings.put("ArrowTimestampAsString", true);
        if (this.m_settings.m_enableArrow) {
            this.m_settings.m_arrowMaxBytesPerFetch = HiveCommonConnectionUtils.readOptionalPositiveLongSetting(connSettingRequestMap, "MaxBytesPerFetchRequest", 300000000L, this.getConnectionLog(), this.getWarningListener());
            if (this.m_settings.m_arrowMaxBytesPerFetch < 5000000L) {
                this.m_settings.m_arrowMaxBytesPerFetch = 5000000L;
            }
            this.m_settings.m_arrowTimestampAsString = this.readOptionalBooleanSetting(connSettingRequestMap, "ArrowTimestampAsString", this.m_settings.m_arrowTimestampAsString, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        }
        HiveCommonConnectionUtils.readDownloadableResultSettings(connSettingRequestMap, this.m_settings.m_downloadableResultSettings, this.m_definedSettings, this.m_settings.m_serverSSLSettings, this.getConnectionLog(), this.getWarningListener());
        this.m_definedSettings.put("EnableFetchHeartbeat", true);
        this.m_settings.m_isEnableHeartBeat = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableFetchHeartbeat", true, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("FetchHeartbeatInterval", true);
        this.m_settings.m_heartBeatInterval = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "FetchHeartbeatInterval", 30000);
        this.m_definedSettings.put("databricks.catalog", true);
        this.m_settings.m_databricksCatalogSSP = this.readOptionalStringSetting(connSettingRequestMap, "databricks.catalog", null);
        this.m_definedSettings.put("UseSqlStateFromServer", true);
        this.m_settings.m_useSqlStateFromServer = this.readOptionalBooleanSetting(connSettingRequestMap, "UseSqlStateFromServer", true, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("ApplySSPWithQueries", true);
        exception = this.readOptionalBooleanIfSet(connSettingRequestMap, "ApplySSPWithQueries", false, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        Object object3 = exception[0];
        this.m_settings.m_bypassChecksForSSPWithQueries = object3 | 0;
        this.m_settings.m_applySSPWithQueries = exception[1];
        this.m_settings.m_stagingAllowedLocalPaths = new ArrayList<String>();
        this.m_definedSettings.put("StagingAllowedLocalPaths", true);
        Variant variant5 = this.getOptionalSetting("StagingAllowedLocalPaths", connSettingRequestMap);
        if (null != variant5) {
            this.parseStagingAllowedLocalPaths(variant5.getString());
        }
        this.m_settings.m_ucIngestionRetriableHttpCode = new ArrayList<String>();
        this.m_definedSettings.put("UCIngestionRetriableHttpCode", true);
        Variant variant6 = this.getOptionalSetting("UCIngestionRetriableHttpCode", connSettingRequestMap);
        this.m_settings.m_ucIngestionRetriableHttpCode = null != variant6 ? this.parseAllowedHttpCodes(variant6.getString()) : this.parseAllowedHttpCodes("408,502,503,504");
        this.m_definedSettings.put("UCIngestionRetryTimeout", true);
        this.m_settings.m_ucIngestionRetryTimeout = this.readOptionalIntegerSetting(connSettingRequestMap, "UCIngestionRetryTimeout", this.m_settings.m_ucIngestionRetryTimeout);
        this.m_settings.m_enableUCIngestionHTTPErrorTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableUCIngestionHTTPErrorTesting", this.m_settings.m_enableUCIngestionHTTPErrorTesting, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        if (this.m_settings.m_enableUCIngestionHTTPErrorTesting.booleanValue()) {
            LogUtilities.logWarning("EnableUCIngestionHTTPErrorTesting is enabled. This should only be turned onfor testing purposes.", (ILogger)this.m_log);
        }
        this.m_definedSettings.put("ExpiredCachedAccessTokenTest", true);
        this.m_settings.m_expiredCachedAccessTokenTest = this.readOptionalStringSetting(connSettingRequestMap, "ExpiredCachedAccessTokenTest", NO_PROP_KEY_PREFIX);
        this.m_definedSettings.put("ExpiredCachedRefreshTokenTest", true);
        this.m_settings.m_expiredCachedRefreshTokenTest = this.readOptionalStringSetting(connSettingRequestMap, "ExpiredCachedRefreshTokenTest", NO_PROP_KEY_PREFIX);
        if (!this.m_settings.m_expiredCachedAccessTokenTest.isEmpty() || !this.m_settings.m_expiredCachedRefreshTokenTest.isEmpty()) {
            LogUtilities.logWarning("EnableCachedAccessAndRefreshTokenTest is enabled. This should only be turned onfor testing purposes.", (ILogger)this.m_log);
        }
        this.m_settings.m_oAuthRetriableHttpCode = new ArrayList<String>();
        this.m_definedSettings.put("OAuthRetriableHttpCode", true);
        Variant variant7 = this.getOptionalSetting("OAuthRetriableHttpCode", connSettingRequestMap);
        this.m_settings.m_oAuthRetriableHttpCode = null != variant7 ? this.parseAllowedHttpCodes(variant7.getString()) : this.parseAllowedHttpCodes("408,502,503,504");
        this.m_definedSettings.put("OAuthHTTPRetryTimeout", true);
        this.m_settings.m_oAuthHTTPRetryTimeout = this.readOptionalIntegerSetting(connSettingRequestMap, "OAuthHTTPRetryTimeout", this.m_settings.m_oAuthHTTPRetryTimeout);
        this.m_definedSettings.put("EnableOAuthHTTPErrorTesting", true);
        this.m_settings.m_enableOAuthHTTPErrorTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableOAuthHTTPErrorTesting", this.m_settings.m_enableOAuthHTTPErrorTesting, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("CaseInsensitiveMetadataFilter", true);
        this.m_settings.m_caseInsensitiveMetadataFilter = this.readOptionalBooleanSetting(connSettingRequestMap, "CaseInsensitiveMetadataFilter", this.m_settings.m_caseInsensitiveMetadataFilter, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        if (this.m_settings.m_enableOAuthHTTPErrorTesting) {
            LogUtilities.logWarning("EnableOAuthHTTPErrorTesting is enabled. This should only be turned onfor testing purposes.", (ILogger)this.m_log);
        }
        this.m_definedSettings.put("UseUTF8ForString", true);
        this.m_settings.m_useUTF8ForDecoding = this.readOptionalBooleanSetting(connSettingRequestMap, "UseUTF8ForString", this.m_settings.m_useUTF8ForDecoding, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("UseCustomTimestampConverter", true);
        this.m_settings.m_useCustomTimestampConverter = this.readOptionalBooleanSetting(connSettingRequestMap, "UseCustomTimestampConverter", this.m_settings.m_useCustomTimestampConverter, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("EnableTelemetry", true);
        this.m_definedSettings.put("TelemetryBatchSize", true);
        this.m_definedSettings.put("TelemetryTimer", true);
        this.m_settings.m_enableTelemetry = false;
        this.m_settings.m_enableTelemetry = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableTelemetry", this.m_settings.m_enableTelemetry, HiveJDBCMessageKey.CONN_CONF_ERROR);
        if (this.m_settings.m_enableTelemetry) {
            this.m_settings.m_telemetryBatchSize = this.readOptionalIntegerSetting(connSettingRequestMap, "TelemetryBatchSize", this.m_settings.m_telemetryBatchSize);
            this.m_settings.m_telemetryTimer = this.readOptionalIntegerSetting(connSettingRequestMap, "TelemetryTimer", this.m_settings.m_telemetryTimer);
        }
        this.setDefinedSettings();
        this.initializeSSPMap(connSettingRequestMap);
        this.connectToServer(n, null == variant);
        this.configureSettingsAfterEstablishConnection(connSettingRequestMap);
        this.setClientAppInfo();
    }

    protected void connectToServer(int n, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_settings.m_fastConnect) {
            String string = "socketTimeout = " + this.m_settings.m_timeout / 1000 + ", loginTimeout = " + n;
            LogUtilities.logDebug(string, (ILogger)this.m_log);
            int n2 = this.m_settings.m_timeout;
            int n3 = n * 1000;
            if (0 != n) {
                if (0 == this.m_settings.m_timeout || this.m_settings.m_timeout > n3 || bl) {
                    this.m_settings.m_timeout = n3;
                    string = "SocketTimeout is: " + this.m_settings.m_timeout / 1000 + " seconds for test";
                    LogUtilities.logDebug(string, (ILogger)this.m_log);
                }
            } else if (bl) {
                this.m_settings.m_timeout = 30000;
                string = "SocketTimeout is: " + this.m_settings.m_timeout / 1000 + " seconds for test";
                LogUtilities.logDebug(string, (ILogger)this.m_log);
            }
            IHiveClientFactory iHiveClientFactory = this.getClientFactory();
            this.m_hiveClient = iHiveClientFactory.createClient(this.m_settings, this.m_log, this.getWarningListener());
            if (bl || !this.m_settings.m_socketTimeoutAfterConnected || !this.m_settings.m_platformVersionUtils.supportsAsynchronousOperations(this.m_settings.m_serverVersion)) {
                n2 = 0;
            }
            if (n2 != this.m_settings.m_timeout) {
                ServiceDiscoveryMode serviceDiscoveryMode = this.m_settings.m_serviceDiscoveryMode;
                this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.NO_SERVICE_DISCOVERY;
                this.m_settings.m_timeout = n2;
                this.m_hiveClient.setSocketTimeout(n2);
                string = "socketTimeout is set back to " + this.m_settings.m_timeout + " seconds";
                LogUtilities.logDebug(string, (ILogger)this.m_log);
                this.m_settings.m_serviceDiscoveryMode = serviceDiscoveryMode;
            }
        } else {
            IHiveClientFactory iHiveClientFactory = this.getClientFactory();
            this.m_hiveClient = iHiveClientFactory.createClient(this.m_settings, this.m_log, this.getWarningListener());
        }
    }

    public IHiveClient getClient() {
        return this.m_hiveClient;
    }

    public IHiveClientFactory getClientFactory() {
        return this.m_factory;
    }

    public String getDelegationToken(String string, String string2) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                String string3 = ((HS2Client)this.m_hiveClient).getDelegationToken(string, string2);
                String string4 = string3.replace("=", NO_PROP_KEY_PREFIX).replace("+", "-").replace("/", "_");
                return string4;
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getMessage(), string, string2});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "getDelegationToken");
        throw errorException;
    }

    public IHiveClient getHiveClient() {
        return this.m_hiveClient;
    }

    public HiveJDBCSettings getSettings() {
        return this.m_settings;
    }

    public ExecutorService getThreadPool() {
        return this.m_threadPool;
    }

    @Override
    public void handleException(Exception exception) throws ErrorException {
        Throwable throwable;
        if (null != exception && !(exception instanceof TimeoutException) && null != (throwable = exception.getCause()) && throwable instanceof ErrorException && null != (throwable = throwable.getCause()) && throwable instanceof TTransportException && null != throwable.getCause()) {
            String string;
            if (throwable.getCause() instanceof SocketTimeoutException) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null != throwable.getMessage() ? throwable.getMessage() : "Unknown"});
                errorException.initCause(throwable);
                throw errorException;
            }
            if (throwable.getCause() instanceof ConnectException && null != (string = throwable.getCause().getMessage()) && string.toLowerCase().contains("connection timed out")) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null != throwable.getMessage() ? throwable.getMessage() : "Unknown"});
                errorException.initCause(throwable);
                throw errorException;
            }
        }
        super.handleException(exception);
    }

    @Override
    public boolean isAlive() {
        return this.m_settings.m_isConnAlive;
    }

    @Override
    public void setClientInfoProperty(String string, String string2) throws ClientInfoException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        if ("Auth_AccessToken".equalsIgnoreCase(string)) {
            this.m_settings.m_oAuthSettings.m_accessToken = string2;
            if (!this.m_settings.m_oAuthSettings.m_maskClientInfoAccessToken) {
                super.setClientInfoProperty("Auth_AccessToken", string2);
            }
        } else if (APPLICATION_NAME.equalsIgnoreCase(string)) {
            super.setClientInfoProperty(string, string2);
            this.setClientAppInfo();
        } else {
            super.setClientInfoProperty(string, string2);
        }
    }

    public void renewDelegationToken(String string) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                ((HS2Client)this.m_hiveClient).renewDelegationToken(string);
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getLocalizedMessage(), string});
                errorException.initCause(exception);
                throw errorException;
            }
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "renewDelegationToken");
            throw errorException;
        }
    }

    @Override
    public String toNativeSQL(String string) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (this.m_settings.m_enableCatalogRemovalForTest.booleanValue()) {
            return HiveCommonQueryTranslationUtils.stripCatalogName(string, this.getConnectionLog(), this.m_settings, this.getWarningListener());
        }
        if (!this.m_settings.m_useNativeQuery) {
            HashMap<Character, Character> hashMap = new HashMap<Character, Character>();
            hashMap.put(Character.valueOf('\''), Character.valueOf('\''));
            hashMap.put(Character.valueOf('\"'), Character.valueOf('\"'));
            hashMap.put(Character.valueOf('`'), Character.valueOf('`'));
            return ParseQueryUtils.parseCommentsOnSingleQuery(string, this.m_settings.m_platformVersionUtils.supportsQueryCommentHints(this.m_settings.m_serverVersion), hashMap);
        }
        return string;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Object object;
        Variant variant;
        Variant variant2;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        String string = null;
        LogLevel logLevel = LogLevel.OFF;
        String string2 = NO_PROP_KEY_PREFIX;
        Variant variant3 = this.getOptionalSetting("LogPath", connSettingRequestMap);
        Variant variant4 = this.getOptionalSetting("LogLevel", connSettingRequestMap);
        Variant variant5 = this.getOptionalSetting("LogNamespace", connSettingRequestMap);
        if (null != variant3) {
            string = variant3.getString();
        }
        if (null != variant4) {
            logLevel = LogLevel.getLogLevel(variant4.getString());
        }
        if (null != variant5) {
            string2 = variant5.getString();
        }
        this.createConnectionLog(logLevel, string, string2);
        HiveJDBCSettings hiveJDBCSettings = new HiveJDBCSettings();
        hiveJDBCSettings.m_serverSSLSettings = new SSLSettings();
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        Variant variant6 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
        AuthMech authMech = null;
        if (null != variant6) {
            try {
                authMech = AuthMech.getAuthMech(variant6.getInt());
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.toString(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null != authMech) {
            if (AuthMech.MAPRSASL == authMech) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_AUTH_MECH_ERR.toString(), authMech.getDisplayName());
                throw errorException;
            }
            hiveJDBCSettings.m_authMech = authMech;
        }
        if (null != (variant2 = this.getOptionalSetting("HiveServerType", connSettingRequestMap))) {
            try {
                if (1 == variant2.getInt()) {
                    hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer1;
                } else if (2 == variant2.getInt()) {
                    hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer2;
                }
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HIVESERVERTYPE_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        Variant variant7 = this.getOptionalSetting("ssl", connSettingRequestMap);
        this.m_definedSettings.put("ssl", true);
        if (variant7 != null) {
            try {
                boolean bl;
                boolean bl2 = bl = variant7.getInt() == 1;
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = bl;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"ssl", variant7.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null != (variant = this.getOptionalSetting("transportMode", connSettingRequestMap))) {
            object = variant.getString();
            hiveJDBCSettings.m_transportMode = ((String)object).equalsIgnoreCase("http") ? TransportMode.HTTP : (((String)object).equalsIgnoreCase("binary") ? TransportMode.BINARY : TransportMode.SASL);
        }
        this.verifyOptionalSetting("ServiceDiscoveryMode", connSettingRequestMap, connSettingResponseMap);
        object = this.getOptionalSetting("ServiceDiscoveryMode", connSettingRequestMap);
        if (null != object && ServiceDiscoveryMode.NO_SERVICE_DISCOVERY.name().equalsIgnoreCase(((Variant)object).getString())) {
            hiveJDBCSettings.m_serviceDiscoveryMode = ServiceDiscoveryMode.NO_SERVICE_DISCOVERY;
        } else {
            Variant variant8 = this.getOptionalSetting("zk", connSettingRequestMap);
            Variant variant9 = this.getOptionalSetting("AOSSStatusEndpoints", connSettingRequestMap);
            Variant variant10 = this.getOptionalSetting("Host", connSettingRequestMap);
            hiveJDBCSettings.m_serviceDiscoveryMode = (null != variant8 || null != object && ServiceDiscoveryMode.ZOOKEEPER.name().equalsIgnoreCase(((Variant)object).getString())) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.ZOOKEEPER, this.getConnectionLog()) ? ServiceDiscoveryMode.ZOOKEEPER : (null != variant9 || null != object && ServiceDiscoveryMode.AOSS.name().equalsIgnoreCase(((Variant)object).getString()) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.AOSS, this.getConnectionLog()) ? ServiceDiscoveryMode.AOSS : ServiceDiscoveryMode.NO_SERVICE_DISCOVERY);
        }
        if (ServiceDiscoveryMode.NO_SERVICE_DISCOVERY == hiveJDBCSettings.m_serviceDiscoveryMode) {
            this.verifyRequiredSetting("Host", connSettingRequestMap, connSettingResponseMap);
            if (this.isPortRequired()) {
                this.verifyRequiredSetting("Port", connSettingRequestMap, connSettingResponseMap);
            } else {
                this.verifyOptionalSetting("Port", connSettingRequestMap, connSettingResponseMap);
            }
        }
        this.verifyRequiredSetting("DatabaseType", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DefaultStringColumnLength", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AsyncExecPollInterval", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("RowsFetchedPerBlock", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AuthMech", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SocketTimeOut", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DelegationUID", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ConnSchema", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ssl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("CatalogSchemaSwitch", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("PreparedMetaLimitZero", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseNativeQuery", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseCustomTypeCoercionMap", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("StripCatalogName", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AutomaticColumnRename", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DelegationToken", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ServerVersion", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("FastConnection", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("NonSSPs", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SocketFactory", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SocketFactoryArg", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DnsResolver", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DnsResolverArg", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("krbJAASFile", connSettingRequestMap, connSettingResponseMap);
        return this.updateConnectionSettings(hiveJDBCSettings, connSettingRequestMap, connSettingResponseMap);
    }

    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        return connSettingResponseMap;
    }

    public abstract IHiveCustomScalarFnFactory getScalarFnHelper();

    protected boolean isPortRequired() {
        return false;
    }

    protected void setDriverSpecificSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnectionLog(LogLevel logLevel, String string, String string2) {
        String string3 = this.getConnectionLogFileName();
        Object object = s_loggerLock;
        synchronized (object) {
            if (null == this.m_log) {
                this.m_log = new HiveJDBCCommonConnectionLogger(string3 + Integer.toString(s_connectionID++), logLevel, string, string2);
                this.m_log.setLocale(this.getLocale());
            }
        }
    }

    protected void configureSettingsAfterEstablishConnection(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (ServiceDiscoveryMode.ZOOKEEPER == this.m_settings.m_serviceDiscoveryMode) {
            this.m_definedSettings.put("Port", true);
        }
        this.m_definedSettings.put("DisableTranslatedToOriginalQueryFallback", true);
        this.m_settings.m_disableTranslatedToOriginalQueryFallback = this.readOptionalBooleanSetting(connSettingRequestMap, "DisableTranslatedToOriginalQueryFallback", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_settings.m_tableNameColIndex = this.m_settings.m_platformVersionUtils.getTableNameColIndex(this.m_settings.m_serverVersion);
        this.m_settings.m_isTemporaryColIndex = this.m_settings.m_platformVersionUtils.getIsTemporaryColIndex(this.m_settings.m_serverVersion);
        this.m_definedSettings.put("ShowTablesTableNameColIdx", true);
        Variant variant = this.getOptionalSetting("ShowTablesTableNameColIdx", connSettingRequestMap);
        if (null != variant) {
            try {
                n = variant.getInt();
                this.m_settings.m_tableNameColIndex = 0 <= n ? n : this.m_settings.m_tableNameColIndex;
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SHOW_TABLES_TABLE_NAME_COL_IDX.name()));
            }
        }
        this.m_definedSettings.put("ShowTablesIsTempTableColIdx", true);
        variant = this.getOptionalSetting("ShowTablesIsTempTableColIdx", connSettingRequestMap);
        if (null != variant) {
            try {
                n = variant.getInt();
                this.m_settings.m_isTemporaryColIndex = 0 <= n ? n : this.m_settings.m_isTemporaryColIndex;
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SHOW_TABLES_IS_TEMP_TABLE_COL_IDX.name()));
            }
        }
        this.m_definedSettings.put("RenameJoinColumn", true);
        this.m_settings.m_renameJoinColumn = this.readOptionalBooleanSetting(connSettingRequestMap, "RenameJoinColumn", false, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("GetTablesWithQuery", true);
        this.m_definedSettings.put("GetSchemasWithQuery", true);
        this.m_definedSettings.put("GetColumnsWithQuery", true);
        this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc = this.m_settings.m_getTablesWithQuery || this.m_settings.m_getSchemasWithQuery || this.m_settings.m_getColumnsWithQuery;
        this.m_definedSettings.put("ServerReturnsCorrectNullability", true);
        this.m_settings.m_isServerReturnsCorrectNullability = this.readOptionalBooleanSetting(connSettingRequestMap, "ServerReturnsCorrectNullability", this.m_settings.m_platformVersionUtils.supportsGetColumnsAPINullability(this.m_settings.m_serverVersion), HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("CteReturnsQueryResultSet", true);
        this.m_settings.m_cteQueryResultSet = this.readOptionalBooleanSetting(connSettingRequestMap, "CteReturnsQueryResultSet", this.m_settings.m_cteQueryResultSet, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("SetKeyValueQueryResultSet", true);
        this.m_settings.m_setKeyValueQueryResultSet = this.readOptionalBooleanSetting(connSettingRequestMap, "SetKeyValueQueryResultSet", this.m_settings.m_setKeyValueQueryResultSet, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        if (this.m_hiveClient.isArrowEnabled()) {
            boolean bl = true;
            this.m_definedSettings.put("ArrowNettyReflectionProperty", true);
            variant = this.getOptionalSetting("ArrowNettyReflectionProperty", connSettingRequestMap);
            if (null != variant) {
                bl = this.readOptionalBooleanSetting(connSettingRequestMap, "ArrowNettyReflectionProperty", bl, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
            } else {
                try {
                    bl = this.parseJavaMajorVersion() > 8;
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            if (bl) {
                System.setProperty("com.databricks.client.jdbc42.internal.io.netty.tryReflectionSetAccessible", "true");
            }
        }
        this.m_definedSettings.put("ConvertUnionToUnionAll", true);
        this.m_settings.m_convertUnionToUnionAll = this.readOptionalBooleanSetting(connSettingRequestMap, "ConvertUnionToUnionAll", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("SupportsDefaultOrderBy", true);
        this.m_settings.m_supportsDefaultOrderBy = this.readOptionalBooleanSetting(connSettingRequestMap, "SupportsDefaultOrderBy", this.m_settings.m_platformVersionUtils.hqlSupportsDefaultOrderBy(this.m_settings.m_serverVersion), HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("EnableDMLResult", true);
        this.m_settings.m_supportsDMLResults = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableDMLResult", this.m_settings.m_platformVersionUtils.supportsDMLResults(), HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("SupportsNumModifiedRows", true);
        this.m_settings.m_supportsNumRowsModified = this.readOptionalBooleanSetting(connSettingRequestMap, "SupportsNumModifiedRows", this.m_settings.m_supportsNumRowsModified, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("UnrecognizedStmtReturnsQueryResult", true);
        this.m_settings.m_unrecognizedStmtReturnsQueryResult = this.readOptionalBooleanSetting(connSettingRequestMap, "UnrecognizedStmtReturnsQueryResult", this.m_settings.m_unrecognizedStmtReturnsQueryResult, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("DataConversionInFetchThread", true);
        this.m_settings.m_dataConversionInFetchThread = this.readOptionalBooleanSetting(connSettingRequestMap, "DataConversionInFetchThread", this.m_settings.m_dataConversionInFetchThread, HiveJDBCMessageKey.CONN_CONF_ERROR);
        if (this.m_settings.m_applySSPWithQueries) {
            this.setServersidePropertiesWithQuery(connSettingRequestMap);
        }
    }

    protected abstract String getConnectionLogFileName();

    protected abstract ProductInfoHandler getProductInfoHandler();

    protected boolean isAuthMechValid(HiveJDBCSettings hiveJDBCSettings) {
        switch (hiveJDBCSettings.m_transportMode) {
            case BINARY: {
                return AuthMech.NOAUTH == hiveJDBCSettings.m_authMech || AuthMech.UIDPWD == hiveJDBCSettings.m_authMech;
            }
            case SASL: {
                return AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech || AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech || AuthMech.UIDPWD == hiveJDBCSettings.m_authMech;
            }
            case HTTP: {
                return this.m_settings.m_platformVersionUtils.supportsHttp(hiveJDBCSettings.m_authMech);
            }
        }
        return false;
    }

    protected boolean readOptionalBooleanSetting(ConnSettingRequestMap connSettingRequestMap, String string, boolean bl, HiveJDBCMessageKey hiveJDBCMessageKey) {
        boolean bl2 = bl;
        Variant variant = this.getOptionalSetting(string, connSettingRequestMap);
        if (null != variant) {
            try {
                int n = variant.getInt();
                if (n == 1) {
                    return true;
                }
                if (n == 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != this.getWarningListener()) {
                if (HiveJDBCMessageKey.CONN_CONF_ERROR == hiveJDBCMessageKey) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, hiveJDBCMessageKey.name(), new String[]{string, variant.getString(), "0 or 1"}));
                } else if (HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR == hiveJDBCMessageKey) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, hiveJDBCMessageKey.name(), new String[]{variant.getString(), string, String.valueOf(bl)}));
                }
            }
        }
        return bl2;
    }

    protected boolean[] readOptionalBooleanIfSet(ConnSettingRequestMap connSettingRequestMap, String string, boolean bl, HiveJDBCMessageKey hiveJDBCMessageKey) {
        Variant variant = this.getOptionalSetting(string, connSettingRequestMap);
        if (null != variant) {
            try {
                int n = variant.getInt();
                if (n == 1) {
                    return new boolean[]{true, true};
                }
                if (n == 0) {
                    return new boolean[]{true, false};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != this.getWarningListener()) {
                if (HiveJDBCMessageKey.CONN_CONF_ERROR == hiveJDBCMessageKey) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, hiveJDBCMessageKey.name(), new String[]{string, variant.getString(), "0 or 1"}));
                } else if (HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR == hiveJDBCMessageKey) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, hiveJDBCMessageKey.name(), new String[]{variant.getString(), string, String.valueOf(bl)}));
                }
            }
        }
        return new boolean[]{false, bl};
    }

    protected int readOptionalIntegerSetting(ConnSettingRequestMap connSettingRequestMap, String string, int n) {
        return HiveCommonConnectionUtils.readOptionalIntegerSetting(connSettingRequestMap, string, n, this.getConnectionLog(), this.getWarningListener());
    }

    protected int readOptionalPositiveIntegerSetting(ConnSettingRequestMap connSettingRequestMap, String string, int n) {
        return HiveCommonConnectionUtils.readOptionalPositiveIntegerSetting(connSettingRequestMap, string, n, this.getConnectionLog(), this.getWarningListener());
    }

    protected String readOptionalStringSetting(ConnSettingRequestMap connSettingRequestMap, String string, String string2) {
        String string3 = string2;
        Variant variant = this.getOptionalSetting(string, connSettingRequestMap);
        if (variant != null) {
            string3 = variant.getString();
        }
        return string3;
    }

    protected void readServiceDiscoverySettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        String string = null;
        Variant variant = this.getOptionalSetting("ServiceDiscoveryMode", connSettingRequestMap);
        if (null != variant) {
            string = variant.getString();
        }
        if (null != string && string.equalsIgnoreCase(ServiceDiscoveryMode.NO_SERVICE_DISCOVERY.name())) {
            Variant variant2 = this.getRequiredSetting("Host", connSettingRequestMap);
            this.setNoServiceDiscovery(connSettingRequestMap, variant2);
        } else {
            boolean bl = this.readServiceDiscoverySettings(string, connSettingRequestMap);
            if (!bl) {
                Variant variant3 = this.getRequiredSetting("Host", connSettingRequestMap);
                this.setNoServiceDiscovery(connSettingRequestMap, variant3);
            }
        }
    }

    protected boolean readServiceDiscoverySettings(String string, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        return false;
    }

    protected void readDriverSpecificSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    protected void setDefaultProperties() throws ErrorException {
        String string = null;
        if (DSIDriverSingleton.getInstance() instanceof HiveJDBCCommonDriver) {
            string = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName();
        }
        try {
            this.setProperty(101, new Variant(0, "DatabricksJDBC"));
            this.setProperty(139, new Variant(0, "User"));
            this.setProperty(22, new Variant(0, string));
            this.setProperty(58, new Variant(0, "`"));
            this.setProperty(66, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(68, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(76, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(81, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(83, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(80, new Variant(0, "N"));
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DEFAULT_PROP_SETTING_ERR.name(), exception.getMessage());
        }
    }

    protected abstract void setDefaultPort();

    protected abstract void setImplementationDefaultSettings();

    protected abstract void setSupportedHttpRetryType();

    private void validateLicenseFile() throws ErrorException {
        try {
            this.getProductInfoHandler().validateLicense();
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                if (HiveJDBCMessageKey.LICENSE_FILE_LOCATION_ERROR.name().equals(exception.getLocalizedMessage())) {
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_FILE_LOCATION_ERROR.name(), ((ErrorException)exception).getMessageParams());
                }
                if (HiveJDBCMessageKey.LICENSE_FILE_READ_ERROR.name().equals(exception.getLocalizedMessage())) {
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_FILE_READ_ERROR.name(), ((ErrorException)exception).getMessageParams());
                }
                if (HiveJDBCMessageKey.LICENSE_VALIDATION_ERROR.name().equals(exception.getLocalizedMessage())) {
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_VALIDATION_ERROR.name(), ((ErrorException)exception).getMessageParams());
                }
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_VALIDATION_ERROR.name());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private int parseJavaMajorVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            return Integer.parseInt(string.substring(2, 3));
        }
        return Integer.parseInt(string.substring(0, string.indexOf(".")));
    }

    private void parseNonRowcountQueryPrefixes(String string) {
        String[] stringArray;
        if (null == string || string.isEmpty()) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            string2 = string2.trim();
            string2 = string2.toUpperCase();
            this.m_settings.m_nonRowcountQueryPrefixes.add(string2);
        }
    }

    private void setOAuthConfig(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, Variant variant) throws ErrorException {
        if (AuthMech.OAUTH_2 != this.m_settings.m_authMech || this.m_settings.m_oAuthSettings == null) {
            return;
        }
        String string = this.m_settings.m_host;
        String string2 = "https://" + this.m_settings.m_host + "/oidc/oauth2/v2.0/token";
        String string3 = "https://" + this.m_settings.m_host + "/oidc/oauth2/v2.0/authorize";
        this.m_definedSettings.put("EnableOAuthConfigValueTest", true);
        this.m_settings.m_oAuthSettings.m_Oauth2ConfigValueTest = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableOAuthConfigValueTest", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("EnableOIDCDiscovery", true);
        this.m_settings.m_oAuthSettings.m_EnableOIDCDiscovery = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableOIDCDiscovery", true, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("OIDCDiscoveryEndpoint", true);
        this.m_settings.m_oAuthSettings.m_OIDCDiscoveryEndpoint = this.readOptionalStringSetting(connSettingRequestMap, "OIDCDiscoveryEndpoint", NO_PROP_KEY_PREFIX);
        this.m_definedSettings.put("EnableTokenCache", true);
        this.m_settings.m_enableTokenCache = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableTokenCache", this.m_settings.m_enableTokenCache, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("OAuth2RedirectUrlPort", true);
        HiveCommonConnectionUtils.readPortRetrySettings(this.m_settings, connSettingRequestMap, 8020, this.m_log);
        this.m_definedSettings.put("OAuthEnabledIPAddressRanges", true);
        HiveCommonConnectionUtils.readEnableOAuthIPRangeSettings(this.m_settings, connSettingRequestMap, this.m_log);
        this.m_definedSettings.put("OAuthEmulatePortException", true);
        this.m_settings.m_oAuthSettings.m_OAuthEmulatePortException = this.readOptionalBooleanSetting(connSettingRequestMap, "OAuthEmulatePortException", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("OAuthBrowserSocketTimeout", true);
        this.m_settings.m_oAuthSettings.m_OAuthBrowserSocketTimeout = this.readOptionalIntegerSetting(connSettingRequestMap, "OAuthBrowserSocketTimeout", 60);
        this.m_definedSettings.put("OAuth2ConnAuthAuthorizeEndpoint", true);
        String string4 = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2ConnAuthAuthorizeEndpoint", string3);
        this.m_definedSettings.put("OAuth2AuthorizationEndPoint", true);
        string4 = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2AuthorizationEndPoint", string4);
        if (!string4.equals(string3) || this.m_settings.m_oAuthSettings.m_Oauth2AuthorizeEndpoint == null) {
            this.m_settings.m_oAuthSettings.m_Oauth2AuthorizeEndpoint = string4;
        }
        this.m_definedSettings.put("OAuth2ConnAuthTokenEndpoint", true);
        String string5 = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2ConnAuthTokenEndpoint", string2);
        this.m_definedSettings.put("OAuth2TokenEndPoint", true);
        string5 = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2TokenEndPoint", string5);
        if (!string5.equals(string2) || this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpoint == null) {
            this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpoint = string5;
        }
        if (OAuthFlow.BROWSER == this.m_settings.m_oAuthSettings.m_authFlow && this.m_settings.m_enableTokenCache.booleanValue()) {
            this.m_definedSettings.put("TokenCachePassPhrase", true);
            variant = this.getRequiredSetting("TokenCachePassPhrase", connSettingRequestMap);
            this.m_settings.m_tokenCachePassphrase = variant.getString();
        }
        this.m_definedSettings.put("OAuthWebServerTimeoutTakesPrecedence", true);
        this.m_settings.m_oAuthSettings.m_OAuthWebServerTimeoutTakesPrecedence = this.readOptionalBooleanSetting(connSettingRequestMap, "OAuthWebServerTimeoutTakesPrecedence", this.m_settings.m_oAuthSettings.m_OAuthWebServerTimeoutTakesPrecedence, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("OAuth2ConnAuthCodeChallengeMethodKey", true);
        this.m_settings.m_oAuthSettings.m_OAuth2CodeChallengeMethod = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2ConnAuthCodeChallengeMethodKey", "S256");
        this.m_definedSettings.put("OAuthWebServerTimeout", true);
        this.m_settings.m_oAuthSettings.m_OAuthWebServerTimeout = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "OAuthWebServerTimeout", 60);
        this.m_definedSettings.put("OAuth2ClientId", true);
        this.m_settings.m_oAuthSettings.m_authClientID = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2ClientId", "databricks-sql-jdbc");
        this.m_definedSettings.put("OAuth2Secret", true);
        this.m_settings.m_oAuthSettings.m_authClientSecret = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2Secret", this.m_settings.m_oAuthSettings.m_authClientSecret);
        this.m_definedSettings.put("Auth_RefreshToken", true);
        this.m_settings.m_oAuthSettings.m_refreshToken = this.readOptionalStringSetting(connSettingRequestMap, "Auth_RefreshToken", this.m_settings.m_oAuthSettings.m_refreshToken);
        this.m_definedSettings.put("azure_workspace_resource_id", true);
        this.m_settings.m_oAuthSettings.m_azureResourceId = this.readOptionalStringSetting(connSettingRequestMap, "azure_workspace_resource_id", this.m_settings.m_oAuthSettings.m_azureResourceId);
        this.m_settings.m_oAuthSettings.m_enableMandatoryTokenExchange = DATABRICKS_SUBPROTOCAL_NAME == null || DATABRICKS_SUBPROTOCAL_NAME.toLowerCase().equals(DATABRICKS_SUBPROTOCAL_NAME) || DATABRICKS_SUBPROTOCAL_NAME.toLowerCase().equals(SPARK_SUBPROTOCAL_NAME);
        this.m_definedSettings.put("EnableMandatoryTokenExchange", true);
        this.m_settings.m_oAuthSettings.m_enableMandatoryTokenExchange = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableMandatoryTokenExchange", this.m_settings.m_oAuthSettings.m_enableMandatoryTokenExchange, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("Identity_Federation_Client_Id", true);
        this.m_settings.m_oAuthSettings.m_IdentityFederationClientId = this.readOptionalStringSetting(connSettingRequestMap, "Identity_Federation_Client_Id", this.m_settings.m_oAuthSettings.m_IdentityFederationClientId);
        OAuthFlow oAuthFlow = this.m_settings.m_oAuthSettings.m_authFlow;
        if (oAuthFlow == OAuthFlow.BROWSER || oAuthFlow == OAuthFlow.CLIENT_CREDENTIALS) {
            this.m_definedSettings.put("UseJWTAssertion", true);
            this.m_settings.m_oAuthSettings.m_OAuthUseJWTAssertion = this.readOptionalBooleanSetting(connSettingRequestMap, "UseJWTAssertion", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
            this.m_definedSettings.put("Auth_KID", true);
            this.m_settings.m_oAuthSettings.m_OAuth2KeyID = this.readOptionalStringSetting(connSettingRequestMap, "Auth_KID", NO_PROP_KEY_PREFIX);
            this.m_definedSettings.put("Auth_JWT_Key_File", true);
            this.m_settings.m_oAuthSettings.m_OAuth2KeyFilePath = this.readOptionalStringSetting(connSettingRequestMap, "Auth_JWT_Key_File", NO_PROP_KEY_PREFIX);
            this.m_definedSettings.put("Auth_JWT_Alg", true);
            this.m_settings.m_oAuthSettings.m_OAuthJWTAssertionAlgorithm = this.readOptionalStringSetting(connSettingRequestMap, "Auth_JWT_Alg", null);
            this.m_definedSettings.put("Auth_JWT_Key_Passphrase", true);
            this.m_settings.m_oAuthSettings.m_OAuth2KeyPassphrase = this.readOptionalStringSetting(connSettingRequestMap, "Auth_JWT_Key_Passphrase", null);
            String string6 = "sql offline_access";
            if (OAuthUtil.IsUrlAzureCloud(string)) {
                this.m_settings.m_oAuthSettings.m_authSource = OAuthSettings.OAuthSource.AZURE;
                if (this.m_settings.m_oAuthSettings.m_authFlow == OAuthFlow.BROWSER && !this.m_settings.m_oAuthSettings.m_authClientID.equals("databricks-sql-jdbc")) {
                    string6 = "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d/user_impersonation offline_access";
                } else if (this.m_settings.m_oAuthSettings.m_authFlow == OAuthFlow.CLIENT_CREDENTIALS) {
                    string6 = "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d/.default";
                }
            } else if (OAuthUtil.IsUrlAWS_GCP(string)) {
                this.m_settings.m_oAuthSettings.m_authSource = OAuthSettings.OAuthSource.AWS;
                if (this.m_settings.m_oAuthSettings.m_authFlow == OAuthFlow.CLIENT_CREDENTIALS) {
                    string6 = "sql";
                }
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.NOT_SUPPORTED_ON_NON_AWS_AZURE_GCP_PLATFORMS);
                throw errorException;
            }
            this.m_definedSettings.put("OAuth2ConnAuthAuthscopeKey", true);
            this.m_settings.m_oAuthSettings.m_authScope = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2ConnAuthAuthscopeKey", string6);
        }
    }

    private boolean checkHostConnectionMatch(String string, int n, String string2) {
        return string.length() > n && string.substring(string.length() - n, string.length()).equals(string2);
    }

    private void rectifyAuthMech(HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        if (AuthMech.NOAUTH_SSL == this.m_settings.m_authMech) {
            this.m_settings.m_authMech = AuthMech.NOAUTH;
            this.m_settings.m_transportMode = TransportMode.BINARY;
            this.m_settings.m_forceSSL = true;
        } else if (AuthMech.SASL_PLAIN_UIDPWD_SSL == this.m_settings.m_authMech) {
            this.m_settings.m_authMech = AuthMech.UIDPWD;
            this.m_settings.m_transportMode = TransportMode.SASL;
            this.m_settings.m_forceSSL = true;
        } else if (AuthMech.OAUTH_CLIENT_CREDENTIALS == this.m_settings.m_authMech) {
            this.m_settings.m_authMech = AuthMech.OAUTH_2;
            this.m_settings.m_oAuthSettings = new OAuthSettings();
            this.m_settings.m_oAuthSettings.m_authFlow = OAuthFlow.CLIENT_CREDENTIALS;
        }
        if (AuthMech.OAUTH_2 == this.m_settings.m_authMech) {
            this.m_settings.m_thriftHTTPSettings.m_throwDifferentExceptionOnRedirect = true;
            if (!this.m_settings.m_platformVersionUtils.supportsAuthMech(this.m_settings.m_authMech)) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), "OAuth authentication is not supported for " + this.m_settings.m_dbmsName);
                throw errorException;
            }
        }
        if (AuthMech.SAML_2_0 == this.m_settings.m_authMech) {
            this.m_settings.m_thriftHTTPSettings.m_throwDifferentExceptionOnRedirect = true;
            if (!this.m_settings.m_platformVersionUtils.supportsAuthMech(this.m_settings.m_authMech)) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), this.m_settings.m_authMech.getDisplayName() + " authentication is not supported for " + this.m_settings.m_dbmsName);
                throw errorException;
            }
            if (TransportMode.HTTP != this.m_settings.m_transportMode) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INVALID_TRANSPORT_MODE_FOR_AUTH_MECH.name(), new String[]{this.m_settings.m_authMech.getDisplayName(), TransportMode.HTTP.name()});
                throw errorException;
            }
        }
        if (AuthMech.JWT == this.m_settings.m_authMech && TransportMode.HTTP != this.m_settings.m_transportMode) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INVALID_TRANSPORT_MODE_FOR_AUTH_MECH.name(), new String[]{this.m_settings.m_authMech.getDisplayName(), TransportMode.HTTP.name()});
            throw errorException;
        }
        if (TransportMode.HTTP == this.m_settings.m_transportMode && !this.m_settings.m_platformVersionUtils.supportsHttp(this.m_settings.m_authMech)) {
            if (null != this.getWarningListener()) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), new String[]{this.m_settings.m_authMech.toString()}));
            }
            this.m_settings.m_authMech = AuthMech.UIDPWD;
            this.m_authMechSpecifiedByUser = false;
            if (null != this.getWarningListener()) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
            }
        }
        if (this.m_transportModeSpecifiedByUser) {
            if (!this.isAuthMechValid(this.m_settings)) {
                this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                this.m_authMechSpecifiedByUser = false;
                if (null != this.getWarningListener()) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                }
            }
        } else if (AuthMech.NOAUTH == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech && !this.m_useSasl) {
            this.m_settings.m_transportMode = TransportMode.BINARY;
        }
    }

    private void setCustomHTTPHeaders(ConnSettingRequestMap connSettingRequestMap) {
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        int n = "http.header.".length();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.startsWith("http.header.")) continue;
            this.m_settings.m_thriftHTTPSettings.addCustomHeader(string.substring(n), connSettingRequestMap.getProperty(string).getString());
        }
    }

    private void setDefinedSettings() {
        this.m_definedSettings.put("Port", true);
        this.m_definedSettings.put("DisableTranslatedToOriginalQueryFallback", true);
        this.m_definedSettings.put("ShowTablesTableNameColIdx", true);
        this.m_definedSettings.put("ShowTablesIsTempTableColIdx", true);
        this.m_definedSettings.put("RenameJoinColumn", true);
        this.m_definedSettings.put("GetTablesWithQuery", true);
        this.m_definedSettings.put("GetSchemasWithQuery", true);
        this.m_definedSettings.put("GetColumnsWithQuery", true);
        this.m_definedSettings.put("ServerReturnsCorrectNullability", true);
        this.m_definedSettings.put("CteReturnsQueryResultSet", true);
        this.m_definedSettings.put("SetKeyValueQueryResultSet", true);
        this.m_definedSettings.put("ArrowNettyReflectionProperty", true);
        this.m_definedSettings.put("ConvertUnionToUnionAll", true);
        this.m_definedSettings.put("SupportsDefaultOrderBy", true);
        this.m_definedSettings.put("EnableDMLResult", true);
        this.m_definedSettings.put("SupportsNumModifiedRows", true);
        this.m_definedSettings.put("UnrecognizedStmtReturnsQueryResult", true);
        this.m_definedSettings.put("LoginTimeout", true);
    }

    protected void setNoServiceDiscovery(ConnSettingRequestMap connSettingRequestMap, Variant variant) throws ErrorException {
        this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.NO_SERVICE_DISCOVERY;
        this.m_settings.m_host = variant.getString();
        Variant variant2 = this.isPortRequired() ? this.getRequiredSetting("Port", connSettingRequestMap) : this.getOptionalSetting("Port", connSettingRequestMap);
        this.m_definedSettings.put("Port", true);
        Variant variant3 = this.getRequiredSetting("HiveServerType", connSettingRequestMap);
        try {
            this.m_settings.m_port = variant2.getInt();
            if (1 == variant3.getInt()) {
                this.m_settings.m_hiveServerType = HiveServerType.HiveServer1;
            } else if (2 == variant3.getInt()) {
                this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
            }
            this.m_definedSettings.put("HiveServerType", true);
        }
        catch (Exception exception) {
            if (!this.isPortRequired()) {
                this.setDefaultPort();
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HIVESERVERTYPE_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private void setServersidePropertiesWithQuery(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        LogUtilities.logDebug(this.m_settings.m_sspValues.toString(), (ILogger)this.m_log);
        if (null == this.m_settings.m_sspValues && !this.m_settings.m_sspValues.isEmpty() && this.m_settings.m_testSensitiveDataInSsp.booleanValue()) {
            this.testSensitiveDataInSsp(this.m_settings.m_sspValues);
        }
        for (String string : this.m_settings.m_sspValues.keySet()) {
            String string2 = "SET " + string + "=" + this.m_settings.m_sspValues.get(string);
            try {
                this.m_hiveClient.executeUpdate(string2, null);
            }
            catch (ErrorException errorException) {
                if (this.m_settings.m_enableErrorEmulation.booleanValue() && !this.m_settings.m_testConfigExclusionFromSSP.isEmpty()) {
                    throw errorException;
                }
                if (null == this.getWarningListener()) continue;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, errorException.getMessageKeyOrText(), errorException.getMessageParams()));
            }
        }
    }

    private void setJWTProperties(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException {
        String string;
        block2: {
            try {
                string = this.getRequiredSetting("JWTString", connSettingRequestMap).getString();
            }
            catch (BadAuthException badAuthException) {
                string = System.getenv("JWTString");
                if (null != string) break block2;
                throw badAuthException;
            }
        }
        this.m_definedSettings.put("JWTString", true);
        this.m_settings.m_thriftHTTPSettings.addCustomHeader(JWT_AUTH_HEADER_KEY, JWT_AUTH_HEADER_VALUE_PREFIX + string);
    }

    private void readAOSSSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        if (AuthMech.UIDPWD == this.m_settings.m_AOSS_authMech) {
            Variant variant = this.getOptionalSetting("AOSS_UID", connSettingRequestMap);
            this.m_settings.m_AOSS_username = null != variant ? variant.getString() : this.m_settings.m_username;
            if (null == this.m_settings.m_AOSS_username || 0 == this.m_settings.m_AOSS_username.length()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.REQUIRED_PROP_NOT_FOUND.name(), new String[]{"AOSS_UID"});
                throw errorException;
            }
            Variant variant2 = this.getOptionalSetting("AOSS_PWD", connSettingRequestMap);
            this.m_settings.m_AOSS_password = null != variant2 ? variant2.getString() : this.m_settings.m_password;
            if (null == this.m_settings.m_AOSS_password || 0 == this.m_settings.m_AOSS_password.length()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.REQUIRED_PROP_NOT_FOUND.name(), new String[]{"AOSS_PWD"});
                throw errorException;
            }
        }
        this.m_settings.m_AOSS_SSLSettings = new SSLSettings();
        DSConnectionUtils.readSSLSettings(connSettingRequestMap, this.m_settings.m_serverSSLSettings, this.m_settings.m_AOSS_SSLSettings, false, AOSS_PREFIX, this.getWarningListener());
    }

    private void setOAuthProperties(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        this.m_settings.m_thriftHTTPSettings.m_isOAuth = true;
        if (null == this.m_settings.m_oAuthSettings) {
            this.m_settings.m_oAuthSettings = new OAuthSettings();
        }
        this.m_settings.m_oAuthSettings.m_tokenEndpointSSLSettings = new SSLSettings();
        boolean bl = false;
        this.m_definedSettings.put("UseServerSSLConfigsForOAuthEndPoint", true);
        bl = this.readOptionalBooleanSetting(connSettingRequestMap, "UseServerSSLConfigsForOAuthEndPoint", bl, HiveJDBCMessageKey.CONN_CONF_ERROR);
        if (bl) {
            DSConnectionUtils.readOAuthProperties(connSettingRequestMap, this.m_settings.m_oAuthSettings, this.m_settings.m_serverSSLSettings, this.getWarningListener());
        } else {
            DSConnectionUtils.readOAuthProperties(connSettingRequestMap, this.m_settings.m_oAuthSettings, null, this.getWarningListener());
        }
        if (null == this.m_settings.m_oAuthSettings.m_authFlow) {
            this.m_settings.m_oAuthSettings.m_authFlow = this.m_settings.m_platformVersionUtils.getDefaultOAuthFlow();
        }
        if (OAuthFlow.TOKEN_PASSTHROUGH == this.m_settings.m_oAuthSettings.m_authFlow && null != this.m_settings.m_oAuthSettings.m_accessToken) {
            this.m_settings.m_oAuthSettings.m_maskClientInfoAccessToken = this.readOptionalBooleanSetting(connSettingRequestMap, "MaskAccessTokenClientInfoValue", true, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
            this.setClientInfoProperty(new ClientInfoData("Auth_AccessToken", Integer.MAX_VALUE, this.m_settings.m_oAuthSettings.m_maskClientInfoAccessToken ? MASKED_FIELD_VAL : this.m_settings.m_oAuthSettings.m_accessToken, "OAuth access token"));
        }
        this.m_definedSettings.put("Auth_Flow", true);
        this.m_definedSettings.put("Auth_Client_ID", true);
        this.m_definedSettings.put("Auth_Client_Secret", true);
        this.m_definedSettings.put("Auth_Scope", true);
        this.m_definedSettings.put("AuthorizationUrl", true);
        this.m_definedSettings.put("Auth_AccessToken", true);
        this.m_definedSettings.put("MaskAccessTokenClientInfoValue", true);
        this.addSslPropertiesToDefinedSettings("OAuth_");
    }

    private void addSslPropertiesToDefinedSettings(String string) {
        this.m_definedSettings.put(string + "AllowAllHostNames", true);
        this.m_definedSettings.put(string + "ssl", true);
        this.m_definedSettings.put(string + "CAIssuedCertNamesMismatch", true);
        this.m_definedSettings.put(string + "SSLKeyStore", true);
        this.m_definedSettings.put(string + "SSLKeyStorePwd", true);
        this.m_definedSettings.put(string + "SSLTrustStore", true);
        this.m_definedSettings.put(string + "SSLTrustStorePwd", true);
        this.m_definedSettings.put(string + "AllowSelfSignedCerts", true);
        this.m_definedSettings.put(string + "CAIssuedCertNamesMismatch", true);
        this.m_definedSettings.put(string + "SubjectAlternativeNamesHostNames", true);
        this.m_definedSettings.put(string + "SSLTrustStoreType", true);
        this.m_definedSettings.put(string + "SSLTrustStoreProvider", true);
        this.m_definedSettings.put(string + "SSLKeyStoreType", true);
        this.m_definedSettings.put(string + "SSLKeyStoreProvider", true);
    }

    private void initializeSSPMap(ConnSettingRequestMap connSettingRequestMap) {
        this.m_settings.m_sspValues = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.m_definedSettings.containsKey(string) || this.m_settings.m_nonSSPs.contains(string) || this.keyStartsWithNonSSPPrefix(string) || string.equals("DriverLocale") || string.equals("LogLevel") || string.equals("LogPath") || string.equals("LogNamespace")) continue;
            this.m_settings.m_sspValues.put(string, connSettingRequestMap.getProperty(string).getString());
        }
    }

    private boolean keyStartsWithNonSSPPrefix(String string) {
        for (String string2 : this.m_settings.m_nonSSPPrefixes) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private void testSensitiveDataInSsp(Map<String, String> map) throws ErrorException {
        List<String> list = Arrays.asList(this.m_settings.m_sensitiveKeysInSsp.split(","));
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            String string2 = string.trim();
            if (string2.isEmpty() || !map.containsKey(string2)) continue;
            stringBuffer.append(string2).append(",");
        }
        if (stringBuffer.length() > 0) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SENSITIVE_DATA_IN_SSP_ERROR.name(), stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString());
        }
    }

    private void parseStagingAllowedLocalPaths(String string) {
        String[] stringArray;
        if (null == string || string.isEmpty()) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            string2 = string2.trim();
            this.m_settings.m_stagingAllowedLocalPaths.add(string2);
        }
    }

    private List<String> parseAllowedHttpCodes(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null == string || string.isEmpty()) {
            return arrayList;
        }
        for (String string2 : stringArray = string.split(",")) {
            string2 = string2.trim();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void setClientAppInfo() {
        if (this.m_hiveClient instanceof HS2Client) {
            String string = null;
            string = !StringUtils.isNullOrEmpty(this.m_settings.m_userAgentEntryProperty) ? this.m_settings.m_userAgentEntryProperty : (this.m_clientInfoProperties.get(APPLICATION_NAME) != null && !StringUtils.isNullOrEmpty(((ClientInfoData)this.m_clientInfoProperties.get(APPLICATION_NAME)).getValue()) ? ((ClientInfoData)this.m_clientInfoProperties.get(APPLICATION_NAME)).getValue() : System.getProperty("app.name"));
            ((HS2Client)this.m_hiveClient).getTelemetryManager().setClientAppInfo(string);
        }
    }
}

