/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.dataengine.filters;

import com.databricks.client.dsi.core.interfaces.IEnvironment;
import com.databricks.client.dsi.dataengine.filters.DSIMetadataFilterFactory;
import com.databricks.client.dsi.dataengine.filters.IFilter;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceID;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.dataengine.filters.HiveJDBCFilter;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HiveJDBCMetadataFilterFactory
extends DSIMetadataFilterFactory {
    private HiveJDBCSettings m_settings;

    public HiveJDBCMetadataFilterFactory(HiveJDBCSettings hiveJDBCSettings, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.m_settings = hiveJDBCSettings;
    }

    public HiveJDBCMetadataFilterFactory(HiveJDBCSettings hiveJDBCSettings, boolean bl) {
        this(hiveJDBCSettings, bl, hiveJDBCSettings.m_caseInsensitiveMetadataFilter);
    }

    @Override
    public void createFilters(MetadataSourceID metadataSourceID, List<String> list, String string, String string2, boolean bl, IEnvironment iEnvironment, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        ArrayList<IFilter> arrayList = new ArrayList<IFilter>();
        super.createFilters(metadataSourceID, list, string, string2, bl, iEnvironment, arrayList, map);
        for (IFilter iFilter : arrayList) {
            if (!this.shouldReplaceCatalogFilter(iFilter)) continue;
            list2.add(this.createHiveJDBCFilterFromIFilter(iFilter));
        }
    }

    protected HiveJDBCFilter createHiveJDBCFilterFromIFilter(IFilter iFilter) {
        boolean bl = null != this.m_settings ? this.m_settings.m_acceptEmptyStringAsCatalog : false;
        return new HiveJDBCFilter(iFilter, bl);
    }

    public void setHiveJDBCSettings(HiveJDBCSettings hiveJDBCSettings) {
        this.m_settings = hiveJDBCSettings;
    }

    protected boolean shouldReplaceCatalogFilter(IFilter iFilter) {
        return iFilter.getColumnTag() != MetadataSourceColumnTag.CATALOG_NAME || !this.m_settings.m_enableMultiCatalog;
    }
}

