/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.dataengine.metadata;

import com.databricks.client.dsi.dataengine.filters.IFilter;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.IHiveClient;
import com.databricks.client.hivecommon.core.CoreUtils;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.core.HiveJDBCStatement;
import com.databricks.client.hivecommon.dataengine.filters.HiveJDBCFilter;
import com.databricks.client.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.databricks.client.hivecommon.dataengine.metadata.HiveCommonSchemasMetadataSourceRow;
import com.databricks.client.hivecommon.dataengine.metadata.HiveCommonTablesMetadataSourceRow;
import com.databricks.client.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.utils.WarningsUtils;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetadataUtils {
    public static int CATALOG_PATTERN_IDX = 0;
    public static int SCHEMA_PATTERN_IDX = 1;
    public static int TABLE_PATTERN_IDX = 2;
    public static int COLUMN_PATTERN_IDX = 3;
    public static int FUNCTION_PATTERN_IDX = 2;
    public static final char[] CATALOG_FUNC_WILDCARD_CHARS = new char[]{'_', '%'};
    public static final char CATALOG_FUNC_ESCAPE_CHAR = '\\';

    public static boolean checkForCommunicationLinkFailure(Exception exception) {
        return exception instanceof ErrorException && ((ErrorException)exception).getDiagState() == DiagState.DIAG_COMM_LINK_FAILURE;
    }

    public static String EscapeWildCard(String string, char[] cArray, char c) {
        if (null == string || 0 == string.length() || null == cArray || 0 == cArray.length) {
            return string;
        }
        int n = string.length();
        boolean bl = false;
        String string2 = "";
        for (int i = 0; n > i; ++i) {
            char c2 = string.charAt(i);
            if (!bl) {
                if (c2 == c) {
                    bl = true;
                } else {
                    for (char c3 : cArray) {
                        if (c2 != c3) continue;
                        string2 = string2 + c;
                        break;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
            string2 = string2 + c2;
        }
        return string2;
    }

    public static List<HiveCommonColumnMetadata> GetColumns(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, ArrayList<IFilter> arrayList2, IHiveClient<?> iHiveClient, HiveJDBCSettings hiveJDBCSettings, HiveJDBCStatement hiveJDBCStatement, ILogger iLogger) throws ErrorException {
        Object object;
        ArrayList<HiveCommonColumnMetadata> arrayList3 = null;
        if (hiveJDBCSettings.m_pushdownCatalogFunctionFilters) {
            try {
                arrayList3 = iHiveClient.getColumns(map, arrayList, hiveJDBCStatement);
            }
            catch (Exception exception) {
                if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                    throw (ErrorException)exception;
                }
                if (hiveJDBCSettings.m_enableIsQualifierTypeReturnedTesting) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.TYPE_QUALIFIER_SIZE_ERROR.name(), "Qualified Type Names Error");
                    throw errorException;
                }
                CoreUtils.postWarning(exception, iHiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), iLogger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                HiveJDBCExceptionUtils.logException(exception, iHiveClient.getLogger());
            }
        }
        if (null != arrayList3) {
            return arrayList3;
        }
        arrayList3 = new ArrayList();
        String string = MetadataUtils.UnescapeWildCards(MetadataUtils.GetRestriction(map, MetadataSourceColumnTag.CATALOG_NAME));
        String string2 = MetadataUtils.UnescapeWildCards(MetadataUtils.GetRestriction(map, MetadataSourceColumnTag.SCHEMA_NAME));
        String string3 = MetadataUtils.UnescapeWildCards(MetadataUtils.GetRestriction(map, MetadataSourceColumnTag.TABLE_NAME));
        if (null != string && string.contains("\\") || null != string2 && string2.contains("\\") || null != string3 && string3.contains("\\")) {
            return arrayList3;
        }
        if (hiveJDBCSettings.m_pushdownCatalogFunctionFilters && null != (object = iHiveClient.getTables(map, arrayList, hiveJDBCStatement))) {
            Iterator<HiveCommonTablesMetadataSourceRow> iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                HiveCommonTablesMetadataSourceRow hiveCommonTablesMetadataSourceRow = iterator.next();
                arrayList3.addAll(iHiveClient.getColumns(hiveCommonTablesMetadataSourceRow.getCatalogName(), hiveCommonTablesMetadataSourceRow.getSchemaName(), hiveCommonTablesMetadataSourceRow.getTableName(), hiveJDBCStatement));
            }
            return arrayList3;
        }
        object = null;
        HiveJDBCFilter hiveJDBCFilter = null;
        HiveJDBCFilter hiveJDBCFilter2 = null;
        for (IFilter arrayList4 : arrayList2) {
            switch (arrayList4.getColumnTag()) {
                case CATALOG_NAME: {
                    object = (HiveJDBCFilter)arrayList4;
                    break;
                }
                case SCHEMA_NAME: {
                    hiveJDBCFilter = (HiveJDBCFilter)arrayList4;
                    break;
                }
                case TABLE_NAME: {
                    hiveJDBCFilter2 = (HiveJDBCFilter)arrayList4;
                    break;
                }
            }
        }
        if (!hiveJDBCSettings.m_pushdownCatalogFunctionFilters || null == string2) {
            Iterator<HiveCommonTablesMetadataSourceRow> iterator = new ArrayList();
            if (null != string2) {
                ((ArrayList)((Object)iterator)).add((HiveCommonTablesMetadataSourceRow)((Object)new HiveCommonSchemasMetadataSourceRow(string, string2)));
            } else {
                ((ArrayList)((Object)iterator)).addAll(iHiveClient.getSchemas(map, arrayList, hiveJDBCStatement));
            }
            ArrayList<HiveCommonSchemasMetadataSourceRow> arrayList4 = new ArrayList<HiveCommonSchemasMetadataSourceRow>();
            Iterator iterator2 = ((ArrayList)((Object)iterator)).iterator();
            while (iterator2.hasNext()) {
                HiveCommonSchemasMetadataSourceRow hiveCommonSchemasMetadataSourceRow = (HiveCommonSchemasMetadataSourceRow)iterator2.next();
                if (null != object && !((HiveJDBCFilter)object).filter(hiveCommonSchemasMetadataSourceRow.getCatalogName()) || null != hiveJDBCFilter && !hiveJDBCFilter.filter(hiveCommonSchemasMetadataSourceRow.getSchemaName())) continue;
                arrayList4.add(hiveCommonSchemasMetadataSourceRow);
            }
            for (HiveCommonSchemasMetadataSourceRow hiveCommonSchemasMetadataSourceRow : arrayList4) {
                if (!hiveJDBCSettings.m_pushdownCatalogFunctionFilters || null == string3) {
                    for (HiveCommonTablesMetadataSourceRow hiveCommonTablesMetadataSourceRow : iHiveClient.getTables(hiveCommonSchemasMetadataSourceRow.getCatalogName(), hiveCommonSchemasMetadataSourceRow.getSchemaName())) {
                        if (null != hiveJDBCFilter2 && !hiveJDBCFilter2.filter(hiveCommonTablesMetadataSourceRow.getTableName())) continue;
                        arrayList3.addAll(iHiveClient.getColumns(hiveCommonSchemasMetadataSourceRow.getCatalogName(), hiveCommonSchemasMetadataSourceRow.getSchemaName(), hiveCommonTablesMetadataSourceRow.getTableName(), hiveJDBCStatement));
                    }
                    continue;
                }
                arrayList3.addAll(iHiveClient.getColumns(hiveCommonSchemasMetadataSourceRow.getCatalogName(), hiveCommonSchemasMetadataSourceRow.getSchemaName(), string3, hiveJDBCStatement));
            }
        } else if (string3 == null) {
            for (HiveCommonTablesMetadataSourceRow hiveCommonTablesMetadataSourceRow : iHiveClient.getTables(string, string2)) {
                if (null != hiveJDBCFilter2 && !hiveJDBCFilter2.filter(hiveCommonTablesMetadataSourceRow.getTableName())) continue;
                arrayList3.addAll(iHiveClient.getColumns(string, string2, hiveCommonTablesMetadataSourceRow.getTableName(), hiveJDBCStatement));
            }
        } else {
            arrayList3 = iHiveClient.getColumns(string, string2, string3, hiveJDBCStatement);
        }
        return arrayList3;
    }

    public static String GetRestriction(Map<MetadataSourceColumnTag, String> map, MetadataSourceColumnTag metadataSourceColumnTag) {
        String string = "";
        if (map != null) {
            string = map.get((Object)metadataSourceColumnTag);
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public static int getBufferSize(HiveCommonColumnMetadata hiveCommonColumnMetadata, IHiveClient<?> iHiveClient) {
        TypeMetadata typeMetadata = hiveCommonColumnMetadata.getTypeMetadata();
        if (typeMetadata.getTypeName().contains("ARRAY<") || typeMetadata.getTypeName().contains("STRUCT<") || typeMetadata.getTypeName().contains("MAP<") || typeMetadata.getTypeName().contains("UNIONTYPE<")) {
            return iHiveClient.getStringColumnSize();
        }
        if (typeMetadata.getTypeName().contains("CHAR") && typeMetadata.getType() == 1) {
            if (typeMetadata.getTypeName().contains("(")) {
                String string = typeMetadata.getTypeName();
                int n = Integer.parseInt(string.substring(string.indexOf(40) + 1, string.indexOf(41)).trim());
                return n;
            }
            int n = (int)hiveCommonColumnMetadata.getColumnLength();
            return n;
        }
        if (typeMetadata.getTypeName().contains("VARCHAR") && typeMetadata.getType() == 12) {
            if (typeMetadata.getTypeName().contains("(")) {
                String string = typeMetadata.getTypeName();
                int n = Integer.parseInt(string.substring(string.indexOf(40) + 1, string.indexOf(41)).trim());
                return n;
            }
            int n = (int)hiveCommonColumnMetadata.getColumnLength();
            return n;
        }
        if (typeMetadata.getTypeName().contains("DECIMAL(")) {
            String string = typeMetadata.getTypeName();
            int n = Integer.parseInt(string.substring(string.indexOf(40) + 1, string.indexOf(44)).trim());
            return n;
        }
        if (typeMetadata.getTypeName().contains("STRING") || typeMetadata.getTypeName().trim().equalsIgnoreCase("VARIANT")) {
            return iHiveClient.getStringColumnSize();
        }
        if (typeMetadata.getTypeName().contains("BINARY")) {
            return iHiveClient.getBinaryColumnSize();
        }
        if (typeMetadata.getTypeName().trim().equalsIgnoreCase("VOID")) {
            return 0;
        }
        return TypeUtilities.getSizeInBytes(typeMetadata.getType());
    }

    public static short getNumPrecRadix(TypeMetadata typeMetadata) {
        if (TypeUtilities.isNumberType(typeMetadata.getType())) {
            return 10;
        }
        return 0;
    }

    public static String UnescapeWildCards(String string) {
        if (null != string) {
            string = string.replaceAll("\\\\_", "_");
            string = string.replaceAll("\\\\%", "%");
        }
        return string;
    }
}

