/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.jdbc42;

import com.databricks.client.dsi.dataengine.interfaces.IResultSet;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.hivecommon.api.HiveOperationContext;
import com.databricks.client.hivecommon.dataengine.HiveJDBCResultSet;
import com.databricks.client.jdbc.common.SStatement;
import com.databricks.client.jdbc.jdbc42.S42ForwardResultSet;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class Hive42ForwardResultSet
extends S42ForwardResultSet
implements ResultSet {
    private boolean m_columnMapInitialized = false;
    private HiveOperationContext m_context = ((HiveJDBCResultSet)this.m_resultSet).getContext();

    public Hive42ForwardResultSet(SStatement sStatement, HiveJDBCResultSet hiveJDBCResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, (IResultSet)hiveJDBCResultSet, iLogger);
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkIfValidRowNumber();
        return super.findColumn(string);
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.m_context.m_isExecutionComplete) {
            try {
                this.pollAndInitializeColumns();
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
            }
        }
        if (!this.m_columnMapInitialized) {
            this.initializeColumnNameMap();
            this.m_columnMapInitialized = true;
        }
        return super.next();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (!this.m_context.m_isExecutionComplete) {
            try {
                this.pollAndInitializeColumns();
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
            }
        }
        return super.getMetaData();
    }

    @Override
    protected DataWrapper getData(int n, long l) throws SQLException {
        this.checkIfValidRowNumber();
        return super.getData(n, l);
    }

    @Override
    protected void initializeColumnNameMap() throws SQLException {
        if (this.m_context.m_isExecutionComplete) {
            super.initializeColumnNameMap();
        }
    }

    protected void pollAndInitializeColumns() throws ErrorException, SQLException {
        ((HiveJDBCResultSet)this.m_resultSet).updateSelectColumns();
        this.initializeResultSetColumns();
    }
}

