/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.telemetry;

import com.databricks.client.hivecommon.AuthMech;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.HttpRetrySettings;
import com.databricks.client.hivecommon.telemetry.ClientContext;
import com.databricks.client.hivecommon.telemetry.DriverConnectionParameters;
import com.databricks.client.hivecommon.telemetry.DriverErrorInfo;
import com.databricks.client.hivecommon.telemetry.DriverSystemConfiguration;
import com.databricks.client.hivecommon.telemetry.DriverVolumeOperation;
import com.databricks.client.hivecommon.telemetry.FrontendLog;
import com.databricks.client.hivecommon.telemetry.FrontendLogContext;
import com.databricks.client.hivecommon.telemetry.FrontendLogEntry;
import com.databricks.client.hivecommon.telemetry.SqlDriverEvent;
import com.databricks.client.hivecommon.telemetry.SqlExecutionEvent;
import com.databricks.client.hivecommon.telemetry.TelemetryExecContext;
import com.databricks.client.hivecommon.telemetry.TelemetryLogObject;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.databricks.client.jdbc42.internal.apache.http.Header;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.databricks.client.jdbc42.internal.apache.http.entity.StringEntity;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.databricks.client.jdbc42.internal.apache.http.util.EntityUtils;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.annotation.JsonInclude;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.JsonProcessingException;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.JsonNode;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.node.ArrayNode;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

class TelemetryTask
implements Runnable {
    private static final int TELEMETRY_MAX_RETRIES_TIME = 3;
    private volatile boolean m_isRunning = true;
    private final Object m_runningLock = new Object();
    public LinkedBlockingQueue<FrontendLog> m_queue;
    private String m_useAgent;
    private String m_host;
    private ObjectMapper m_mapper;
    private String m_sessionId;
    private CloseableHttpClient m_httpClient;
    private ArrayList<HttpRetrySettings> m_httpRetrySettingsList;
    private DriverConnectionParameters m_connectionParameters;
    private ILogger m_logger;
    private final Object m_authTokenLock = new Object();
    private int m_telemetryBatchSize;
    private int m_telemetryTimer;
    private String m_authToken;
    private long m_lastLoggingTime;
    private String m_clientAppInfo;

    public TelemetryTask(HiveJDBCSettings hiveJDBCSettings, CloseableHttpClient closeableHttpClient, ILogger iLogger) {
        this.m_logger = iLogger;
        this.m_host = String.format("https://%s/telemetry-ext", hiveJDBCSettings.m_host);
        this.m_useAgent = hiveJDBCSettings.m_thriftHTTPSettings.m_userAgentEntry;
        this.m_telemetryBatchSize = hiveJDBCSettings.m_telemetryBatchSize;
        this.m_telemetryTimer = hiveJDBCSettings.m_telemetryTimer;
        this.m_lastLoggingTime = System.currentTimeMillis();
        this.m_httpClient = closeableHttpClient;
        this.m_httpRetrySettingsList = (ArrayList)hiveJDBCSettings.m_thriftHTTPSettings.m_httpRetrySettingsList.clone();
        this.m_authToken = hiveJDBCSettings.m_authMech == AuthMech.OAUTH_2 ? hiveJDBCSettings.m_oAuthSettings.m_accessToken : hiveJDBCSettings.m_password;
        this.m_mapper = new ObjectMapper();
        this.m_mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.m_queue = new LinkedBlockingQueue();
        this.m_connectionParameters = new DriverConnectionParameters(hiveJDBCSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Object object = this.m_runningLock;
                    synchronized (object) {
                        if (!this.m_isRunning) {
                            return;
                        }
                    }
                    Thread.sleep(1000L);
                    if (this.m_queue.size() < this.m_telemetryBatchSize && System.currentTimeMillis() - this.m_lastLoggingTime <= (long)this.m_telemetryTimer) continue;
                    this.createlogAndSendRequest();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private synchronized void createlogAndSendRequest() {
        if (this.m_queue.peek() != null) {
            try {
                TelemetryLogObject telemetryLogObject = new TelemetryLogObject();
                while (this.m_queue.peek() != null && telemetryLogObject.protoLogs.size() <= this.m_telemetryBatchSize) {
                    FrontendLog frontendLog = this.m_queue.take();
                    telemetryLogObject.protoLogs.add(this.m_mapper.writeValueAsString(frontendLog));
                }
                telemetryLogObject.uploadTime = System.currentTimeMillis();
                this.executeTelemetryRequest(telemetryLogObject);
            }
            catch (JsonProcessingException | InterruptedException exception) {
                LogUtilities.logError(exception.getMessage(), this.m_logger);
            }
        }
    }

    public synchronized FrontendLog createFrontendLog(String string, long l, String string2, boolean bl, TelemetryExecContext telemetryExecContext) {
        SqlDriverEvent sqlDriverEvent = new SqlDriverEvent();
        sqlDriverEvent.session_id = this.m_sessionId;
        sqlDriverEvent.sql_statement_id = string;
        sqlDriverEvent.operation_latency_ms = l;
        sqlDriverEvent.sql_operation = new SqlExecutionEvent(string2, bl, telemetryExecContext.m_rowSetType, 0L, telemetryExecContext.m_retriedCounter);
        if (telemetryExecContext.m_volume_operation_type != null) {
            sqlDriverEvent.vol_operation = new DriverVolumeOperation(telemetryExecContext.m_volume_operation_type, telemetryExecContext.m_volume_path);
        }
        sqlDriverEvent.system_configuration = new DriverSystemConfiguration(this.m_logger, this.m_clientAppInfo);
        sqlDriverEvent.driver_connection_params = this.m_connectionParameters;
        FrontendLogEntry frontendLogEntry = new FrontendLogEntry();
        frontendLogEntry.sql_driver_log = sqlDriverEvent;
        FrontendLog frontendLog = new FrontendLog();
        frontendLog.frontend_log_event_id = UUID.randomUUID().toString();
        frontendLog.context = this.CreateFrontendLogContextObj();
        frontendLog.entry = frontendLogEntry;
        return frontendLog;
    }

    public synchronized FrontendLog createFrontendLog(String string, long l) {
        SqlDriverEvent sqlDriverEvent = new SqlDriverEvent();
        sqlDriverEvent.session_id = this.m_sessionId;
        sqlDriverEvent.sql_statement_id = string;
        sqlDriverEvent.operation_latency_ms = l;
        sqlDriverEvent.system_configuration = new DriverSystemConfiguration(this.m_logger, this.m_clientAppInfo);
        sqlDriverEvent.driver_connection_params = this.m_connectionParameters;
        FrontendLogEntry frontendLogEntry = new FrontendLogEntry();
        frontendLogEntry.sql_driver_log = sqlDriverEvent;
        FrontendLog frontendLog = new FrontendLog();
        frontendLog.frontend_log_event_id = UUID.randomUUID().toString();
        frontendLog.context = this.CreateFrontendLogContextObj();
        frontendLog.entry = frontendLogEntry;
        return frontendLog;
    }

    public synchronized FrontendLog createFrontendLogwithError(String string, String string2, String string3, long l) {
        SqlDriverEvent sqlDriverEvent = new SqlDriverEvent();
        sqlDriverEvent.session_id = this.m_sessionId;
        sqlDriverEvent.sql_statement_id = string;
        sqlDriverEvent.operation_latency_ms = l;
        sqlDriverEvent.error_info = new DriverErrorInfo(string2, string3);
        sqlDriverEvent.system_configuration = new DriverSystemConfiguration(this.m_logger, this.m_clientAppInfo);
        sqlDriverEvent.driver_connection_params = this.m_connectionParameters;
        FrontendLogEntry frontendLogEntry = new FrontendLogEntry();
        frontendLogEntry.sql_driver_log = sqlDriverEvent;
        FrontendLog frontendLog = new FrontendLog();
        frontendLog.frontend_log_event_id = UUID.randomUUID().toString();
        frontendLog.context = this.CreateFrontendLogContextObj();
        frontendLog.entry = frontendLogEntry;
        return frontendLog;
    }

    public synchronized void addTelemetryLog(String string, long l) {
        FrontendLog frontendLog = this.createFrontendLog(string, l);
        this.m_queue.add(frontendLog);
    }

    public synchronized void addTelemetryLog(String string, long l, boolean bl, TelemetryExecContext telemetryExecContext) {
        FrontendLog frontendLog = this.createFrontendLog(string, l, "", bl, telemetryExecContext);
        this.m_queue.add(frontendLog);
    }

    public synchronized void addTelemetryLog(String string, long l, String string2, boolean bl, TelemetryExecContext telemetryExecContext) {
        FrontendLog frontendLog = this.createFrontendLog(string, l, string2, bl, telemetryExecContext);
        this.m_queue.add(frontendLog);
    }

    public synchronized void addTelemetryErrorLog(String string, String string2, String string3, long l) {
        FrontendLog frontendLog = this.createFrontendLogwithError(string, string2, string3, l);
        this.m_queue.add(frontendLog);
    }

    public synchronized void setSessionID(String string) {
        this.m_sessionId = string;
    }

    public synchronized void addOpenSessionLog(TOpenSessionResp tOpenSessionResp, long l) {
        if (tOpenSessionResp != null && tOpenSessionResp.getSessionHandle() != null && tOpenSessionResp.getSessionHandle().getSessionId() != null && tOpenSessionResp.getSessionHandle().getSessionId().getGuid() != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(tOpenSessionResp.getSessionHandle().getSessionId().getGuid());
            long l2 = byteBuffer.getLong();
            long l3 = byteBuffer.getLong();
            UUID uUID = new UUID(l2, l3);
            this.m_sessionId = uUID.toString();
        }
        this.addTelemetryLog("Initial Configuration", l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopTelemetry() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_runningLock;
        synchronized (object) {
            this.m_isRunning = false;
        }
        while (this.m_queue.peek() != null) {
            this.createlogAndSendRequest();
        }
    }

    private FrontendLogContext CreateFrontendLogContextObj() {
        ClientContext clientContext = new ClientContext();
        clientContext.timestamp_millis = System.currentTimeMillis();
        clientContext.user_agent = this.m_useAgent;
        FrontendLogContext frontendLogContext = new FrontendLogContext();
        frontendLogContext.client_context = clientContext;
        return frontendLogContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeTelemetryRequest(TelemetryLogObject telemetryLogObject) throws InterruptedException {
        HttpPost httpPost = new HttpPost(this.m_host);
        try {
            String string = this.m_mapper.writeValueAsString(telemetryLogObject);
            StringEntity stringEntity = new StringEntity(string);
            httpPost.setEntity(stringEntity);
            httpPost.setHeader("Content-type", "application/json");
            Object object = this.m_authTokenLock;
            synchronized (object) {
                httpPost.setHeader("Authorization", String.format("Bearer %s", this.m_authToken));
            }
            boolean bl = true;
            int n = 0;
            while (bl) {
                Object object2;
                Object object3;
                CloseableHttpResponse closeableHttpResponse = this.m_httpClient.execute(httpPost);
                Header header = closeableHttpResponse.getFirstHeader("x-request-id");
                if (header != null) {
                    LogUtilities.logInfo(String.format("Telemetry Request Id: %s.", header.getValue()), this.m_logger);
                }
                int n2 = closeableHttpResponse.getStatusLine().getStatusCode();
                bl = false;
                if (n2 == 200) {
                    object3 = EntityUtils.toString(closeableHttpResponse.getEntity());
                    object2 = this.m_mapper.readTree((String)object3);
                    if (((JsonNode)object2).has("numProtoSuccess")) {
                        int n3 = ((JsonNode)object2).get("numProtoSuccess").asInt();
                        if (telemetryLogObject.protoLogs.size() != n3) {
                            LogUtilities.logError(String.format("Telemetry sent %d logs but have %d successeded logs in response", telemetryLogObject.protoLogs.size(), n3), this.m_logger);
                        }
                    }
                    if (((JsonNode)object2).has("errors") && ((JsonNode)object2).get("errors").isArray()) {
                        ArrayNode arrayNode = (ArrayNode)((JsonNode)object2).get("errors");
                        for (int i = 0; i < arrayNode.size(); ++i) {
                            String string2 = arrayNode.get(i).asText();
                            LogUtilities.logError(String.format("Telemetry Error from Response: %s", string2), this.m_logger);
                        }
                    }
                    LogUtilities.logDebug((String)object3, this.m_logger);
                    continue;
                }
                if (n < 3) {
                    object3 = closeableHttpResponse.getFirstHeader("x-databricks-reason-phrase");
                    if (object3 != null) {
                        LogUtilities.logError(String.format("Telemetry Error header: %s.", object3.getValue()), this.m_logger);
                    }
                    object2 = closeableHttpResponse.getFirstHeader("Retry-After");
                    for (HttpRetrySettings httpRetrySettings : this.m_httpRetrySettingsList) {
                        if (!httpRetrySettings.shouldRetryWithHttpCode("Telemetry", "", n2)) continue;
                        bl = true;
                        n = (short)(n + 1);
                        if (object2 == null) {
                            Thread.sleep(n * 1000);
                            break;
                        }
                        int n4 = Integer.valueOf(object2.getValue());
                        Thread.sleep(n4 * 1000);
                        break;
                    }
                    LogUtilities.logError(String.format("Telemetry failed with code %d.", n2), this.m_logger);
                    continue;
                }
                LogUtilities.logError(String.format("Telemetry failed after several retries.", new Object[0]), this.m_logger);
            }
        }
        catch (IOException iOException) {
            LogUtilities.logInfo("Telemetry failed while sending the request.", this.m_logger);
            LogUtilities.logInfo(iOException, this.m_logger);
        }
        finally {
            this.m_lastLoggingTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthToken(String string) {
        Object object = this.m_authTokenLock;
        synchronized (object) {
            this.m_authToken = string;
        }
    }

    public void setClientAppInfo(String string) {
        this.m_clientAppInfo = string;
    }
}

