/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc41.utilities;

import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.jdbc.common.BaseForwardResultSet;
import com.databricks.client.jdbc.common.SArray;
import com.databricks.client.jdbc.interfaces.IndexedJDBCDataSource;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ExceptionType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.IdentityHashMap;
import java.util.Map;

public class ResultSetUtilities {
    private static final Map<Class<?>, Getter<?>> s_objectGetterMap = new IdentityHashMap();

    public static <T> T getObjectByType(BaseForwardResultSet<?, ?> baseForwardResultSet, int n, Class<T> clazz) throws SQLException {
        return ResultSetUtilities.getObjectByType(baseForwardResultSet, baseForwardResultSet.getLogger(), n, clazz);
    }

    public static <T> T getObjectByType(IndexedJDBCDataSource indexedJDBCDataSource, ILogger iLogger, int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(iLogger, n, clazz);
            Getter<?> getter = s_objectGetterMap.get(clazz);
            if (getter == null && SArray.class.isAssignableFrom(clazz)) {
                getter = s_objectGetterMap.get(Array.class);
            }
            if (getter == null) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, indexedJDBCDataSource.getWarningListener(), ExceptionType.NON_TRANSIENT, String.valueOf(n), clazz.getName());
            }
            return clazz.cast(getter.get(indexedJDBCDataSource, n, clazz));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, indexedJDBCDataSource.getWarningListener(), iLogger);
        }
    }

    private static String getjdbc42RSUtilsClassName() {
        String string = ResultSetUtilities.class.getName();
        assert (string.endsWith(".jdbc41.utilities.ResultSetUtilities"));
        int n = string.lastIndexOf(49);
        return string.substring(0, n) + "2" + string.substring(n + 1, string.length());
    }

    static {
        s_objectGetterMap.put(Boolean.class, new Getter<Boolean>(){

            @Override
            public Boolean get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Boolean> clazz) throws SQLException {
                assert (clazz == Boolean.class || clazz == Boolean.TYPE);
                boolean bl = indexedJDBCDataSource.getBoolean(n);
                return indexedJDBCDataSource.wasNull() ? null : Boolean.valueOf(bl);
            }
        });
        s_objectGetterMap.put(Boolean.TYPE, s_objectGetterMap.get(Boolean.class));
        s_objectGetterMap.put(Byte.class, new Getter<Byte>(){

            @Override
            public Byte get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Byte> clazz) throws SQLException {
                assert (clazz == Byte.class || clazz == Byte.TYPE);
                byte by = indexedJDBCDataSource.getByte(n);
                return indexedJDBCDataSource.wasNull() ? null : Byte.valueOf(by);
            }
        });
        s_objectGetterMap.put(Byte.TYPE, s_objectGetterMap.get(Byte.class));
        s_objectGetterMap.put(Short.class, new Getter<Short>(){

            @Override
            public Short get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Short> clazz) throws SQLException {
                assert (clazz == Short.class || clazz == Short.TYPE);
                short s = indexedJDBCDataSource.getShort(n);
                return indexedJDBCDataSource.wasNull() ? null : Short.valueOf(s);
            }
        });
        s_objectGetterMap.put(Short.TYPE, s_objectGetterMap.get(Short.class));
        s_objectGetterMap.put(Integer.class, new Getter<Integer>(){

            @Override
            public Integer get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Integer> clazz) throws SQLException {
                assert (clazz == Integer.class || clazz == Integer.TYPE);
                int n2 = indexedJDBCDataSource.getInt(n);
                return indexedJDBCDataSource.wasNull() ? null : Integer.valueOf(n2);
            }
        });
        s_objectGetterMap.put(Integer.TYPE, s_objectGetterMap.get(Integer.class));
        s_objectGetterMap.put(Long.class, new Getter<Long>(){

            @Override
            public Long get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Long> clazz) throws SQLException {
                assert (clazz == Long.class || clazz == Long.TYPE);
                long l = indexedJDBCDataSource.getLong(n);
                return indexedJDBCDataSource.wasNull() ? null : Long.valueOf(l);
            }
        });
        s_objectGetterMap.put(Long.TYPE, s_objectGetterMap.get(Long.class));
        s_objectGetterMap.put(Float.class, new Getter<Float>(){

            @Override
            public Float get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Float> clazz) throws SQLException {
                assert (clazz == Float.class || clazz == Float.TYPE);
                float f = indexedJDBCDataSource.getFloat(n);
                return indexedJDBCDataSource.wasNull() ? null : Float.valueOf(f);
            }
        });
        s_objectGetterMap.put(Float.TYPE, s_objectGetterMap.get(Float.class));
        s_objectGetterMap.put(Double.class, new Getter<Double>(){

            @Override
            public Double get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Double> clazz) throws SQLException {
                assert (clazz == Double.class || clazz == Double.TYPE);
                double d = indexedJDBCDataSource.getDouble(n);
                return indexedJDBCDataSource.wasNull() ? null : Double.valueOf(d);
            }
        });
        s_objectGetterMap.put(Double.TYPE, s_objectGetterMap.get(Double.class));
        s_objectGetterMap.put(BigInteger.class, new Getter<BigInteger>(){

            @Override
            public BigInteger get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<BigInteger> clazz) throws SQLException {
                assert (clazz == BigInteger.class);
                return indexedJDBCDataSource.getBigDecimal(n).toBigInteger();
            }
        });
        s_objectGetterMap.put(BigDecimal.class, new Getter<BigDecimal>(){

            @Override
            public BigDecimal get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<BigDecimal> clazz) throws SQLException {
                assert (clazz == BigDecimal.class);
                return indexedJDBCDataSource.getBigDecimal(n);
            }
        });
        s_objectGetterMap.put(byte[].class, new Getter<byte[]>(){

            @Override
            public byte[] get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<byte[]> clazz) throws SQLException {
                assert (clazz == byte[].class);
                return indexedJDBCDataSource.getBytes(n);
            }
        });
        s_objectGetterMap.put(String.class, new Getter<String>(){

            @Override
            public String get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<String> clazz) throws SQLException {
                assert (clazz == String.class);
                return indexedJDBCDataSource.getString(n);
            }
        });
        s_objectGetterMap.put(Date.class, new Getter<Date>(){

            @Override
            public Date get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Date> clazz) throws SQLException {
                assert (clazz == Date.class);
                return indexedJDBCDataSource.getDate(n);
            }
        });
        s_objectGetterMap.put(Time.class, new Getter<Time>(){

            @Override
            public Time get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Time> clazz) throws SQLException {
                assert (clazz == Time.class);
                return indexedJDBCDataSource.getTime(n);
            }
        });
        s_objectGetterMap.put(Timestamp.class, new Getter<Timestamp>(){

            @Override
            public Timestamp get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Timestamp> clazz) throws SQLException {
                assert (clazz == Timestamp.class);
                return indexedJDBCDataSource.getTimestamp(n);
            }
        });
        s_objectGetterMap.put(Object.class, new Getter<Object>(){

            @Override
            public Object get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Object> clazz) throws SQLException {
                assert (clazz == Object.class);
                return indexedJDBCDataSource.getObject(n);
            }
        });
        s_objectGetterMap.put(Array.class, new Getter<Array>(){

            @Override
            public Array get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Array> clazz) throws SQLException {
                assert (clazz == Array.class);
                return indexedJDBCDataSource.getArray(n);
            }
        });
        s_objectGetterMap.put(Blob.class, new Getter<Blob>(){

            @Override
            public Blob get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Blob> clazz) throws SQLException {
                assert (clazz == Blob.class);
                return indexedJDBCDataSource.getBlob(n);
            }
        });
        s_objectGetterMap.put(Clob.class, new Getter<Clob>(){

            @Override
            public Clob get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Clob> clazz) throws SQLException {
                assert (clazz == Clob.class);
                return indexedJDBCDataSource.getClob(n);
            }
        });
        Getter<Object> getter = new Getter<Object>(){

            @Override
            public Object get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Object> clazz) throws SQLException {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, indexedJDBCDataSource.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
        };
        s_objectGetterMap.put(Ref.class, getter);
        s_objectGetterMap.put(URL.class, getter);
        s_objectGetterMap.put(NClob.class, getter);
        s_objectGetterMap.put(RowId.class, getter);
        s_objectGetterMap.put(SQLXML.class, getter);
        try {
            Class<?> clazz = ResultSetUtilities.class.getClassLoader().loadClass(ResultSetUtilities.getjdbc42RSUtilsClassName());
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("getGetters", Map.class);
                method.invoke(null, s_objectGetterMap);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static interface Getter<T> {
        public T get(IndexedJDBCDataSource var1, int var2, Class<T> var3) throws SQLException;
    }
}

