/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.rpc;

import com.databricks.client.jdbc.common.CustomNetworkHooksSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.rpc.InternalDnsResolver;
import com.databricks.client.jdbc.utils.rpc.CustomNetworkHooks;
import com.databricks.client.jdbc42.internal.apache.http.conn.DnsResolver;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import com.interfaces.networking.CustomDnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CustomDnsResolverLoader
extends CustomNetworkHooks {
    public static DnsResolver getDnsResolver(CustomNetworkHooksSettings customNetworkHooksSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, customNetworkHooksSettings);
        CustomDnsResolver customDnsResolver = null;
        if (null != customNetworkHooksSettings.m_dnsResolver) {
            Class<CustomDnsResolver> clazz = null;
            try {
                clazz = Class.forName(customNetworkHooksSettings.m_dnsResolver).asSubclass(CustomDnsResolver.class);
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_INVALID_CUSTOM_CLASS.name(), new String[]{customNetworkHooksSettings.m_dnsResolver, exception.getClass().getName()});
                errorException.initCause(exception);
                throw errorException;
            }
            try {
                customDnsResolver = null == customNetworkHooksSettings.m_dnsResolverArg ? clazz.getConstructor(new Class[0]).newInstance(new Object[0]) : clazz.getConstructor(String.class).newInstance(customNetworkHooksSettings.m_dnsResolverArg);
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_INVALID_METHOD.name(), new String[]{customNetworkHooksSettings.m_dnsResolver, exception.getClass().getName(), customNetworkHooksSettings.m_dnsResolverArg});
                errorException.initCause(exception);
                throw errorException;
            }
            return new InternalDnsResolver(customDnsResolver);
        }
        return new InternalDnsResolver(null);
    }

    public static String getResolvedHost(DnsResolver dnsResolver, String string, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dnsResolver, string);
        try {
            InetAddress[] inetAddressArray = dnsResolver.resolve(string);
            if (null != inetAddressArray && inetAddressArray.length > 0) {
                string = inetAddressArray[0].getHostAddress();
            } else {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNKNOWN_HOST_EXCEPTION.name(), new String[]{string, dnsResolver.getClass().getName(), "resolved host is null or has zero elements in it."});
                LogUtilities.logWarning(errorException, iLogger);
            }
        }
        catch (UnknownHostException unknownHostException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNKNOWN_HOST_EXCEPTION.name(), new String[]{string, dnsResolver.getClass().getName(), unknownHostException.getMessage()});
            throw errorException;
        }
        return string;
    }
}

