/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto;

import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSSigner;
import com.databricks.client.jdbc42.internal.nimbusjose.KeyLengthException;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.HMAC;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.MACProvider;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.OctetSequenceKey;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.jcip.ThreadSafe;
import com.databricks.client.jdbc42.internal.nimbusjose.util.Base64URL;
import com.databricks.client.jdbc42.internal.nimbusjose.util.StandardCharset;
import javax.crypto.SecretKey;

@ThreadSafe
public class MACSigner
extends MACProvider
implements JWSSigner {
    public MACSigner(byte[] secret) throws KeyLengthException {
        super(secret);
    }

    public MACSigner(String secretString) throws KeyLengthException {
        this(secretString.getBytes(StandardCharset.UTF_8));
    }

    public MACSigner(SecretKey secretKey) throws KeyLengthException {
        super(secretKey);
    }

    public MACSigner(OctetSequenceKey jwk) throws KeyLengthException {
        this(jwk.toByteArray());
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        this.ensureSecretLengthSatisfiesAlgorithm(header.getAlgorithm());
        String jcaAlg = MACSigner.getJCAAlgorithmName(header.getAlgorithm());
        byte[] hmac = HMAC.compute(jcaAlg, this.getSecretKey(), signingInput, this.getJCAContext().getProvider());
        return Base64URL.encode(hmac);
    }
}

