/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.jwk.source;

import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWKSet;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetSource;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetSourceWrapper;
import com.databricks.client.jdbc42.internal.nimbusjose.proc.SecurityContext;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.jcip.ThreadSafe;
import com.databricks.client.jdbc42.internal.nimbusjose.util.cache.CachedObject;

@ThreadSafe
abstract class AbstractCachingJWKSetSource<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private volatile CachedObject<JWKSet> cachedJWKSet;
    private final long timeToLive;

    AbstractCachingJWKSetSource(JWKSetSource<C> source, long timeToLive) {
        super(source);
        this.timeToLive = timeToLive;
    }

    CachedObject<JWKSet> getCachedJWKSet() {
        return this.cachedJWKSet;
    }

    void setCachedJWKSet(CachedObject<JWKSet> cachedJWKSet) {
        this.cachedJWKSet = cachedJWKSet;
    }

    CachedObject<JWKSet> getCachedJWKSetIfValid(long currentTime) {
        CachedObject<JWKSet> threadSafeCache = this.getCachedJWKSet();
        if (threadSafeCache != null && threadSafeCache.isValid(currentTime)) {
            return threadSafeCache;
        }
        return null;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    CachedObject<JWKSet> cacheJWKSet(JWKSet jwkSet, long fetchTime) {
        long currentTime = this.currentTimeMillis();
        CachedObject<JWKSet> cachedJWKSet = new CachedObject<JWKSet>(jwkSet, currentTime, CachedObject.computeExpirationTime(fetchTime, this.getTimeToLive()));
        this.setCachedJWKSet(cachedJWKSet);
        return cachedJWKSet;
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

