/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.proc;

import com.databricks.client.jdbc42.internal.nimbusjose.JWSAlgorithm;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.proc.JWSKeySelector;
import com.databricks.client.jdbc42.internal.nimbusjose.proc.SecurityContext;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SingleKeyJWSKeySelector<C extends SecurityContext>
implements JWSKeySelector<C> {
    private final List<Key> singletonKeyList;
    private final JWSAlgorithm expectedJWSAlg;

    public SingleKeyJWSKeySelector(JWSAlgorithm expectedJWSAlg, Key key) {
        this.singletonKeyList = Collections.singletonList(Objects.requireNonNull(key));
        this.expectedJWSAlg = Objects.requireNonNull(expectedJWSAlg);
    }

    @Override
    public List<? extends Key> selectJWSKeys(JWSHeader header, C context) {
        if (!this.expectedJWSAlg.equals(header.getAlgorithm())) {
            return Collections.emptyList();
        }
        return this.singletonKeyList;
    }
}

