/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aetree.relation;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEWithClause;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public final class AECommonTableExpr
extends AENamedRelationalExpr {
    private AEWithClause.CTERef m_cteRef;
    private final boolean[] m_dataNeeded;

    public AECommonTableExpr(AEWithClause.CTERef cTERef) {
        this.m_cteRef = Objects.requireNonNull(cTERef);
        this.m_dataNeeded = new boolean[this.getColumnCount()];
    }

    private AECommonTableExpr(AECommonTableExpr aECommonTableExpr) {
        super(aECommonTableExpr);
        this.m_cteRef = aECommonTableExpr.m_cteRef;
        this.m_dataNeeded = (boolean[])aECommonTableExpr.m_dataNeeded.clone();
    }

    public AENamedRelationalExpr GetCommonTableExpression() {
        return this.m_cteRef.getCommonTableExpression();
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return Collections.emptyIterator();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        return iAENode instanceof AECommonTableExpr && this.m_cteRef.isEquivalent(((AECommonTableExpr)iAENode).m_cteRef);
    }

    @Override
    public String getCatalogName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.GetCommonTableExpression().getCatalogName();
    }

    @Override
    public String getSchemaName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.GetCommonTableExpression().getSchemaName();
    }

    @Override
    public String getTableName() {
        if (this.hasCorrelationName()) {
            return this.getCorrelationName();
        }
        return this.GetCommonTableExpression().getTableName();
    }

    @Override
    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("AECommonTableExpr: ");
        stringBuilder.append(this.GetCommonTableExpression().getTableName());
        if (this.hasCorrelationName()) {
            stringBuilder.append(" AS ").append(this.getCorrelationName());
        }
        stringBuilder.append(" (Scope=");
        stringBuilder.append(this.m_cteRef.getScopeIdentifier());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public IColumn getBaseColumn(int n) {
        return this.GetCommonTableExpression().getColumn(n);
    }

    @Override
    public AECommonTableExpr copy() {
        return new AECommonTableExpr(this);
    }

    @Override
    public int getColumnCount() {
        return this.GetCommonTableExpression().getColumnCount();
    }

    @Override
    public boolean getDataNeeded(int n) {
        return this.m_dataNeeded[n];
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        if (aERelationalExpr.equals(this)) {
            this.m_dataNeeded[n] = true;
            AENamedRelationalExpr aENamedRelationalExpr = this.GetCommonTableExpression();
            aENamedRelationalExpr.setDataNeeded(aENamedRelationalExpr, n);
            return n;
        }
        return -1;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
    }

    public AEWithClause getReferencedWithClause() {
        return this.m_cteRef.getWithClause();
    }

    public void updateWithClause(AEWithClause aEWithClause) {
        this.m_cteRef.updateWithClause(aEWithClause);
    }
}

