/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aetree.relation;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.AEQTableName;
import com.databricks.client.sqlengine.aeprocessor.aetree.AESortSpec;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class AETable
extends AENamedRelationalExpr {
    private List<? extends IColumn> m_tableColumns;
    private DSIExtJResultSet m_table;
    private final SESortInfo m_passdownSortInfo;

    public AETable(DSIExtJResultSet dSIExtJResultSet) throws ErrorException {
        this(dSIExtJResultSet, null);
    }

    public AETable(DSIExtJResultSet dSIExtJResultSet, SESortInfo sESortInfo) throws ErrorException {
        this.m_table = Objects.requireNonNull(dSIExtJResultSet);
        this.m_tableColumns = Objects.requireNonNull(this.m_table.getSelectColumns());
        this.m_passdownSortInfo = sESortInfo;
    }

    private AETable(AETable aETable) {
        super(aETable);
        this.m_table = Objects.requireNonNull(aETable.m_table.copy());
        this.m_tableColumns = aETable.m_tableColumns;
        this.m_passdownSortInfo = aETable.m_passdownSortInfo;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AETable copy() {
        return new AETable(this);
    }

    public Iterator<IAENode> getChildItr() {
        return Collections.emptyList().iterator();
    }

    @Override
    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("AETable: ");
        stringBuilder.append(new AEQTableName(this.m_table.getCatalogName(), this.m_table.getSchemaName(), this.m_table.getTableName()));
        if (this.hasCorrelationName()) {
            stringBuilder.append(" AS ").append(this.getQTableName());
        }
        return stringBuilder.toString();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        return this == iAENode || iAENode instanceof AETable && ((AETable)iAENode).m_table == this.m_table;
    }

    @Override
    public IColumn getBaseColumn(int n) {
        return this.m_tableColumns.get(n);
    }

    public AEQTableName getBaseQTableName() {
        String string;
        AEQTableName.AEQTableNameBuilder aEQTableNameBuilder = new AEQTableName.AEQTableNameBuilder();
        String string2 = this.m_table.getCatalogName();
        if (null != string2) {
            aEQTableNameBuilder.setCatalogName(string2);
        }
        if (null != (string = this.m_table.getSchemaName())) {
            aEQTableNameBuilder.setSchemaName(string);
        }
        aEQTableNameBuilder.setTableName(this.m_table.getTableName());
        return aEQTableNameBuilder.build();
    }

    public String getBaseTableName() {
        return this.m_table.getTableName();
    }

    @Override
    public String getCatalogName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.m_table.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.m_table.getSchemaName();
    }

    @Override
    public String getTableName() {
        if (this.hasCorrelationName()) {
            return this.getCorrelationName();
        }
        return this.m_table.getTableName();
    }

    public DSIExtJResultSet getTable() {
        return this.m_table;
    }

    public void setTable(DSIExtJResultSet dSIExtJResultSet) {
        try {
            List<? extends IColumn> list = Objects.requireNonNull(dSIExtJResultSet.getSelectColumns());
            assert (list.size() == this.m_tableColumns.size());
            this.m_table = dSIExtJResultSet;
            this.m_tableColumns = list;
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
    }

    @Override
    public int getColumnCount() {
        return this.m_tableColumns.size();
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        if (aERelationalExpr.equals(this)) {
            this.m_table.setDataNeeded(n, true);
            return n;
        }
        return -1;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
    }

    @Override
    public boolean getDataNeeded(int n) {
        return this.m_table.getDataNeeded(n);
    }

    public SESortInfo GetPassdownSortInfo() {
        return this.m_passdownSortInfo;
    }

    public static final class SESortInfo {
        private final SESortOrder m_sortOrder;
        private final List<AESortSpec> m_sortSpecs;

        public SESortInfo(SESortOrder sESortOrder, List<AESortSpec> list) {
            this.m_sortOrder = Objects.requireNonNull(sESortOrder);
            this.m_sortSpecs = Collections.unmodifiableList(new ArrayList<AESortSpec>(list));
        }

        public SESortOrder getSortOrder() {
            return this.m_sortOrder;
        }

        public List<AESortSpec> getSortSpec() {
            return this.m_sortSpecs;
        }
    }

    public static enum SESortOrder {
        ODBC_ORDER,
        ODBC_ORDER_REVERSED,
        NOT_ODBC_ORDER;

    }
}

