/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aetree.relation;

import com.databricks.client.sqlengine.aeprocessor.aetree.AbstractAENodeList;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExprScope;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECycleClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESearchClause;
import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Objects;

public final class AEWithClause
extends AbstractAENodeList<AENamedRelationalExpr> {
    private final AEWithClause m_origin;

    public AEWithClause() {
        this.m_origin = null;
    }

    private AEWithClause(AEWithClause aEWithClause) {
        super(aEWithClause);
        this.m_origin = aEWithClause;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AEWithClause copy() {
        return new AEWithClause(this);
    }

    @Override
    public void addNode(AENamedRelationalExpr aENamedRelationalExpr) {
        throw new RuntimeException("Should not be called, use addCommonTableExpression instead.");
    }

    public void addCommonTableExpression(AENamedRelationalExpr aENamedRelationalExpr) throws ErrorException {
        String string = aENamedRelationalExpr.getTableName();
        if (this.resolveCommonTableExpression(string, true) != null) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.CTE_NOT_UNIQUE_IN_WITH_CLAUSE.name(), new String[]{string});
        }
        super.addNode(aENamedRelationalExpr);
    }

    public AEWithClause getOrigin() {
        return this.m_origin;
    }

    public boolean isRecursive() {
        return false;
    }

    public CTERef resolveCommonTableExpression(String string, boolean bl) throws ErrorException {
        Objects.requireNonNull(string);
        int n = -1;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            String string2 = ((AENamedRelationalExpr)this.getChild(i)).getTableName();
            if ((!bl || !string2.equals(string)) && (bl || !string2.equalsIgnoreCase(string))) continue;
            if (n >= 0) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TABLE_REF_MATCHES_MULT_CTES.name(), new String[]{string});
            }
            n = i;
        }
        if (n < 0) {
            return null;
        }
        return new CTERef(this, n);
    }

    public static final class CTERef {
        private AEWithClause m_parent;
        private final int m_index;

        private CTERef(AEWithClause aEWithClause, int n) {
            this.m_parent = Objects.requireNonNull(aEWithClause);
            if (n < 0 || n >= this.m_parent.getNumChildren()) {
                throw new IndexOutOfBoundsException(String.format("%d %c [0, %d)", n, Character.valueOf('\u2209'), this.m_parent.getNumChildren()));
            }
            this.m_index = n;
        }

        public AENamedRelationalExpr getCommonTableExpression() {
            return (AENamedRelationalExpr)this.m_parent.getChild(this.m_index);
        }

        public AEWithClause getWithClause() {
            return this.m_parent;
        }

        public AECycleClause getCycleClause() {
            return null;
        }

        public AESearchClause getSearchClause() {
            return null;
        }

        public long getScopeIdentifier() {
            return ((AECommonTableExprScope)this.m_parent.getParent()).getUniqueID();
        }

        public boolean isEquivalent(CTERef cTERef) {
            return this.m_index == cTERef.m_index && this.m_parent.isEquivalent(cTERef.m_parent);
        }

        public void updateWithClause(AEWithClause aEWithClause) {
            assert (aEWithClause.getOrigin() == this.m_parent);
            this.m_parent = aEWithClause;
        }
    }
}

