/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine;

import com.databricks.client.dsi.dataengine.impl.DSIErrorResult;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContext;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContexts;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResultType;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResults;
import com.databricks.client.dsi.dataengine.utilities.ParameterInputValue;
import com.databricks.client.dsi.exceptions.OperationCanceledException;
import com.databricks.client.sqlengine.dsiext.dataengine.AbstractExecutionContext;
import com.databricks.client.sqlengine.dsiext.dataengine.IExecutionContext;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.IStatementExecutor;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class BatchExecutionContext
extends AbstractExecutionContext {
    private final IStatementExecutor m_executor;
    private final boolean m_continueOnError;
    private final Map<Long, ErrorException> m_failedParameterSets = new HashMap<Long, ErrorException>();
    private final List<Long> m_failedParamSetsToNotify = new ArrayList<Long>();
    private long m_currentParameterSet = 0L;

    public BatchExecutionContext(IStatementExecutor iStatementExecutor, ExecutionContexts executionContexts, Map<Integer, ParameterInputValue[]> map, ETCancelState eTCancelState, boolean bl) {
        super(executionContexts, map, eTCancelState);
        this.m_executor = iStatementExecutor;
        this.m_continueOnError = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecutionResults execute(IWarningListener iWarningListener) throws ErrorException {
        Object object;
        Object object2;
        assert (this.m_currentParameterSet == 0L);
        ExecutionResults executionResults = new ExecutionResults();
        ExecutionResult[] executionResultArray = new ExecutionResult[(int)this.getParameterSetCount()];
        this.m_executor.registerWarningListener(iWarningListener);
        this.m_executor.startBatch();
        try {
            Iterator<ExecutionContext> iterator = this.m_contexts.contextIterator();
            while (iterator.hasNext()) {
                ++this.m_currentParameterSet;
                object2 = iterator.next();
                this.notifyStartingParameterSet(this.m_currentParameterSet);
                try {
                    if (this.isCanceled()) {
                        throw SQLEngineExceptionFactory.operationCanceledException();
                    }
                    object = this.executeOne(this.m_executor, (ExecutionContext)object2, this.m_currentParameterSet);
                    executionResultArray[(int)(this.m_currentParameterSet - 1L)] = object;
                    if (((ExecutionResult)object).getType() == ExecutionResultType.ROW_COUNT || !this.m_contexts.getIsPreparedStatementBatchExecution() || this.m_continueOnError) continue;
                    break;
                }
                catch (ErrorException errorException) {
                    if (this.m_listeners.isEmpty()) {
                        throw errorException;
                    }
                    this.postError(this.m_currentParameterSet, errorException);
                    if (!(errorException instanceof OperationCanceledException) && this.m_continueOnError) continue;
                    break;
                }
                finally {
                    if (!this.m_failedParamSetsToNotify.isEmpty()) {
                        for (Long l : this.m_failedParamSetsToNotify) {
                            this.notifyParameterSetFailed(l);
                        }
                        this.m_failedParamSetsToNotify.clear();
                    }
                    this.notifyFinishedParameterSet(this.m_currentParameterSet);
                }
            }
            this.m_executor.endBatch();
        }
        finally {
            this.m_executor.close();
        }
        int n = 0;
        while ((long)n < this.m_currentParameterSet) {
            object2 = executionResultArray[n];
            object = (long)(n + 1);
            if (this.m_failedParameterSets.containsKey(object)) {
                object2 = new ExecutionResult(new DSIErrorResult(this.m_failedParameterSets.get(object)), false);
            }
            assert (object2 != null);
            executionResults.addExecutionResult((ExecutionResult)object2);
            ++n;
        }
        return executionResults;
    }

    @Override
    public long getCurrentParameterSet() {
        return this.m_currentParameterSet;
    }

    @Override
    public long getParameterSetCount() {
        return this.m_contexts.getCount();
    }

    @Override
    public void postError(long l, ErrorException errorException) {
        assert (errorException != null);
        assert (l > 0L);
        assert (l <= (long)this.m_contexts.getCount());
        assert (l == this.getCurrentParameterSet() || this.m_continueOnError);
        if (this.m_failedParameterSets.containsKey(l)) {
            this.m_failedParameterSets.get(l).addSuppressed(errorException);
        } else {
            this.m_failedParameterSets.put(l, errorException);
            this.m_failedParamSetsToNotify.add(l);
        }
    }

    @Override
    public void registerListener(IExecutionContext.Listener listener) {
        this.m_listeners.add(Objects.requireNonNull(listener));
    }
}

