/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.relation;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IETNodeVisitor;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.databricks.client.support.exceptions.ErrorException;

public class ETSubQuery
extends ETUnaryRelationalExpr {
    private final boolean m_isCorrelated;
    private boolean m_isOpen;
    private boolean m_operandIsOpen;
    private CursorType m_cursorType;

    public ETSubQuery(ETRelationalExpr eTRelationalExpr, boolean bl, boolean[] blArray) {
        super(eTRelationalExpr, blArray);
        this.m_isCorrelated = bl;
        if (this.m_isCorrelated) {
            eTRelationalExpr.setCanReopenAfterClosed();
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.getOperand().getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.getOperand().getColumnCount();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.getOperand().getRowCount();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        assert (this.m_isOpen);
        assert (this.m_operandIsOpen);
        return this.getOperand().retrieveData(n, eTDataRequest);
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        assert (!this.m_isOpen);
        assert (!this.m_operandIsOpen);
        this.m_cursorType = cursorType;
        if (!this.m_isCorrelated) {
            this.openOperandIfClosed();
        }
        this.m_isOpen = true;
    }

    @Override
    public void reset() throws ErrorException {
        assert (this.m_isOpen);
        if (this.m_isCorrelated) {
            this.closeOperandIfOpen(true);
            this.openOperandIfClosed();
        } else {
            assert (this.m_operandIsOpen);
            this.getOperand().reset();
        }
    }

    @Override
    public void close(boolean bl) {
        this.closeOperandIfOpen(bl);
        this.m_cursorType = null;
        this.m_isOpen = false;
    }

    @Override
    protected boolean doMove() throws ErrorException {
        assert (this.m_isOpen);
        if (this.m_isCorrelated) {
            this.openOperandIfClosed();
        }
        return this.getOperand().move();
    }

    private void closeOperandIfOpen(boolean bl) {
        if (this.m_operandIsOpen) {
            this.getOperand().close(bl);
            this.m_operandIsOpen = false;
        }
    }

    private void openOperandIfClosed() throws ErrorException {
        if (!this.m_operandIsOpen) {
            this.getOperand().open(this.m_cursorType);
            this.m_operandIsOpen = true;
        }
    }
}

