/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.temptable.column;

import com.databricks.client.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.databricks.client.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.databricks.client.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.databricks.client.sqlengine.executor.etree.temptable.column.IColumnSlice;

public final class RealColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = -1486808935311312641L;
    private float[] m_data;
    private byte[] m_nullInd;
    private final int m_columnNumber;

    public RealColumnSlice(int n, int n2) {
        this.m_data = new float[n];
        this.m_nullInd = new byte[(n + 7) / 8];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return BitsUtil.isSet(this.m_nullInd, n);
    }

    @Override
    public void setNull(int n) {
        BitsUtil.setBit(this.m_nullInd, n);
    }

    @Override
    public float getReal(int n) {
        return this.m_data[n];
    }

    @Override
    public double getDouble(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.REAL;
    }

    @Override
    public void setReal(int n, float f) {
        this.m_data[n] = f;
        BitsUtil.clearBit(this.m_nullInd, n);
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        RealColumnSlice realColumnSlice = (RealColumnSlice)iColumnSlice;
        System.arraycopy(realColumnSlice.m_data, n, this.m_data, n3, n2);
        BitsUtil.copy(this.m_nullInd, n3, n2, realColumnSlice.m_nullInd, n);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return 0.0;
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return (double)javaSize.getFloatSize() + (double)javaSize.getByteSize() / 8.0;
    }
}

