/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.support.security;

import com.databricks.client.support.ILogger;
import com.databricks.client.support.security.ISecurityContext;
import com.databricks.client.support.security.SimbaCredentials;
import com.databricks.client.support.security.SimbaSecurityContext;
import java.security.PrivilegedAction;
import java.util.Collections;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

class SimbaAuthenticatedCredentials
extends SimbaCredentials {
    private final ILogger m_logger = null;
    private final GSSContext m_remoteContext;
    private final GSSManager m_gssManager;
    private Subject m_subject = null;

    public SimbaAuthenticatedCredentials(ILogger iLogger, GSSManager gSSManager, GSSContext gSSContext) {
        this.m_remoteContext = gSSContext;
        this.m_gssManager = gSSManager;
    }

    @Override
    GSSCredential getCredentialHandle() throws GSSException {
        return this.m_remoteContext.getDelegCred();
    }

    @Override
    public ISecurityContext getSecurityContext(String string) throws Exception {
        return new SimbaSecurityContext(this, this.m_logger, string, this.m_gssManager);
    }

    @Override
    public String getName() throws Exception {
        return this.m_remoteContext.getSrcName().toString();
    }

    @Override
    public Object executeAs(PrivilegedAction privilegedAction) throws Exception {
        if (null == this.m_subject) {
            GSSCredential gSSCredential = this.m_remoteContext.getDelegCred();
            this.m_subject = new Subject(false, Collections.singleton(new KerberosPrincipal(this.m_remoteContext.getSrcName().toString())), Collections.emptySet(), gSSCredential == null ? null : Collections.singleton(gSSCredential));
        }
        return Subject.doAsPrivileged(this.m_subject, privilegedAction, null);
    }
}

