/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.compute.CreateResponse;
import com.databricks.internal.sdk.service.compute.DeleteGlobalInitScriptRequest;
import com.databricks.internal.sdk.service.compute.GetGlobalInitScriptRequest;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptCreateRequest;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptDetailsWithContent;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptUpdateRequest;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptsService;
import com.databricks.internal.sdk.service.compute.ListGlobalInitScriptsResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class GlobalInitScriptsImpl
implements GlobalInitScriptsService {
    private final ApiClient apiClient;

    public GlobalInitScriptsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateResponse create(GlobalInitScriptCreateRequest request) {
        String path = "/api/2.0/global-init-scripts";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteGlobalInitScriptRequest request) {
        String path = String.format("/api/2.0/global-init-scripts/%s", request.getScriptId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GlobalInitScriptDetailsWithContent get(GetGlobalInitScriptRequest request) {
        String path = String.format("/api/2.0/global-init-scripts/%s", request.getScriptId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GlobalInitScriptDetailsWithContent.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListGlobalInitScriptsResponse list() {
        String path = "/api/2.0/global-init-scripts";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListGlobalInitScriptsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(GlobalInitScriptUpdateRequest request) {
        String path = String.format("/api/2.0/global-init-scripts/%s", request.getScriptId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

