/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.auth;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.HeaderFactory;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.auth.AzureMSICredentials;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.util.HashMap;

public class AzureMSICredentialProvider
implements CredentialsProvider {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(AzureMSICredentialProvider.class);
    private final IDatabricksHttpClient httpClient;
    private final String resourceId;
    private final String clientId;

    public AzureMSICredentialProvider(IDatabricksConnectionContext connectionContext) {
        this.httpClient = DatabricksHttpClientFactory.getInstance().getClient(connectionContext);
        this.clientId = connectionContext.getNullableClientId();
        this.resourceId = connectionContext.getAzureWorkspaceResourceId();
    }

    @VisibleForTesting
    AzureMSICredentialProvider(IDatabricksConnectionContext connectionContext, IDatabricksHttpClient httpClient) {
        this.httpClient = httpClient;
        this.clientId = connectionContext.getNullableClientId();
        this.resourceId = connectionContext.getAzureWorkspaceResourceId();
    }

    @Override
    public String authType() {
        return "azure-msi";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig databricksConfig) {
        AzureMSICredentials azureMSICredentials = new AzureMSICredentials(this.httpClient, this.clientId);
        return () -> {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            if (this.resourceId != null) {
                LOGGER.warn("In case of Azure MSI configuration, azure_workspace_resource_id parameter should not be null.");
                headers.put("X-Databricks-Azure-Workspace-Resource-Id", this.resourceId);
                headers.put("X-Databricks-Azure-SP-Management-Token", azureMSICredentials.getManagementEndpointToken().getAccessToken());
            }
            headers.put("Authorization", "Bearer " + azureMSICredentials.getToken().getAccessToken());
            return headers;
        };
    }
}

